#ifndef CL_BTLIST_H_INCLUDED
#define CL_BTLIST_H_INCLUDED

#include <app_context.h>
#include <d32dbms.h>
#include <bamdesca.h>

#include "circular.h"

class CBTDeviceList : public CBase
{
public:
	static CBTDeviceList* NewL(MApp_context& Context, RDbDatabase& Db, const TDesC& aTableName);
	virtual ~CBTDeviceList();
	
	virtual MDesCArray* NameArray() = 0;
	virtual MDesC8Array* AddrArray() = 0;

	virtual void AddObserver(MListObserver* aObserver) = 0;
	virtual void RemoveObserver(MListObserver* aObserver) = 0;

	virtual TInt AddDeviceL(const TDesC& Name, const TDesC8& Address) = 0;
	virtual void RemoveDeviceL(TInt Idx) = 0;
	virtual void MoveUpL(TInt Idx) = 0;
	virtual void MoveDownL(TInt Idx) = 0;

	virtual TBool ContainsDevice(const TDesC8& Address) = 0;
	virtual TInt  FindbyReadable(const TDesC& Readable) = 0;
};

#endif
