/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#if !defined(FILE_LOGGER_H_INCLUDED)

#define FILE_LOGGER_H_INCLUDED

#include "i_logger.h"
#include "i_log_source.h"
#include "file_output_base.h"
#include <pausable.h>
#include <settings.h>

class Cfile_logger : public Mlogger, public Mfile_output_base, public CBase, public MPausable, public MSettingListener {
public:
	virtual void NewValueL(TUint aId, const TTupleName& aName, const TDesC& aSubName, const MBBData* aData);
	virtual void NewSensorEventL(const TTupleName& aName, const TDesC& aSubName, const CBBSensorEvent& aEvent);
	virtual void new_value(TInt priority, const TDesC& aSource, const TDesC& aValue, const TTime& time);

	Cfile_logger(MApp_context& Context, CBBSensorEvent::TPriority limit=CBBSensorEvent::VALUE);
	virtual ~Cfile_logger();
	void ConstructL(const TDesC& prefix);
	static Cfile_logger* NewL(MApp_context& Context,
				 const TDesC& prefix, CBBSensorEvent::TPriority limit=CBBSensorEvent::VALUE);
	void pause();
	void unpause();
	bool is_paused();
private:
	virtual void write_to_output(const TDesC& str);
	virtual void SettingChanged(TInt Setting);
	void get_value(const CBBSensorEvent& aEvent);
	void get_value(const MBBData* aData);

	CBBSensorEvent::TPriority priority_limit;
	bool	enabled;
	HBufC*	iBuf;

};

#endif
