#ifndef CONTEXT_LOCA_LOGIC_H_INCLUDED
#define CONTEXT_LOCA_LOGIC_H_INCLUDED 1

#include <csd_bluetooth.h>
#include <e32std.h>
#include <e32base.h>
#include <db.h>

const TTupleName KLocaLogicTuple = { { CONTEXT_UID_CONTEXTSENSORS }, 35 };
const TTupleName KRemoteLocaLogicTuple = { { CONTEXT_UID_CONTEXTSENSORS }, 37 };

const TComponentName KLocaComponent =  { { CONTEXT_UID_CONTEXT_LOG }, 2 };

class CLocaLogic : public CBase {
public:
	static CLocaLogic* NewL(MApp_context& Context, RDbDatabase& aDb);

	// name and title max length 240
	virtual void GetMessage(const TBBBtDeviceInfo& aDevice,
		TInt	aEnvironmentCount,
		const TTime& aAtTime,
		TBool& doSend, 
		TInt& aMessageCode, TDes& aWithName,
		TDes& aWithTitle, HBufC8*& aBody) = 0;

	enum TSendFailure {
		ETimeOut,
		ERefused,
		EUnknown
	};
	virtual void Failed(const TBBBtDeviceInfo& aDevice,
		TInt aMessageCode,
		const TTime& aAtTime,
		TSendFailure aErrorCode,
		TBool	aLocal) = 0;
	virtual void Success(const TBBBtDeviceInfo& aDevice,
		TInt aMessageCode,
		const TTime& aAtTime,
		TBool	aLocal) = 0;
};

#endif