/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#ifndef CL_PRESENCE_PUBLISHER_H_INCLUDED
#define CL_PRESENCE_PUBLISHER_H_INCLUDED 1

#include <app_context.h>
#include "ContextClientSession.h"
#include "ftp.h"
#include <xmlbuf.h>
#include "status_notif.h"
#include "notifystate.h"
#include "btlist.h"
#include <csd_presence.h>
#include <connectioninit.h>
#include <bbxml.h>
#include <settings.h>

class MPresencePublisherListener
{
public:
	virtual void NotifyNewPresence(const CBBPresence* Data)=0;
};

class CPresencePublisher : public CCheckedActive, public Mlogger, public MContextBase, 
		public MTimeOut, public MSettingListener, public MNetworkConnection {
public:
	static CPresencePublisher* NewL(MApp_context& Context, i_status_notif* CallBack, 
		MPresencePublisherListener& aListener,  CBTDeviceList *aBuddyList,
		CBTDeviceList *aLaptopBTs, CBTDeviceList *aDesktopBTs, CBTDeviceList *aPDABTs);
	~CPresencePublisher();

	void SuspendConnection();
	void ResumeConnection();
	bool ConnectionSuspended();
	bool Disabled();

	const CBBPresence* Data() const;

private:
	CPresencePublisher(MApp_context& Context, i_status_notif* CallBack, 
		MPresencePublisherListener& aListener,  CBTDeviceList *aBuddyList,
		CBTDeviceList *aLaptopBTs, CBTDeviceList *aDesktopBTs, CBTDeviceList *aPDABTs);
	void ConstructL();
	void Restart();
	void SendUpdate();
	void MakePresence();
	void QueueUpdate();

	// Mlogger
	virtual void NewSensorEventL(const TTupleName& aName, const TDesC& aSubName, const CBBSensorEvent& aData);

	// CCheckedActive
	void CheckedRunL();
	void DoCancel();
	virtual TInt CheckedRunError(TInt aError);

	// MTimeOut
	void expired(CBase*);

	// MSettingListener
	void SettingChanged(TInt Setting);

	CBBPresence*	iData;

	// data
	enum EState { EUnknown, EReconnecting, EConnecting, EConnected, EQueuingUpdate,
		ESendingUpdate, ESuspending, ESuspended, EResuming, EDisabling, EDisabled };
	EState			iCurrentState;
	enum ENextOp { ENone, ESuspend, EResume, EDisable, EEnable };
	ENextOp			iNextOp;

	bool			iNewValue;

	RContextClientSession	iSession;
	TBuf<30>		iUser, iPass, iServer;
	CTimeOut*		iWait;
	TInt			iWaitTime;
	TInt			iAP;
	CXmlBufExternalizer*	iPresence;
	HBufC*			iSendPresence;
	TTime			iSentTimeStamp;

	i_status_notif*		iCallBack;
	class CApp_context*	ctx;


	MPresencePublisherListener& iListener;
	CNotifyState		*iPresenceRunning;
	CBTDeviceList		*iBuddyList, *iLaptopBTs, *iDesktopBTs, *iPDABTs;
};

#endif
