#ifndef CL_TEST_LOG_H_INCLUDED
#define CL_TEST_LOG_H_INCLUDED 1

#include <e32base.h>
#include "i_logger.h"

class MOutput {
public:
	virtual void Print(const TDesC& aString) = 0;
};

class CTestLog : public Mlogger, public CBase
{
public:
	static CTestLog* NewL(MOutput& aOutput);
	virtual ~CTestLog();

	struct TExpectItem {
		log_priority	iPriority;
		TBuf<60>	iSource;
		TBuf<100>	iString;
		TTime		iTime;

		TExpectItem(log_priority aPriority, const TDesC& aSource,
			const TDesC& aString, const TTime aTime) :
			iPriority(aPriority), iSource(aSource),
			iString(aString), iTime(aTime) { }
		TExpectItem() : iPriority(), iSource(), iString(), iTime() { }
		void Print(MOutput& Into) {
			Into.Print(iSource);
			Into.Print(_L(": '"));
			Into.Print(iString);
			Into.Print(_L("' ("));
			switch (iPriority) {
			case INFO:
				Into.Print(_L("INFO"));
				break;
			case DEBUG:
				Into.Print(_L("DEBUG"));
				break;
			case VALUE:
				Into.Print(_L("VALUE"));
				break;
			case ERR:
				Into.Print(_L("ERR"));
				break;
			}
			Into.Print(_L(" "));
			TBuf<30> dt;
			dt.AppendNum(iTime.Int64());
			Into.Print(dt);
			Into.Print(_L(")"));
		}
		bool operator==(const TExpectItem i) const {
			if (	iPriority==i.iPriority &&
				!(iSource.Compare(i.iSource)) &&
				iTime==i.iTime &&
				!(iString.Compare(i.iString)) ) return true;
			return false;
		}
	};
	virtual TExpectItem& Expect(log_priority aPriority, const TDesC& aSource,
		const TDesC& aString, const TTime aTime) = 0;
	virtual TExpectItem& Expect(TExpectItem e) = 0;
	virtual void DontExpect() = 0;
	virtual void GotP() = 0;


};

#endif
