#!/usr/bin/perl

@files=<log*.txt>;
$DEFAULT_NW="RADIOLINJA";

sub twonum($)
{
	my $n=$_[0];
	if ($n<10) { return "0" . $n; }
	return $n;
}

sub read_data
{
	my $count=0;
	foreach $file (@files) {
		open(IN, "<$file");
		while (<IN>) {
			next unless (/area, cell/);
			next if (/STOPPING/);
			chop; chop;
			s/ STARTING//;
			/^([^ ]*) area, cell[^:]*: *(.*)/;
			($datetime, $id)=($1, $2);
			if ($id =~ /^[^,]*,[^,]*$/) {
				$id.=", " . $DEFAULT_NW;
			}
			$datetime=~/(....)(..)(..)T(..)(..)(..)/;
			$datetime=$1 . twonum($2-1) . twonum($3-1) 
				. ":" . $4 . $5 . $6;
			push(@data, [ $datetime, $id] );
			$count++;
		}
		push(@data, [ $datetime, "SWITCH" ]);
	}
}

&read_data;

$real_count=$#data+1;
$compile_count=$#data;
if ($#data>9999) {
	$compile_count=9999;
}

open(OUT, ">bases_test_data.h") || die "cannot open bases_test_data.h";
print OUT "#define TEST_DATA_COUNT ", $compile_count+1, "\n";
print OUT "#define AVAILABLE_DATA_COUNT ", $real_count, "\n";
close(OUT);

open(OUT, ">bases_test_data.cpp") || die "cannot open bases_test_data.cpp";
open(OUT2, ">bases_test_data.txt") || die "cannot open bases_test_data.txt";
print OUT "#include \"bases.h\"\n";
print OUT "const unsigned short* bases::test_data[", $#data+1, "] [2] = {\n";
$i=0;
foreach $d (@data) {
	($datetime, $id) = @{$d};
	if ($i<=$compile_count) {
		print OUT "\t{ L\"", $datetime, "\", L\"", $id, "\" },\n";
	}
	print OUT2 $datetime, "\t", $id, "\n";
	$i++;
}

print OUT "};\n";
close(OUT);
close(OUT2);
