/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#pragma warning(disable: 4706)

// INCLUDE FILES
#include "Context_logAppUi.h"
#include "Context_logContainer.h" 
#include <context_log.rsg>
#include <sendnorm.rsg>
#include "local_defaults.h"
#include "context_log.hrh"
#include "context_logapp.h"

//#define CONTEXTNW 1
//#undef CONTEXTNW
//#undef LOCA

#include <avkon.hrh>
#include <aknquerydialog.h> 
#include <eikenv.h> // ieikonenv
#include <apgtask.h> // Going background 

#include <eikmenup.h>
#include <eiklabel.h>
#include <apgcli.h>

#include <stdlib.h> // for CloseSTDLIB()
#include <bautils.h>

#include <RPbkViewResourceFile.h>
#include <CPbkContactEditorDlg.h>
#include <CPbkContactEngine.h>
#include <CPbkSelectFieldDlg.h>
#include <CPbkContactItem.h>

#include "sms.h"

#include "keycapture.h"
#include <apgwgnam.h>

#include "userview.h"
#include "presencedetailview.h"
#include "presencedescriptionview.h"

#include "cl_settings.h"
#include "log_systemevent.h"
#include "log_shareddata.h"

#include <eikdll.h>
#include <sacls.h>

const TInt KUidBatteryBarsValue = 0x100052D3;
const TUid KUidBatteryBars ={KUidBatteryBarsValue};
const TInt KUidChargerCStatusValue = 0x100052D7;
const TUid KUidChargerCStatus = {KUidChargerCStatusValue};

#include "hideview.h"

#include "notifystate.h"
#include <context_log.mbg>
#include "btlist.h"
#include "transferdir2.h"
#include "viewids.h"

#include "raii_apgcli.h"
#include "raii_f32file.h"

#include "csd_system.h"
#include "csd_event.h"
#include "log_battery.h"
#include "csd_battery.h"

#include "loca_sender.h"
#include "sms_status.h"
#include "callstack.h"
#include "reporting.h"
#include "app_context_impl.h"
#include "app_context_fileutil.h"
#include "presence_ui_helper.h"
#include "picture_publisher.h"

#include "log_alarm.h"
#include "log_unread.h"
#include "contextnotifyclientsession.h"

//#include <syevdef.h>

enum JOYSTICK_EVENTS {
	JOY_LEFT = 0xF807,
	JOY_RIGHT = 0xF808,
	JOY_UP = 0xF809,
	JOY_DOWN = 0xF80A,
	JOY_CLICK = 0xF845
};

const TUid KUidPhone = { 0x100058b3 };
const TUid KUidMenu = {  0x101f4cd2 };

const TInt KUidCloseLogValue=0x2003;
const TUid KUidCloseLog={KUidCloseLogValue};
const TInt KUidToBackgroundValue=0x2004;
const TUid KUidToBackground={KUidToBackgroundValue};

#ifndef __WINS__
const TInt KWatchDogTimeOut=5*60;
#else
const TInt KWatchDogTimeOut=1*60;
#endif

_LIT(cellid_file_v1, "cellid_names.txt");
_LIT(cellid_file, "cellid_names_v2.txt");
_LIT(install_cellid_file, "cellid_names_inst_v2.txt");
_LIT(transfer_cellid_file, "cellid_names_trans_v2.txt");

#ifndef __WINS__
_LIT(KIconFile, "c:\\system\\data\\context_log.mbm");
#else
_LIT(KIconFile, "z:\\system\\data\\context_log.mbm");
#endif

_LIT(file_prefix, "log");

_LIT(KCharger, "charger");
_LIT(KNetworkStatus, "network_status");
_LIT(KAppEvent, "app_event");
_LIT(KCellAnnotation, "cell_ann");
_LIT(KSMS, "SMS ");
_LIT(KContextAnnotation, "context_ann");
_LIT(KBattery, "battery");
_LIT(KBtConnections, "bt_connectioncount");
_LIT(KBtSearchMode, "bt_searchmode");

#include "csd_idle.h"
#include "ntpconnection.h"


#ifdef __WINS__
class TDummyMsvObserver : public MMsvSessionObserver
{
	void HandleSessionEvent(TMsvSessionEvent, TAny*, TAny*, TAny*) { }
	void HandleSessionEventL(TMsvSessionEvent, TAny*, TAny*, TAny*) { }
};
#endif

void CContext_logAppUi::ReportError(const TDesC& Source,
	const TDesC& Reason, TInt Code)
{
	_LIT(err, "error");
	TBBLongString msg(err);
	msg()=_L("Unhandled error ");
	msg().AppendNum(Code);
	msg().Append(_L(" "));
	msg().Append(Reason.Left(120));
	if (app_log) {
		
		TInt err;
		TRAP(err, app_log->post_new_value(&msg));
		TRAP(err, fl->new_value(CBBSensorEvent::ERR, _L("APP"), Source, GetTime()));
	}
}

TErrorHandlerResponse CContext_logAppUi::HandleError(TInt aError,
     const SExtendedError& /*aExtErr*/,
     TDes& aErrorText,
     TDes& aContextText)
{
	// TODO: handle aExtErr
	TInt err;
	if (fl) {
		TBuf<128> msg;
		msg.Format(_L("Unhandled error %d %S %S"), aError, &aContextText, &aErrorText);
		TTime t=GetTime();
		TRAP(err, fl->new_value(CBBSensorEvent::ERR, _L("app_event"), msg, t));

		HBufC* stack=CallStackMgr().GetFormattedCallStack(_L("AppUi"));
		if (stack) {
			TRAP(err, fl->new_value(CBBSensorEvent::ERR, _L("app_event"), *stack, t));
		}
		delete stack;
		CallStackMgr().ResetCallStack();
	}

	PrepareToExit();
	//CActiveScheduler::Stop();
	RDebug::Print(_L("delete this"));
	delete this;
	RDebug::Print(_L("User::Exit"));

	// const TInt KContextErrTimeoutInBBProtocol=-11001;
	if (aError==-11001) {
		// will notify starter to restart phone
		// if occurs more than once
		User::Exit(2004);
	} else {
		User::Exit(2003);
	}

	return ENoDisplay;
}

void CContext_logAppUi::LogAppEvent(const TDesC& msg)
{
	CALLSTACKITEM_N(_CL("CContext_logAppUi"), _CL("LogAppEvent"));

	_LIT(KApp, "app");
	TBBLongString m(msg, KApp);
	if (iLastLog) iLastLog->AddL(msg);
	if (app_log) app_log->post_new_value(&m);
}

void CContext_logAppUi::ConstructL()
{
	CALLSTACKITEM_N(_CL("CContext_logAppUi"), _CL("ConstructL"));


#ifdef __WINS__

	// buggers up watchdog timings in starter
	SetTime();
        TTime now;
        now.HomeTime();
        now+=TTimeIntervalHours(2);
        //User::SetHomeTime(now);

#endif

#ifdef __WINS__
	//{ TRAPD(errs, StartStarterL(_L("context_log"), KUidcontext_log, true, iEikonEnv->WsSession())); }
#else
	{ TRAPD(errs, StartStarterL(_L("context_log"), KUidcontext_log, true)); }
#endif

	state=_L("setting exception handler");

	RThread me;
	me.Open(me.Id());
	me.SetExceptionHandler(exceptionhandler, 
		KExceptionAbort|KExceptionFault|KExceptionFpe|KExceptionInteger|
		KExceptionKill|KExceptionUserInterrupt);
	me.Close();

#ifndef __WINS__
	bool wins=false;
#else
	bool wins=true;
#endif

	state=_L("fl");
	fl=Cfile_logger::NewL(AppContext(), file_prefix, CBBSensorEvent::INFO);
	AppContext().SetFileLog(fl);

#ifndef DONT_LOG_EVENTS_TO_FILE
	fl->SubscribeL(KAnySensorEvent);
#else
	// we always want errors to be logged
	fl->SubscribeL(KAppEventTuple);
#endif

	Mlogger::ConstructL(AppContext());

	iWatchDogTimer=CTimeOut::NewL(*this);
	iWatchDogTimer->Wait(5);

	state=_L("BaseConstructL");

	BaseConstructL();

	CLocalNotifyWindow::CreateAndActivateL();

	state=_L("create status view");
	iStatusView = CStatusView::NewL(AppContext());
	iAppContainer = iStatusView->Container();
	AddViewL( iStatusView );      // transfer ownership to CAknViewAppUi
	SetDefaultViewL(*iStatusView);

#if CONTEXTNW
	state=_L("bbl");
	bbl=CBBLogger::NewL(AppContext(),this);
#endif

	state=_L("create app event");
	app_log=Clog_base_impl::NewL(AppContext(), KAppEvent, KAppEventTuple);

	Reporting().SetActiveErrorReporter(this);

	TBool logging_enabled;
	Settings().GetSettingL(SETTING_LOGGING_ENABLE, logging_enabled);
	TInt notif_err;
	TRAP(notif_err, iLoggingRunning=CNotifyState::NewL(AppContext(), KIconFile));
	if (logging_enabled) {
		if(iLoggingRunning) iLoggingRunning->SetCurrentState( EMbmContext_logL, EMbmContext_logL );
	} else {
		if(iLoggingRunning) iLoggingRunning->SetCurrentState( EMbmContext_logL_not, EMbmContext_logL_not );
	}

	state=_L("creating op waiter");

	iWait=CTimeOut::NewL(*this);
	iWaitingOps=CList<TCallBack>::NewL();


	iBTDb=CDb::NewL(AppContext(), _L("BTDEV"), EFileRead|EFileWrite|EFileShareAny);

#ifndef NO_PRESENCE

	iBuddyBTs = CBTDeviceList::NewL(AppContext(), iBTDb->Db(), _L("BUDDIES"));
	iLaptopBTs = CBTDeviceList::NewL(AppContext(), iBTDb->Db(), _L("LAPTOPS"));
	iDesktopBTs = CBTDeviceList::NewL(AppContext(), iBTDb->Db(), _L("DESKTOPS"));
	iPDABTs = CBTDeviceList::NewL(AppContext(), iBTDb->Db(), _L("PDAS"));
#endif //NO_PRESENCE

#ifdef LOCA
	state=_L("LocaSender");
	iLocaSender=CLocaSender::NewL(AppContext());
#endif

	ringing=false;

	iCaptionMyContext=CEikonEnv::Static()->AllocReadResourceL(R_ME_CAPTION);
	
	state=_L("notify");

	Settings().NotifyOnChange(SETTING_LOGGING_ENABLE, this);

	//__UHEAP_MARK;

	state=_L("smsh");

	//iSmsSocket=CSmsSocket::NewL(AppContext(), _L("itse"), this);

	smsh=new (ELeave) sms;
	smsh->ConstructL();

#if DO_SMS_STATUS
	state=_L("sms status");
	iSmsStatus=CSmsStatusReplier::NewL(AppContext(), smsh);
#endif


#ifndef NO_PRESENCE
	state=_L("iUserContextLog");

	iUserContextLog=CCircularLog::NewL(1,ETrue);
	
	CEikonEnv::Static()->ReadResourceAsDes16(prev, R_PREVIOUS);
	CEikonEnv::Static()->ReadResourceAsDes16(not_avail, R_JABBER_NOT_AVAIL);

	iUserContext=HBufC::NewL(iCaptionMyContext->Length()+256);
	PresenceToListBoxL(0, iUserContext, iCaptionMyContext, 0,
		prev, not_avail);
	iUserContextLog->AddL(*iUserContext);

#endif


	LogAppEvent(_L("Starting"));
	iLastLog=CCircularLog::NewL(20, true);

	LogAppEvent(_L("Starting 1.2"));
	state=_L("create cell map");
	iCellDb=CDb::NewL(AppContext(), _L("CELLS"), EFileRead|EFileWrite);

	LogAppEvent(_L("Starting 1.5"));
	iOpMap=COperatorMap::NewL(AppContext()); 

	TBool transfer_old_cell_ids=EFalse;
	if (! BaflUtils::FileExists(Fs(), _L("c:\\system\\data\\context\\cells.db"))) {
		transfer_old_cell_ids=ETrue;
	}
	iCellMap=CCellMap::NewL(AppContext(), iCellDb->Db(), iOpMap);

	if (transfer_old_cell_ids) {
		// NOTE: we must construct base_counter directly after
		// cellmap so that the mappings get transfered correctly
		// from the base db to the cell map db after upgrading

		LogAppEvent(_L("Starting 2"));

		state=_L("create base counter");
		base_counter=new (ELeave) bases(AppContext());
		base_counter->ConstructL(true, iCellMap);
		// base_counter->test(iOpMap, iCellMap); // NOP on ARMI
		delete base_counter; base_counter=0;
	}

	SubscribeL(KLocationTuple);
	//return;

	//iRouteRecorder = CRouteRecorder::NewL(AppContext(), *iCellMap, *base_counter);

	iLoggers=new (ELeave) CArrayPtrFlat<Mlog_base_impl>(10);
	iMediaPublishers=new (ELeave) CArrayPtrFlat<CPicturePublisher>(10);

	discoverer=CDiscover::NewL(AppContext());
	iLoggers->AppendL(discoverer);

#ifndef NO_PRESENCE
	state=_L("create presence publisher");
	iPresencePublisher=CPresencePublisher::NewL(AppContext(), this, *this, 
		iBuddyBTs, iLaptopBTs, iDesktopBTs, iPDABTs);
	LogAppEvent(_L("Starting 2.1"));
	RestoreUserGiven();
	LogAppEvent(_L("Starting 2.2"));
#endif

	iTransferDir=CTransferDir::NewL(AppContext(), *this, _L("TRANSFER"));

#if !defined(REALLY_ONLY_LOGGING) && !defined(NO_PRESENCE)
	state=_L("create upload view");
	TUid uploadv1=KUploadView1;
	iUploadView = CUploadView::NewL(AppContext(), iPresencePublisher->Data(), &(iStatusView->iNextViewId),
		uploadv1, false, discoverer);
	AddViewL( iUploadView );      // transfer ownership to CAknViewAppUi

	TUid uploadv2=KUploadView2;
	iUploadViewTagOnly = CUploadView::NewL(AppContext(), iPresencePublisher->Data(), &(iStatusView->iNextViewId),
		uploadv2, true, discoverer);
	AddViewL( iUploadViewTagOnly );      // transfer ownership to CAknViewAppUi

	state=_L("create code prompt");
	TUid statusv=KStatusView;
	
#ifdef USE_VISUALCODES
	iCodePrompt=CVisualCodePrompt::NewL(this, statusv, &(iStatusView->iNextViewId));
#endif

	state=_L("create multiprompt");
	iMultiPrompt=CMultiPrompt::NewL(AppContext());
	iMultiPrompt->AddPromptL(0, iUploadView);
	iMultiPrompt->AddPromptL(1, iUploadViewTagOnly);
	iMultiPrompt->AddPromptL(2, iCodePrompt);
	MUploadPrompt *pr=iMultiPrompt;

	TBool del = ETrue;
	Settings().GetSettingL(SETTING_OPTIONS_ENABLE, del);
	iOldPrompt = new (ELeave) TOldPrompt(del);

	state=_L("create picture publisher");
	AddMediaPublisher(CPicturePublisher::NewL(AppContext(), *this, _L("?:\\nokia\\images"),
		_L("*jpg"), SETTING_MEDIA_UPLOAD_ENABLE, MEDIA_PUBLISHER_CL, SETTING_PUBLISH_URLBASE, SETTING_PUBLISH_SCRIPT, *pr, *iOldPrompt, iTransferDir));
	AddMediaPublisher(CPicturePublisher::NewL(AppContext(), *this, _L("?:\\images"),
		_L("*jpg"), SETTING_MEDIA_UPLOAD_ENABLE, MEDIA_PUBLISHER_CL, SETTING_PUBLISH_URLBASE, SETTING_PUBLISH_SCRIPT, *pr, *iOldPrompt, iTransferDir));

	AddMediaPublisher(CPicturePublisher::NewL(AppContext(), *this, _L("?:\\nokia\\videos"),
		_L("*3gp"), SETTING_MEDIA_UPLOAD_ENABLE, MEDIA_PUBLISHER_CL, SETTING_PUBLISH_URLBASE, SETTING_PUBLISH_SCRIPT, *pr, *iOldPrompt, iTransferDir));
	AddMediaPublisher(CPicturePublisher::NewL(AppContext(), *this, _L("?:\\videos"),
		_L("*3gp"), SETTING_MEDIA_UPLOAD_ENABLE, MEDIA_PUBLISHER_CL, SETTING_PUBLISH_URLBASE, SETTING_PUBLISH_SCRIPT, *pr, *iOldPrompt, iTransferDir));

	AddMediaPublisher(CPicturePublisher::NewL(AppContext(), *this, _L("?:\\nokia\\Sounds\\digital"),
		_L("*amr"), SETTING_MEDIA_UPLOAD_ENABLE, MEDIA_PUBLISHER_CL, SETTING_PUBLISH_URLBASE, SETTING_PUBLISH_SCRIPT, *pr, *iOldPrompt, iTransferDir, _L("*aac")));
	AddMediaPublisher(CPicturePublisher::NewL(AppContext(), *this, _L("?:\\Sounds\\digital"),
		_L("*amr"), SETTING_MEDIA_UPLOAD_ENABLE, MEDIA_PUBLISHER_CL, SETTING_PUBLISH_URLBASE, SETTING_PUBLISH_SCRIPT, *pr, *iOldPrompt, iTransferDir, _L("*aac")));

	// n-gage
	AddMediaPublisher(CPicturePublisher::NewL(AppContext(), *this, _L("?:\\Record"),
		_L("*amr"), SETTING_MEDIA_UPLOAD_ENABLE, MEDIA_PUBLISHER_CL, SETTING_PUBLISH_URLBASE, SETTING_PUBLISH_SCRIPT, *pr, *iOldPrompt, iTransferDir, _L("*aac")));
	
	AddMediaPublisher(CPicturePublisher::NewL(AppContext(), *this, _L("?:\\Sounds\\digital"),
		_L("*amr"), SETTING_MEDIA_UPLOAD_ENABLE, MEDIA_PUBLISHER_CL, SETTING_PUBLISH_URLBASE, SETTING_PUBLISH_SCRIPT, *pr, *iOldPrompt, iTransferDir, _L("*aac")));	

	AddMediaPublisher(CPicturePublisher::NewL(AppContext(), *this, _L("?:\\system\\apps\\ContextNote"),
		_L("*txt"), SETTING_MEDIA_UPLOAD_ENABLE, MEDIA_PUBLISHER_CL, SETTING_PUBLISH_URLBASE, SETTING_PUBLISH_SCRIPT, *pr, *iOldPrompt, iTransferDir));
#endif //REALLY_ONLY_LOGGING


	LogAppEvent(_L("Starting 3"));
	state=_L("create settings view");

	auto_ptr<CSettingsView> iSettingsView(CSettingsView::NewL(KSettingsViewId, AppContext(), 
		TLocalAppSettings::GetEnabledSettingsArray()));
	AddViewL(iSettingsView.get());
	iSettingsView.release();

	state=_L("create log view");
	auto_ptr<CAppLogView> logview(CAppLogView::NewL(iLastLog));
	AddViewL(logview.get());
	iLogView=logview.release();

	TBool enable_options=false;

#ifndef NO_PRESENCE
	state=_L("create user view");
	auto_ptr<CUserView> userview(CUserView::NewL(iUserContextLog, iPresencePublisher));
	AddViewL(userview.get());
	CUserView* v=userview.release();
#  ifdef REALLY_ONLY_LOGGING
	SetDefaultViewL(*v);
#  else
	if ( ! Settings().GetSettingL(SETTING_OPTIONS_ENABLE, enable_options) || !enable_options) {
		SetDefaultViewL(*v);
	}
#  endif
#endif // NO_PRESENCE

#if 0
	state=_L("create hide view");
	auto_ptr<CHideView> Hideview(CHideView::NewL());
	AddViewL(Hideview.get()); 
	if ( Settings().GetSettingL(SETTING_OPTIONS_ENABLE, enable_options) && enable_options) {
		Hideview.release();
	} else {
		SetDefaultViewL(*(Hideview.release()));
	}
#endif


#ifndef NO_PRESENCE
	state=_L("create presence detail");
	auto_ptr<CPresenceDetailView> detailview(CPresenceDetailView::NewL());
	AddViewL(detailview.get());
	iPresenceDetailView=detailview.release();

	state=_L("create presence description");
	auto_ptr<CPresenceDescriptionView> Descriptionview(CPresenceDescriptionView::NewL());
	AddViewL(Descriptionview.get());
	iPresenceDescriptionView=Descriptionview.release();

	auto_ptr<CBTDevApView> btView2(CBTDevApView::NewL(AppContext(), iBuddyBTs, EFalse));
	AddViewL(btView2.get());
	iBTBuddiesView = btView2.release();
#endif //NO_PRESENCE

	state=_L("create cell callback");
	caller=new (ELeave) name_cell_callback(this);
	caller->ConstructL();

	name_times=new (ELeave) CArrayFixFlat<TTime>(2);
	name_names=new (ELeave)CArrayFixFlat<TBBCellId>(2);

	state=_L("create note");
	globalNote=CAknGlobalNote::NewL();

	state=_L("create keylock");
	User::LeaveIfError(keylock.Connect());

	iEikonEnv->AddForegroundObserverL(*this);

	TUint cellid_file_version=2;
	{
		MoveIntoDataDirL(AppContext(), cellid_file);
		// copy the installed cellid_names over the real one, if
		// one has been installed

		TFileName install_cellid_filen, cellid_filen, cellid_filen_v1;
		install_cellid_filen.Format(_L("%S%S"), &AppDir(), &install_cellid_file);
		cellid_filen.Format(_L("%S%S"), &DataDir(), &cellid_file);
		cellid_filen_v1.Format(_L("%S%S"), &DataDir(), &cellid_file_v1);
		if (BaflUtils::FileExists(Fs(), install_cellid_filen)) {
			User::LeaveIfError(BaflUtils::CopyFile(Fs(), install_cellid_filen, cellid_filen));
			User::LeaveIfError(BaflUtils::DeleteFile(Fs(), install_cellid_filen));
		}
		TEntry e;
		if ( ( Fs().Entry(cellid_filen, e)!=KErrNone || e.iSize==0 ) 
				&& cellid_name_file_v1.Open(Fs(), cellid_filen_v1, 
				EFileShareAny | EFileStreamText | EFileRead | EFileWrite)==KErrNone) {
			cellid_file_version=1;
		}

		if (cellid_name_file.Open(Fs(), cellid_filen, 
			EFileShareAny | EFileStreamText | EFileRead | EFileWrite)!=KErrNone) {
			User::LeaveIfError(cellid_name_file.Create(Fs(), cellid_filen, 
				EFileShareAny | EFileStreamText | EFileRead | EFileWrite));
		}
	}

	state=_L("create cell ann");
	cell_ann=Clog_base_impl::NewL(AppContext(), KCellAnnotation, KCellAnnotationTuple);

	CC()->PrepareToConvertToOrFromL(KCharacterSetIdentifierIso88591, Fs());
	read_cellid_names(cellid_file_version);
	if (cellid_file_version==1) cellid_name_file_v1.Close();


#if !defined(REALLY_ONLY_LOGGING) || defined(DO_LOCATIONING)
	state=_L("create locationing");

	loc=Clocationing::NewL(AppContext(), this, this, smsh, iPresencePublisher);
#endif

	// don't show in UI
	//cell_ann->add_sinkL(iAppContainer);

	//NOTHERE

#ifndef REALLY_ONLY_LOGGING
	/*
	state=_L("create context name");
	context_ann=Clog_base_impl::NewL(AppContext(), KContextAnnotation);
	context_ann->add_sinkL(fl);
	*/

#endif //REALLY_ONLY_LOGGING

	state=_L("create log cellid");
	lc=Clog_cellid::NewL(AppContext(), iOpMap, iCellMap);
	iLoggers->AppendL(lc);

	//if (lc) lc->add_sinkL(iRouteRecorder);
	
	state=_L("create log sms");
	lsms=CLog_sms::NewL(AppContext(), KSMS);
	iLoggers->AppendL(lsms);
	smsh->AddHandler(lsms);

	state=_L("create log profile");
	lp=Clog_profile::NewL(AppContext());
	iLoggers->AppendL(lp);

	{
		state=_L("create log alarm");
		auto_ptr<CLogAlarm> l(CLogAlarm::NewL(AppContext()));
		iLoggers->AppendL(l.get());
		l.release();
	}
	{
		state=_L("create log unread");
		auto_ptr<CLogUnread> l(CLogUnread::NewL(AppContext()));
		iLoggers->AppendL(l.get());
		l.release();
	}

	/*
	if (wins && 0) {
		ls=Clog_soundlevel::NewL(AppContext());
		iLoggers->AppendL(ls);
		ls->add_sinkL(iAppContainer);
		ls->add_sinkL(fl);
	}
	*/

	state=_L("create log appuse");
	lau=CLog_AppUse::NewL(AppContext());
	iLoggers->AppendL(lau);

	state=_L("create commlog");
	comml=Clog_comm::NewL(AppContext(), this);

	ll=CLog_local::NewL(AppContext(), KIdle);
	iLoggers->AppendL(ll);
	iKeycaptureArgs.iKeyStatus=ll->RequestStatus();
	if (wins) 
		iAppContainer->SubscribeL(KIdleTuple);

	state=_L("create system event loggers");
	Mlog_base_impl* l;
	l=CLog_SystemEvent::NewL(AppContext(), KCharger, KUidChargerCStatus, KChargerTuple); 
	iLoggers->AppendL(l);

	l=CLog_SystemEvent::NewL(AppContext(), KBattery, KUidBatteryBars, KBatteryTuple); 
	iLoggers->AppendL(l);

	l=CLog_SystemEvent::NewL(AppContext(), KNetworkStatus, KUidNetworkStatus, KNetworkTuple); 
	iLoggers->AppendL(l);

#if !defined(REALLY_ONLY_LOGGING) || defined(CONTEXTNW)
	iGps=CLogGps::NewL(AppContext());
	iLoggers->AppendL(iGps); 
	iGps->SubscribeL(KBluetoothTuple);
#endif

	state=_L("create transferer");
	transferer=CSendUITransfer::NewL(AppContext(), this, 
		Econtext_logCmdSendAppUi, DataDir(), AppDir());
	transferer->add_filesL(_L("log*txt"), true);
	transferer->add_filesL(_L("starter*txt"), true);
	transferer->add_filesL(_L("book*txt"), true);
	transferer->add_filesL(_L("calllog*txt"), true);
	transferer->add_filesL(_L("comm*txt"), false);
	transferer->add_filesL(_L("rec*amr"), false);
	transferer->add_filesL(_L("cellid_names_trans.txt"), false);

#ifndef NO_PERIODIC_TRANSFER
	iPeriodicTransfer=CPeriodicTransfer::NewL(AppContext(), 24, this, iTransferDir);
#endif

	TInt pos=0;
	cellid_name_file.Seek(ESeekEnd, pos);

	/*
	answerer=Canswering::NewL(AppContext(), this);
	lp->add_sinkL(answerer);
	iAppContainer->CurrentLoc()->add_sinkL(answerer);
	*/

	state=_L("create call recorders");
	in_recorder=CCall_record::NewL(AppContext(), this, CCall_record::INCOMING);
	out_recorder=CCall_record::NewL(AppContext(), this, CCall_record::OUTGOING);

	iAlerter=CAlerter::NewL(AppContext(), lp);
#ifdef DO_NOTIFIER
	iUserNotifier = CUserNotifier::NewL(AppContext(), iAlerter);
#endif

	state=_L("start keycapture");
	RWindowGroup wg=iEikonEnv->RootWin();
	iKeycaptureArgs.iParentWg=wg.Identifier();
	Settings().GetSettingL(SETTING_RIGHT_SOFTKEY_CONTEXT, iKeycaptureArgs.right_softkey_mapped);
	keycapture.start(_L("keycapture"), start_keycapture, (TAny*)&iKeycaptureArgs, 
		EPriorityAbsoluteForeground);
	
#ifndef NO_BASES
	state=_L("start bases");
	bases_worker.start(_L("bases"), bases::RunBasesInThread, 0, EPriorityLess);
#endif

	iAppContainer->set_status(_L(""));

	iEikonEnv->SetSystem(ETrue);

	if (!wins)
		QueueOp(&CContext_logAppUi::hide);

	iOpMap->Release(); iOpMap=0;

	LogAppEvent(_L("watchdog"));

	// note that we've started
	expired(iWatchDogTimer);
	_LIT(KContextLogStarted, "context_log_started");
	TBBTime t(KContextLogStarted);
	t()=GetTime();
	TRAPD(serr, iBBSubSessionNotif->PutL(KStatusTuple, KContextLogStarted, &t));
	state=_L("");
	
	LogAppEvent(_L("Started"));
	current_state=IDLE;
	initialising=false;
}

void CContext_logAppUi::AddMediaPublisher(CPicturePublisher* aPublisher)
{
	auto_ptr<CPicturePublisher> p(aPublisher);
	iMediaPublishers->AppendL(aPublisher);
	p.release();
	aPublisher->SubscribeL(KBaseTuple);
}

void CContext_logAppUi::PublishOldMedia()
{
	if (iTransferDir && iTransferDir->Transferer()) {
		iTransferDir->Transferer()->Trigger();
	}
	if (iMediaPublishers) {
		for (int i=0; i< iMediaPublishers->Count(); i++) {
			iMediaPublishers->At(i)->PublishOld();
		}
	}
}

// ----------------------------------------------------
// CContext_logAppUi::~CContext_logAppUi()
// Destructor
// Frees reserved resources
// ----------------------------------------------------
//
CContext_logAppUi::~CContext_logAppUi()
{
	CALLSTACKITEM_N(_CL("CContext_logAppUi"), _CL("~CContext_logAppUi"));
	{
	TInt err;

	{
		TTime t2;
		t2=GetTime();
		if (fl) 
			TRAP(err, fl->new_value(CBBSensorEvent::VALUE, _L("APP close"), state, t2));

		CLocalNotifyWindow::Destroy();
		delete iNTPConnection;

		Settings().CancelNotifyOnChange(SETTING_LOGGING_ENABLE, this);

		if (iTestFileOpen) iTestFile.Close();

		CEikonEnv::Static()->RemoveForegroundObserver(*this);
		keycapture.stop();
		bases_worker.stop();

		delete comml;

		delete iUserNotifier;

		delete iCaptionMyContext;
		
		//delete lt;
		if (t) {
			t->Kill(0);
			delete t;
		}

	}


	{

		delete cell_ann;
		delete context_ann;
		delete app_log;
		Reporting().SetActiveErrorReporter(0);
	}

	{
		TTime t; t=GetTime();
		if (fl) TRAP(err,
			fl->new_value(CBBSensorEvent::VALUE, _L("APP"), _L("3"), t));
		delete transferer;
		delete iPeriodicTransfer;


	}

	{
		TTime t; t=GetTime();
		if (fl) 
			TRAP(err, fl->new_value(CBBSensorEvent::VALUE, _L("APP"), _L("4"), t));
		if (iLoggers) {
			iLoggers->ResetAndDestroy();
		}
		delete iLoggers;

		AppContext().SetFileLog(0);
		delete iPresencePublisher;
		delete iUserContextLog;
		delete iUserContext;
		delete iOldPrompt;
		if (iMediaPublishers) {
			iMediaPublishers->ResetAndDestroy();
		}
		delete iMediaPublishers;

		delete iTransferDir;

		delete iMultiPrompt;
	}

	TTime t=GetTime();
	{

		if (fl) TRAP(err,
			fl->new_value(CBBSensorEvent::VALUE, _L("APP"), state, t));
	}
	{
		//delete answerer;
		delete in_recorder;
		delete out_recorder;
		delete base_counter;
	}

	cellid_name_file.Close();
	keylock.Close();

	if (iOpMap) iOpMap->Release();

	if (fl) TRAP(err,
		fl->new_value(CBBSensorEvent::VALUE, _L("APP"), _L("del 1"), t));

	delete name_times; delete name_names;

	delete globalNote;

	delete caller;
	delete loc;
	delete iSmsStatus;
	delete smsh;
	//delete iSmsSocket;

	delete iCodePrompt; 

	if (fl) 
		TRAP(err, fl->new_value(CBBSensorEvent::VALUE, _L("APP"), _L("del 2"), t));

	delete iCellMap;
	delete iCellDb;

	delete iBuddyBTs;
	delete iLaptopBTs;
	delete iDesktopBTs;
	delete iPDABTs;
	delete iBTDb;

	delete iLastLog;

	delete iWaitingOps;
	delete iWait;

	delete iWatchDogTimer;

	delete iAlerter;
	
	if (fl) 
		TRAP(err, fl->new_value(CBBSensorEvent::VALUE, _L("APP"), _L("del 3"), t));

	delete bbl;

	{
		delete iLoggingRunning;
	}
	{
		delete iContextRunning;
	}

	{
		CloseSTDLIB();
	}

	// near the end, since the cancelling doesn't work
	// right on s60v1 :-(
	delete iLocaSender;

	if (fl) 
		TRAP(err, fl->new_value(CBBSensorEvent::VALUE, _L("APP"), _L("del 4"), t));
#if defined(__S60V2__) && ! defined(__WINS__)
	// the cell change notification keeps the thread from
	// exiting otherwise
	{
		PrepareToExit();
		delete fl;
		delete &iContext;
		User::Exit(0);
	}
#endif
	}
	delete fl;
	//__UHEAP_MARKEND;
}

void CContext_logAppUi::hide()
{
	CALLSTACKITEM_N(_CL("CContext_logAppUi"), _CL("hide"));

	RWsSession& wsSession=CEikonEnv::Static()->WsSession();
	
	TApaTask task(wsSession);
	task.SetWgId(CEikonEnv::Static()->RootWin().Identifier());
	task.SendToBackground();
}

void CContext_logAppUi::unhide()
{
	CALLSTACKITEM_N(_CL("CContext_logAppUi"), _CL("unhide"));

	RWsSession& wsSession=CEikonEnv::Static()->WsSession();
	TApaTask task(wsSession);
	task.SetWgId(CEikonEnv::Static()->RootWin().Identifier());
	task.BringToForeground();
}


// ------------------------------------------------------------------------------
// CContext_logAppUi::::DynInitMenuPaneL(TInt aResourceId,CEikMenuPane* aMenuPane)
//  This function is called by the EIKON framework just before it displays
//  a menu pane. Its default implementation is empty, and by overriding it,
//  the application can set the state of menu items dynamically according
//  to the state of application data.
// ------------------------------------------------------------------------------
//
void CContext_logAppUi::DynInitMenuPaneL(
					 TInt aResourceId,CEikMenuPane* aMenuPane)
{
	CALLSTACKITEM_N(_CL("CContext_logAppUi"), _CL("DynInitMenuPaneL"));

	switch(aResourceId) {
	case R_OTHERS_MENU:
#ifndef REALLY_ONLY_LOGGING
		if (fl) {
			if (fl->is_paused()) {
				aMenuPane->SetItemDimmed(Econtext_logCmdAppPauseLog, ETrue);	
				aMenuPane->SetItemDimmed(Econtext_logCmdAppUnPauseLog, EFalse);
			} else {
				aMenuPane->SetItemDimmed(Econtext_logCmdAppPauseLog, EFalse);	
				aMenuPane->SetItemDimmed(Econtext_logCmdAppUnPauseLog, ETrue);
			}
		} else {
			aMenuPane->SetItemDimmed(Econtext_logCmdAppPauseLog, ETrue);	
			aMenuPane->SetItemDimmed(Econtext_logCmdAppUnPauseLog, ETrue);
		}
#endif
		break;

	case R_USER_ACTIONS:

#ifndef REALLY_ONLY_LOGGING
		if (iPresencePublisher) {
			if (iPresencePublisher->ConnectionSuspended()) {
				aMenuPane->SetItemDimmed(Econtext_logCmdAppSuspendPresence, ETrue);	
				aMenuPane->SetItemDimmed(Econtext_logCmdAppResumePresence, EFalse);
			} else {
				aMenuPane->SetItemDimmed(Econtext_logCmdAppSuspendPresence, EFalse);	
				aMenuPane->SetItemDimmed(Econtext_logCmdAppResumePresence, ETrue);
			}
		} else {
			aMenuPane->SetItemDimmed(Econtext_logCmdAppSuspendPresence, ETrue);	
			aMenuPane->SetItemDimmed(Econtext_logCmdAppResumePresence, ETrue);
		}
#endif
		break;
	case R_SENDUI_TOPMENU:
		transferer->DisplaySendMenuL(*aMenuPane, 1);
		break;
	case R_SENDUI_MENU:
		// sendui cascade
		transferer->DisplayMenuL(*aMenuPane);
		break;
	default:
		break;
	}
}

// ----------------------------------------------------
// CContext_logAppUi::HandleKeyEventL(
//     const TKeyEvent& aKeyEvent,TEventCode /*aType*/)
// ?implementation_description
// ----------------------------------------------------
//
TKeyResponse CContext_logAppUi::HandleKeyEventL(
						const TKeyEvent& /*aKeyEvent*/,TEventCode /*aType*/)
{
	CALLSTACKITEM_N(_CL("CContext_logAppUi"), _CL("HandleKeyEventL"));
	if (iAlerter) iAlerter->StopAlert();

	return EKeyWasNotConsumed;
}

void CContext_logAppUi::HandleSystemEventL  (  const TWsEvent &    aEvent  )
{
	CALLSTACKITEM_N(_CL("CContext_logAppUi"), _CL("HandleSystemEventL"));

	TApaSystemEvent event;
	event = *(TApaSystemEvent*)aEvent.EventData();

	switch ( event ) {
		case EApaSystemEventShutdown:
			LogAppEvent(_L("ext shutdown"));
			Exit();
			return;
			break;
		default:
			break;
	}
	CAknViewAppUi::HandleSystemEventL(aEvent);
}

void CContext_logAppUi::ProcessMessageL(TUid aUid,const TDesC8& aParams)
{
	if (aUid==KUidCloseLog) {
		LogAppEvent(_L("ext2 shutdown"));
		Exit();
	/*} else if (aUid==KUidToBackground) {
		hide();*/
	} else {
		CAknViewAppUi::ProcessMessageL(aUid,aParams);
	}
}

void CContext_logAppUi::HandleWsEventL(const TWsEvent& aEvent, CCoeControl* aDestination)
{
	CallStackMgr().ResetCallStack();

	TInt type=aEvent.Type();
	switch (type) {
		case EEventCaseOpened:
			case_closed=false;
			break;
		case EEventCaseClosed:
			case_closed=true;
			break;
	}
	TRAPD(err, CAknAppUi::HandleWsEventL(aEvent, aDestination));
	if (err==KErrCancel) {
		CallStackMgr().ResetCallStack();
		return;
	}

	User::LeaveIfError(err);
}

void CContext_logAppUi::QueueOp(TCallBack Op, int AfterSeconds)
{
	CALLSTACKITEM_N(_CL("CContext_logAppUi"), _CL("QueueOp"));

	iWaitingOps->AppendL(Op);
	iWait->Wait(AfterSeconds);
}
void CContext_logAppUi::expired(CBase* aSource)
{
	CALLSTACKITEM_N(_CL("CContext_logAppUi"), _CL("expired"));

	if (aSource==iWait) {
		TCallBack op=iWaitingOps->Pop();
		((*this).*op)();
		while (iWaitingOps->iFirst && iWaitingOps->Top()==op) iWaitingOps->Pop();
		if (iWaitingOps->iFirst) {
			iWait->Wait(1);
		}
	} else {
		RAFile f; f.ReplaceLA(Fs(), _L("c:\\system\\data\\context\\watch-context_log.dat"),
			EFileWrite|EFileShareAny);
		f.Write(_L8("watch"));
		iWatchDogTimer->Wait(KWatchDogTimeOut);
	}
}

void CContext_logAppUi::HandleCommandL(TInt aCommand)
{
	CALLSTACKITEM_N(_CL("CContext_logAppUi"), _CL("HandleCommandL"));
	switch ( aCommand )
	{
	case EAknSoftkeyBack:
		QueueOp(&CContext_logAppUi::hide);
		break;
	case EEikCmdExit:
		{
			LogAppEvent(_L("user shutdown"));
			Exit();
			break;
		}
	case Econtext_logCmdContacts:
		{
			auto_ptr<CApaCommandLine> cmd(CApaCommandLine::NewL(_L("z:\\system\\apps\\phonebook\\phonebook.app")));
			cmd->SetCommandL(EApaCommandRun);
			TRAPD(err, EikDll::StartAppL(*cmd));
			break;
		}
	case Econtext_logCmdLogs:
		{
			auto_ptr<CApaCommandLine> cmd(CApaCommandLine::NewL(_L("z:\\system\\apps\\logs\\logs.app")));
			cmd->SetCommandL(EApaCommandRun);
			TRAPD(err, EikDll::StartAppL(*cmd));
			break;
		}
	case Econtext_logDetailedView:
		ActivateLocalViewL(KStatusView);
		break;

	case Econtext_logPresenceDetails:
		PresenceDetails();
		break;
	case Econtext_logPresenceDescription:
		PresenceDescription();
		break;

	case Econtext_logCmdAppNameCell:
		{
		TTime now; now.HomeTime();

		const MBBData *d=lc->get_value().iData();
		const TBBCellId* c=bb_cast<TBBCellId>(d);
		if (!c) return;
		name_cell(CAknQueryDialog::ENoTone, *c, now);
		}
		break;
	case Econtext_logCmdAppNameContext:
		name_context();
		break;
	case Econtext_logCmdAppRecordDesc:
		record_description();
		break;
	case Econtext_logCmdAppPauseLog:
		Settings().WriteSettingL(SETTING_LOGGING_ENABLE, EFalse);
		if(iLoggingRunning) iLoggingRunning->SetCurrentState( EMbmContext_logL_not, EMbmContext_logL_not );
		break;
	case Econtext_logCmdAppUnPauseLog:
		Settings().WriteSettingL(SETTING_LOGGING_ENABLE, ETrue);
		if(iLoggingRunning) iLoggingRunning->SetCurrentState( EMbmContext_logL, EMbmContext_logL );
		break;
	case Econtext_logCmdAppGetCommLog:
		{
		if (comml->write_comm_log()) {
			_LIT(getting, "Getting comm log");
			iAppContainer->set_status(getting);
		} else {
			_LIT(no, "Nothing to do");
			iAppContainer->set_status(no);
		}
		break;
		}
	case Econtext_logCmdBTBuddies:
		if (iBTBuddiesView) {
			iBTBuddiesView->SetList(iBuddyBTs);
			ActivateLocalViewL(KBtDevSetViewId);
		}
		break;
	case Econtext_logCmdBTPDAs:
		if (iBTBuddiesView) {
			iBTBuddiesView->SetList(iPDABTs);
			ActivateLocalViewL(KBtDevSetViewId);
		}
		break;
	case Econtext_logCmdBTLaptops:
		if (iBTBuddiesView) {
			iBTBuddiesView->SetList(iLaptopBTs);
			ActivateLocalViewL(KBtDevSetViewId);
		}
		break;
	case Econtext_logCmdBTDesktops:
		if (iBTBuddiesView) {
			iBTBuddiesView->SetList(iDesktopBTs);
			ActivateLocalViewL(KBtDevSetViewId);
		}
		break;
	case Econtext_logCmdBT_Dev_AP:
		if (iBTDevApView)
			ActivateLocalViewL(KBtDevApViewId);
		break;
	case Econtext_logCmdCancelSend:
		// do nothing
		break;
	case Econtext_logCmdAppTest:
		{
		//loc->test();
		//recorder->test();
		DialogTest();
		}
		break;
	case Econtext_logCmdAppCrash:
		{
		TBuf<2> buf; buf.Append(_L("xxxx"));
		}
		break;
	case Econtext_logCmdAppImsi:
		{
			if (loc) status_change(loc->GetImsi());
			else {
#ifndef __WINS__
				TPlpVariantMachineId machineId;
				PlpVariant::GetMachineIdL(machineId);
				status_change(machineId);
#else
				// Return a fake IMEI when working on emulator
				_LIT(KEmulatorImsi, "244050000000000");
				status_change(KEmulatorImsi);
#endif
			}
		}
			
		break;
	case Econtext_logCmdAppSettings:
		ActivateLocalViewL(KSettingsViewId);
		break;
	case Econtext_logCmdBaseLog:
		iLogView->SetLog( iAppContainer->BaseLog() );
		ActivateLocalViewL(KLogViewId);
		break;
	case Econtext_logCmdAppLog:
		iLogView->SetLog( iLastLog );
		ActivateLocalViewL(KLogViewId);
		break;
	case Econtext_logMyContext:
		ActivateLocalViewL(KUserViewId);
		break;
	case Econtext_logCmdGPS:
		if (iGps) iGps->SelectDevice();
		break;
	case Econtext_logCmdGPSTest:
		if (iGps) iGps->TestDevice();
		break;
	case Econtext_logCmdSettingsCancel:
	case Econtext_logCmdSettingsSave:
	case Econtext_logCmdlogviewClose:
		ActivateLocalViewL(KStatusView);
		break;
	case Econtext_logCmdAppSuspendPresence:
		{
			LogAppEvent(_L("User suspended presence"));
			Settings().WriteSettingL(SETTING_PRESENCE_ENABLE, 0);
		}
		break;
	case Econtext_logCmdAppResumePresence:
		{
			LogAppEvent(_L("User resumed presence"));
			Settings().WriteSettingL(SETTING_PRESENCE_ENABLE, 1);
		}
		break;
	case Econtext_logCmdPublishOld:
		{
			PublishOldMedia();
		}
		break;
	case Econtext_logCmdSetUserGiven:
		{
			SetUserGiven();
		}
		break;
	default:
		if (aCommand>Econtext_logCmdSendAppUi || aCommand==Econtext_logCmdSendFtp) {
			
			if (aCommand==Econtext_logCmdSendFtp) {
				//iPeriodicTransfer->Transfer(false);
				iPeriodicTransfer->Transfer(true);
			} else {
				status_change(_L("trying transfer"));

				cellid_name_file.Close();
				
				TFileName transfer_cellid_filen, cellid_filen;
				transfer_cellid_filen.Format(_L("%S%S"), &AppDir(), &transfer_cellid_file);
				cellid_filen.Format(_L("%S%S"), &DataDir(), &cellid_file);

				TInt ferr=BaflUtils::CopyFile(Fs(), cellid_filen, transfer_cellid_filen);
				if (ferr!=KErrNone) {
					TBuf<30> errmsg;
					errmsg.Format(_L("copy: %d"), ferr);
					error(errmsg);
					return;
				}
				ferr=cellid_name_file.Open(Fs(), cellid_filen, 
					EFileShareAny | EFileStreamText | EFileRead | EFileWrite);
				if (ferr!=KErrNone) {
					TBuf<30> errmsg;
					errmsg.Format(_L("reopen: %d, RESTART NOW"), ferr);
					error(errmsg);
					return;
				}
				fl->switch_file();

				transferer->transfer_files(aCommand);
			}
			
		}
		break;
	}
}

void CContext_logAppUi::finished()
{
	CALLSTACKITEM_N(_CL("CContext_logAppUi"), _CL("finished"));

	_LIT(got, "finished op");
	iAppContainer->set_status(got);
}

void CContext_logAppUi::error(const TDesC& descr)
{	
	CALLSTACKITEM_N(_CL("CContext_logAppUi"), _CL("error"));

	if (descr.Length()>0) {
		TBuf<200> msg;
		msg.Append(_L("ERROR: "));
		msg.Append(descr.Left(190));
		//globalNote->ShowNoteL(EAknGlobalInformationNote, descr	);
		LogAppEvent(msg);
		RDebug::Print(msg);
	}
	if (iAppContainer) iAppContainer->set_error(descr);
}

void CContext_logAppUi::status_change(const TDesC& status)
{
	CALLSTACKITEM_N(_CL("CContext_logAppUi"), _CL("status_change"));

	//globalNote->ShowNoteL(EAknGlobalInformationNote, status);
	if (status.Length()>0) {
		TBuf<200> msg;
		msg.Append(_L("STATUS: "));
		msg.Append(status.Left(190));
		LogAppEvent(msg);
	}
	if (iAppContainer) iAppContainer->set_status(status);
}

void CContext_logAppUi::write_to_output(const TDesC& str)
{
	CALLSTACKITEM_N(_CL("CContext_logAppUi"), _CL("write_to_output"));

	TInt pos=0, len;
	len=buf.MaxLength();
	while (pos < str.Length()) {
		TInt real_len;
		if (pos+len > str.Length()) {
			real_len=str.Length()-pos;
		} else {
			real_len=len;
		}
		CC()->ConvertFromUnicode(buf, str.Mid(pos, real_len));
		pos+=len;
		cellid_name_file.Write(buf);
	}

}

void CContext_logAppUi::read_cellid_names(TUint version)
{
	CALLSTACKITEM_N(_CL("CContext_logAppUi"), _CL("read_cellid_names"));

	TBuf<128> unibuf;
	TBuf<200> cell_name, cellid;
	TInt pos=0; TChar cur; TInt len;
	bool read_id=false;

	TInt state=CCnvCharacterSetConverter::KStateDefault;
	if (version==1) {
		cellid_name_file_v1.Read(buf);
	} else {
		cellid_name_file.Read(buf);
	}
	while ( (len=buf.Length()) ) {
		CC()->ConvertToUnicode(unibuf, buf, state);
		while (pos<len) {
			while (!read_id && pos<len && (cur=unibuf[pos])!=L'\t') {
				cellid.Append(cur);
				pos++;
			}
			if (pos<len && !read_id) {
				read_id=true;
				pos++; // skip tab
			}
			while (pos<len && (cur=unibuf[pos])!=L'\n') {
				cell_name.Append(cur);
				pos++;
			}
			if (pos<len) {
				pos++; //skip nl for next
				
				if (cellid.Length() && cell_name.Length()) {
					TBBCellId cell(KCell);

					if (version==1) {
						TUint id, lac;
						CCellMap::Parse(cellid, id, lac, cell.iShortName());
						cell.iCellId()=id; cell.iLocationAreaCode()=lac;
						iOpMap->NameToMccMnc(cell.iShortName(), cell.iMCC(), cell.iMNC());
						cell.iMappedId()=iCellMap->GetId(cell);
						add_cellid_name(cell, cell_name);
					} else {
						TRAPD(err, cell.FromStringL(cellid));
						if (err==KErrNone) {
							cell.iMappedId()=iCellMap->GetId(cell);
							iAppContainer->add_cellid_name(cell, cell_name);
						}
					}
				}
				cellid.Zero();
				cell_name.Zero();
				read_id=false;
			}
		}
		buf.Zero();
		pos=0;
		if (version==1) {
			cellid_name_file_v1.Read(buf);
		} else {
			cellid_name_file.Read(buf);
		}
	}
}

void CContext_logAppUi::NewSensorEventL(const TTupleName& aName, 
					const TDesC& aSubName, const CBBSensorEvent& aEvent)
{
	if (aName==KLocationTuple) {
		const TBBLocation* loc=bb_cast<TBBLocation>(aEvent.iData());
		if (!loc) return;
		now_at_location(&(loc->iCellId), loc->iLocationId(), loc->iIsBase(), loc->iLocationChanged(),
			loc->iEnteredLocation());
	}
}

void CContext_logAppUi::now_at_location(const TBBCellId* Cell, TInt id, 
					bool is_base, bool loc_changed, TTime time)
{
	CALLSTACKITEM_N(_CL("CContext_logAppUi"), _CL("now_at_location"));

	if (loc) loc->now_at_location(Cell, id, is_base, loc_changed, time);

	//globalNote->ShowNoteL(EAknGlobalInformationNote, cellid);
	//if (initialising) return;
	if (!iAppContainer) return;
	iAppContainer->CurrentLoc()->now_at_location(Cell, id, is_base, loc_changed, time);
	if (id<0 || !Cell) return;

	TInt id_for_cell=Cell->iMappedId();
	if (is_base && ! iAppContainer->is_named(id) && ! iAppContainer->is_named(id_for_cell) ) {
		if (loc && loc->LocationgAvailable()) {
			loc->GetNameL(Cell);
		} else {
			TBool ask_for_name;
			if ( Settings().GetSettingL(SETTING_PROMPT_FOR_NAMES, ask_for_name) 
				&& !ask_for_name) return;
			// don't insert duplicates
			for (int i=0; i < name_names->Count(); i++) {
				if ( (*name_names)[i]==*Cell ) return;
			}

			TTime now;
			now.HomeTime();

			name_times->AppendL(now);
			name_names->AppendL(*Cell);
			caller->call();
		}
	}
}

void CContext_logAppUi::name_cells()
{	
	CALLSTACKITEM_N(_CL("CContext_logAppUi"), _CL("name_cells"));

	RWsSession& wsSession=CEikonEnv::Static()->WsSession();
	TInt id = CEikonEnv::Static()->RootWin().Identifier();
	TApaTask task(wsSession);
	task.SetWgId(id);
	TBool hide_me = EFalse;
	if ( wsSession.GetFocusWindowGroup() != id )
	{
		task.BringToForeground();
		hide_me = ETrue;
	}
	//unhide();

	current_state=NAME_CELLS;

	// cannot play tone if we want to play a ringtone
	CAknQueryDialog::TTone tone=CAknQueryDialog::ENoTone; 
	iAlerter->AlertUser();

	{
		for (int i=0; i<name_names->Count(); i++) {
			TBBCellId& cell=(*name_names)[i];
			name_cell(tone, cell, (*name_times)[i]);
			name_times->Delete(i);
			name_names->Delete(i);
		}
		name_times->Compress();
		name_names->Compress();
	}

	if (iAlerter) iAlerter->StopAlert();

	if (hide_me) 
	{
		hide();
	}
	current_state=IDLE;

}

void CContext_logAppUi::HandleGainingForeground() 
	{ 
	}

void CContext_logAppUi::HandleLosingForeground() { }

_LIT(KUserGiven, "dummy");

class CEmptyAllowingTextQuery : public CAknTextQueryDialog {
public:
	CEmptyAllowingTextQuery(TDes &  aDataText,  const TTone &  aTone = ENoTone ) : CAknTextQueryDialog(aDataText, aTone) { }
	void PreLayoutDynInitL() {
		CAknTextQueryDialog::PreLayoutDynInitL();
		MakeLeftSoftkeyVisible(ETrue);
	}

	TBool HandleQueryEditorStateEventL(	CAknQueryControl *  /*aQueryControl*/,  
						TQueryControlEvent    /*aEventType*/,  
						TQueryValidationStatus    /*aStatus*/ ) {
		return ETrue; // it's magic!
	}
};

void CContext_logAppUi::RestoreUserGiven()
{
	const TInt m_length = iPresencePublisher->Data()->iUserGiven.iDescription.iValue.MaxLength();

	TTime usergiventime;
	auto_ptr<HBufC> usergiven(HBufC::NewL( m_length) );
	TPtr16 p = usergiven->Des();
	if ( !Settings().GetSettingL(SETTING_OWN_DESCRIPTION, p ) || p.Length() == 0)  return;
	if (! Settings().GetSettingL(SETTING_OWN_DESCRIPTION_TIME, usergiventime) ) return;

	auto_ptr<CBBSensorEvent> e(new CBBSensorEvent(KUserGiven, KUserGivenContextTuple, 0, GetTime()));
	TBBUserGiven * ug = new (ELeave) TBBUserGiven(KUserGiven);
	ug->iDescription.iValue = *usergiven;
	ug->iSince.iValue = usergiventime;
	e->iData() = ug;
	((Mlogger*)iPresencePublisher)->NewSensorEventL(e->TupleName(), KNullDesC, *e);
	if (fl) fl->new_value(CBBSensorEvent::VALUE, _L("STARTING USER desc:"), ug->iDescription(), GetTime());
}

void CContext_logAppUi::SetUserGiven()
{
	CALLSTACKITEM_N(_CL("CContext_logAppUi"), _CL("SetUserGiven"));

	const TInt m_length = iPresencePublisher->Data()->iUserGiven.iDescription.iValue.MaxLength(); 
	
	auto_ptr<HBufC> textData(HBufC::NewL( m_length) );
	
	textData->Des() = iPresencePublisher->Data()->iUserGiven.iDescription.iValue;
	TPtr16 p = textData->Des();

	auto_ptr<HBufC> pr(CEikonEnv::Static()->AllocReadResourceL(R_CL_SET_USER_GIVEN));
	CAknTextQueryDialog* dlg = new(ELeave) CEmptyAllowingTextQuery(p, CAknQueryDialog::ENoTone);
	CleanupStack::PushL(dlg);
	dlg->SetPredictiveTextInputPermitted(ETrue);
	dlg->SetMaxLength( m_length );
	dlg->SetPromptL(*pr);
	
	CleanupStack::Pop();
	iShowingDialog=true;
	if (dlg->ExecuteLD(R_CONTEXT_LOG_SET_USER_GIVEN) )
	{
		auto_ptr<CBBSensorEvent> e(new CBBSensorEvent(KUserGiven, KUserGivenContextTuple, 0, GetTime()));
		TBBUserGiven * usergiven = new (ELeave) TBBUserGiven(KUserGiven);
		usergiven->iDescription.iValue = *textData;
		usergiven->iSince.iValue = GetTime();
		e->iData() = usergiven;

		((Mlogger*)iPresencePublisher)->NewSensorEventL(e->TupleName(), KNullDesC, *e);
		if (fl) fl->new_value(CBBSensorEvent::VALUE, _L("USER desc:"), usergiven->iDescription(), usergiven->iSince());
	}
}

void CContext_logAppUi::name_cell(const CAknQueryDialog::TTone tone, const TBBCellId & cell, TTime time)
{
	if (IsDisplayingMenuOrDialog()) return;

	const TInt NAME_LENGTH=100;
	auto_ptr<HBufC> textData(HBufC::NewL(NAME_LENGTH));
	
	TPtr16 p=textData->Des();

	auto_ptr<HBufC> f(CEikonEnv::Static()->AllocReadResourceL(R_CL_NAME_CELL_CAPTION));
	auto_ptr<HBufC> pr(HBufC::NewL(f->Des().Length()+4));
	TDateTime dt(time.DateTime());
	pr->Des().Format(f->Des(), dt.Hour(), dt.Minute());

	CAknTextQueryDialog* dlg = new(ELeave) CAknTextQueryDialog(p, tone);
	CleanupStack::PushL(dlg);
	dlg->SetMaxLength(NAME_LENGTH);
	dlg->SetPromptL(*pr);
	CleanupStack::Pop();
	iShowingDialog=true;
	if (dlg->ExecuteLD(R_CONTEXT_LOG_NAME_INPUT) && textData->Length())
	{
		add_cellid_name(cell, *textData);
	}
}

void CContext_logAppUi::add_cellid_name(const TBBCellId& cellid, const TDesC& name)
{
	CALLSTACKITEM_N(_CL("CContext_logAppUi"), _CL("add_cellid_name"));

	_LIT(KCellAnn, "cell_ann");
	TBBShortString m(name, KCellAnn);
	cell_ann->post_new_value(&m);
	iAppContainer->add_cellid_name(cellid, name);

	TBuf<50> b;
	cellid.IntoStringL(b);

	write_to_output(b);
	_LIT(tab, "\t");
	write_to_output(tab);
	write_to_output(name);
	_LIT(nl, "\n");
	write_to_output(nl);
	//write_nl();
}

void CContext_logAppUi::name_context()
{
	/*
	if (IsDisplayingMenuOrDialog()) return;


	const TInt CONTEXT_LENGTH=100;
	auto_ptr<HBufC> textData(HBufC::NewL(CONTEXT_LENGTH));
	TPtr16 p=textData->Des();
	CAknTextQueryDialog* dlg = new(ELeave) CAknTextQueryDialog(p, CAknQueryDialog::ENoTone);
	CleanupStack::PushL(dlg);
	dlg->SetMaxLength(CONTEXT_LENGTH);
	_LIT(pr, "Context name");
	dlg->SetPromptL(pr);
	CleanupStack::Pop();
	if (dlg->ExecuteLD(R_CONTEXT_LOG_NAME_INPUT))
	{
		context_ann->post_new_value(textData->Des());
	}
	*/
}

void CContext_logAppUi::record_description()
{
	CALLSTACKITEM_N(_CL("CContext_logAppUi"), _CL("record_description"));

}

name_cell_callback::name_cell_callback(CContext_logAppUi* i_ui) : 
	CCheckedActive(EPriorityIdle, _L("name_cell_callback")), ui(i_ui) { }

void name_cell_callback::ConstructL()
{
	CALLSTACKITEM_N(_CL("name_cell_callback"), _CL("ConstructL"));

	timer.CreateLocal();
	CActiveScheduler::Add(this); // add to scheduler
}

void name_cell_callback::call()
{
	CALLSTACKITEM_N(_CL("name_cell_callback"), _CL("call"));

	if (is_active) return;
	TTimeIntervalMicroSeconds32 w(1*1000*1000);
	timer.After(iStatus, w);
	is_active=true;
	SetActive();
}

void name_cell_callback::CheckedRunL()
{
	CALLSTACKITEM_N(_CL("name_cell_callback"), _CL("CheckedRunL"));

	if (ui) {
		ui->name_cells();
	}
	is_active=false;
}

void name_cell_callback::DoCancel()
{
	CALLSTACKITEM_N(_CL("name_cell_callback"), _CL("DoCancel"));

	timer.Cancel();
}

name_cell_callback::~name_cell_callback()
{
	CALLSTACKITEM_N(_CL("name_cell_callback"), _CL("~name_cell_callback"));

	Cancel();
	timer.Close();
}

class CLogEventTest : public CActive {
public:
	static CLogEventTest* NewL(RFs& Fs) {
		auto_ptr<CLogEventTest> ret(new (ELeave) CLogEventTest);
		ret->ConstructL(Fs);
		return ret.release();
	}
	CLogEventTest() : CActive(EPriorityNormal) { }
	void ConstructL(RFs& Fs) {
		lc=CLogClient::NewL(Fs);
		le=CLogEvent::NewL();
		le->SetEventType(KLogCallEventTypeUid);
		le->SetContact(1);
		le->SetDirection(_L("Missed call"));
		le->SetDuration(1);
		le->SetDurationType(KLogDurationValid);
		le->SetNumber(_L("0505536758"));
		TTime now; now.HomeTime();

		le->SetTime(now);
		le->SetRemoteParty(_L("mika"));
		CActiveScheduler::Add(this);
		lc->AddEvent(*le, iStatus);
		SetActive();
	}
	void RunL() {
		delete this;
	}
	void DoCancel() { }
	~CLogEventTest() {
		Cancel();
		delete lc;
		delete le;
	}
private:
	CLogClient*	lc;
	CLogEvent*	le;
};

void CContext_logAppUi::PresenceDetails()
{
	iPresenceDetailView->SetData(*iCaptionMyContext, iPresencePublisher->Data());

	ActivateLocalViewL(KPresenceDetailView);

	return;
}

void CContext_logAppUi::PresenceDescription()
{
	iPresenceDescriptionView->SetData(*iCaptionMyContext, iPresencePublisher->Data());

	ActivateLocalViewL(KPresenceDescriptionView);

	return;
}

void CContext_logAppUi::DialogTest()
{
	iNTPConnection=CNTPConnection::NewL(*this);
	iNTPConnection->Sync();
	return;

	/*
	_LIT(KS, "Liittymn 0407679267 sijainti: HELSINKI, Esplanadi, N60:10'06\", E24:56'57\" (ast:min'sek\" WGS84:ss)");
	TMsvId dummy(1);
	i_handle_received_sms* s=loc;
	s->handle_reception(dummy, dummy, _L("15400"), KS);
	return;
	_LIT(KS, "Liittymn 0407679267 sijainti: HELSINKI, Esplanadi, N60:10'06\", E24:56'57\" (ast:min'sek\" WGS84:ss)");
	TMsvId dummy(1);
	i_handle_received_sms* s=lsms;
	s->handle_sending(dummy, _L("0505536758"), KS);
	return;
	*/

	/*
	TMsvId dummy(1);
	iSmsSnapshot->handle_reception(dummy, dummy, _L("0505536758"), _L("WINS"));
	return;
	*/

	/*
	iSmsSnapshot->Test();
	return;
	*/

	CLogEventTest* t=CLogEventTest::NewL(Fs());
	
	return;

	/*
	TBuf<100> err;
	TInt ret=iMMS->SendMessage(_L("0505536758"), _L("body of msg"), _L("c:\\http.txt"), err, false);
	if (ret!=KErrNone) Error(ret, err);
	else status_change(_L("message sent"));
	return; */

	/**/

	//TBuf<2> buf; buf.Append(_L("xxxx"));

	if (iTestFileOpen) {
		iTestFile.Close();
		iTestFileOpen=false;
	} else {
		
		TFileName filen=_L("C:\\nokia\\images\\img");
		TInt i=2; filen.AppendNum(i); filen.Append(_L(".jpg"));
		while (BaflUtils::FileExists(Fs(), filen)) {
			filen=_L("C:\\nokia\\images\\img");
			++i; filen.AppendNum(i); filen.Append(_L(".jpg"));
		}
		{
			TFileName from=_L("C:\\nokia\\images\\img.jpg");
			BaflUtils::CopyFile(Fs(), from, filen);
		}
		{
			TFileName from2=_L("C:\\nokia\\images\\old\\img.jpg");
			BaflUtils::CopyFile(Fs(), from2, filen);
		}
		/*
		if (iTestFile.Open(Fs(), filen, EFileWrite)==KErrNone) {
			iTestFileOpen=true;
		}
		*/
	}
	return;

	/*
	if (IsDisplayingMenuOrDialog()) return;


	CCoeEnv *env = CEikonEnv::Static();
	RPbkViewResourceFile pbkRes( *env);
	pbkRes.OpenL();
	CleanupClosePushL(pbkRes);

	CPbkContactEngine *ipPabEng=CPbkContactEngine::NewL();
	CleanupStack::PushL(ipPabEng);

	CPbkContactItem* aContactItem = ipPabEng->ReadContactL( 1 );
	CleanupStack::PushL(aContactItem);

	// launch the contacts dialog
	CPbkContactEditorDlg *ipPabDlg =
	CPbkContactEditorDlg::NewL(*ipPabEng, *aContactItem, EFalse);

	ipPabDlg->SetMopParent( this );

	TInt res = KErrNone;
	TRAPD( err, res = ipPabDlg->ExecuteLD());

	
	//CPbkSelectFieldDlg *d=new (ELeave) CPbkSelectFieldDlg;
	//TPbkContactItemField* res=d->ExecuteLD(aContactItem->CardFields(), R_AVKON_SOFTKEYS_OPTIONS_BACK);
	

	CleanupStack::PopAndDestroy(3); //engine, pbkRes, aContactItem
	*/
}

void CContext_logAppUi::start_app(TUid app, TInt view)
{
	CALLSTACKITEM_N(_CL("CContext_logAppUi"), _CL("start_app"));

	if (view==0) {
		RAApaLsSession ls; ls.ConnectLA();
		TThreadId tid;

		User::LeaveIfError( ls.StartDocument(_L(""), app, tid) );

	} else {
		CCoeAppUi::ActivateViewL(TVwsViewId(app, TUid::Uid(view)));
	}
}

void CContext_logAppUi::NotifyNewPresence(const CBBPresence* d)
{
	CALLSTACKITEM_N(_CL("CContext_logAppUi"), _CL("NotifyNewPresence"));

	PresenceToListBoxL(d, iUserContext,
		iCaptionMyContext, 0, prev, not_avail);

	iUserContextLog->AddL(*iUserContext);
}

void CContext_logAppUi::SettingChanged(TInt Setting)
{
	if (Setting==SETTING_LOGGING_ENABLE) {
		TApaTaskList tl(Ws());
		TApaTask booktask=tl.FindApp(KUidcontextbook);
		if (booktask.Exists()) {
			booktask.SendSystemEvent(EApaSystemEventShutdown);
		}
	}
}

// End of File  
