/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/

// INCLUDE FILES
#include "Context_logDocument.h"
#include "Context_logAppUi.h"
#include "app_context.h"
#include "settings.h"
#include "cl_settings.h"
#include "symbian_auto_ptr.h"
#include "bb_settings.h"

// ================= MEMBER FUNCTIONS =======================

// constructor
CContext_logDocument::CContext_logDocument(CEikApplication& aApp)
: CAknDocument(aApp)    
{
}

// destructor
CContext_logDocument::~CContext_logDocument()
{
	delete iBBSession;
	delete iBBDataFactory;
	delete iContext;
}

// EPOC default constructor can leave.
void CContext_logDocument::ConstructL()
{
	iContext=CApp_context::NewL(false, _L("context_log"));
	iContext->SetDataDir(_L("c:\\system\\data\\context\\"), false);
	iContext->SetDebugLog(_L("context_log"), _L("app"));

#ifndef __WINS__
	TParsePtrC parse(Application()->DllName());
	iContext->SetAppDir(parse.DriveAndPath());
#else
	iContext->SetAppDir(_L("c:\\system\\apps\\context_log\\"));
#endif
	CBlackBoardSettings* s=CBlackBoardSettings::NewL(*iContext, iDefaultSettings, KCLSettingsTuple);
	iContext->SetSettings(s);
	iBBDataFactory=CBBDataFactory::NewL();
	iBBSession=CBBSession::NewL(*iContext, iBBDataFactory);
	iContext->SetBBSession(iBBSession);
	iContext->SetBBDataFactory(iBBDataFactory);

}

// Two-phased constructor.
CContext_logDocument* CContext_logDocument::NewL(
						 CEikApplication& aApp)     // CContext_logApp reference
{
	auto_ptr<CContext_logDocument> self(new (ELeave) CContext_logDocument( aApp ));
	self->ConstructL();
	
	return self.release();
}

// ----------------------------------------------------
// CContext_logDocument::CreateAppUiL()
// constructs CContext_logAppUi
// ----------------------------------------------------
//
CEikAppUi* CContext_logDocument::CreateAppUiL()
{
	return new (ELeave) CContext_logAppUi(*iContext);
}

// End of File  
