#include "alerter.h"

#include "symbian_auto_ptr.h"

#ifndef NO_CFLDRINGINGTONEPLAYER_H
#include <CFLDRingingTonePlayer.h>
#endif

#include "cl_settings.h"
#include <eikenv.h>

class CAlerterImpl : public CAlerter, public MContextBase
{
private:
	CAlerterImpl(MApp_context& Context, Clog_profile* aProfile);
	void ConstructL();

	virtual void AlertUser();
	virtual void StopAlert();
	~CAlerterImpl();

#ifndef NO_CFLDRINGINGTONEPLAYER_H
	CFLDRingingTonePlayer* iPlayer;
	bool	ringing;
#endif
	Clog_profile* iProfile;
	
	friend class CAlerter;
	friend class auto_ptr<CAlerterImpl>;
};

CAlerter* CAlerter::NewL(MApp_context& Context, Clog_profile* aProfile)
{
	auto_ptr<CAlerterImpl> ret(new (ELeave) CAlerterImpl(Context, aProfile));
	ret->ConstructL();
	return ret.release();
}

CAlerterImpl::CAlerterImpl(MApp_context& Context, Clog_profile* aProfile) : MContextBase(Context), iProfile(aProfile)
{
}

void CAlerterImpl::ConstructL()
{
#ifndef NO_CFLDRINGINGTONEPLAYER_H
	iPlayer=CFLDRingingTonePlayer::NewL(ETrue);
	iPlayer->SetVibra(ETrue);
	iPlayer->SetRingingType(2); // ring once

	// We'll fool the ringtoneplayer about fg/bg events
	CEikonEnv::Static()->RemoveForegroundObserver(*iPlayer);
	((MCoeForegroundObserver*)iPlayer)->HandleGainingForeground();
#endif
}

void CAlerterImpl::AlertUser()
{
#ifndef NO_CFLDRINGINGTONEPLAYER_H
	TFileName tone=AppDir();

	int profile=iProfile->get_current_profile();

	switch (profile) {
	case 2:
		// meeting
		tone.Append(_L("silent.rng"));
		break;
	case 1:
		return;
		// silent
		break;
	default:
		{
		// general, outdoor
		TBool only_vibrate=true;
		Settings().GetSettingL(SETTING_VIBRATE_ONLY, only_vibrate);
		if (only_vibrate) 
			tone.Append(_L("silent.rng"));
		else
			tone.Append(_L("tone.rng"));
		
		break;
		}
	}

	ringing=true;
	((MFLDFileProcessor*)iPlayer)->ProcessFileL(tone);
#endif
}

void CAlerterImpl::StopAlert()
{
#ifndef NO_CFLDRINGINGTONEPLAYER_H
	if (ringing) {
		((MFLDFileProcessor*)iPlayer)->Cancel();
		ringing=false;
	}
#endif
}

CAlerterImpl::~CAlerterImpl()
{
#ifndef NO_CFLDRINGINGTONEPLAYER_H
	if (iPlayer) {
		((MCoeForegroundObserver*)iPlayer)->HandleLosingForeground();
		CEikonEnv::Static()->AddForegroundObserverL(*iPlayer);
	}
	delete iPlayer;
#endif
}