/*
 * this class doesn't actually put stuff on the blackboard
 * anymore - that was a short time hack, now the blackboard
 * listening is handled via permanent subscriptions
 *
 * it does run the network thread though
 *
 * should be cleaned up
 *
 * -MR
 */

#include "bb_logger.h"

#include <blackboardclientsession.h>
#include "symbian_auto_ptr.h"

#include "independent.h"
#include "cl_settings.h"
#include <basched.h>
#include "bb_protocol.h"
#include "bb_listener.h"
#include "timeout.h"
#include "app_context_impl.h"
#include <s32mem.h>
#include "callstack.h"

_LIT(KBBLogger, "CBBLogger");

const TComponentName KContextLogComponent = { { CONTEXT_UID_CONTEXT_LOG }, 1 };

class MActiveNotifier {
public:
	virtual void NotifyRunL(TInt aError) = 0;
};

class CActiveCallback : public CActive {
public:
	void ConstructL() {
		CActiveScheduler::Add(this);
		iStatus=KRequestPending;
		SetActive();
	}
	CActiveCallback(MActiveNotifier& aNotifier) : CActive(EPriorityIdle), iNotifier(aNotifier) { }
	TRequestStatus* GetStatus() { return &iStatus; }
	static CActiveCallback* NewL(MActiveNotifier& aNotifier)  {
		auto_ptr<CActiveCallback> ret(new (ELeave) CActiveCallback(aNotifier));
		ret->ConstructL();
		return ret.release();
	}
	~CActiveCallback() { Cancel(); }
private:
	void RunL(void) {
		TInt err=iStatus.Int();
		iStatus=KRequestPending;
		SetActive();
		iNotifier.NotifyRunL(err);
	}
	void DoCancel() {
		iStatus=KErrCancel;
		TRequestStatus* s=&iStatus;
		User::RequestComplete(s, KErrCancel);
	}
	MActiveNotifier& iNotifier;
};

class CBBLoggerImpl : public CBBLogger, public MContextBase, public MActiveNotifier, public MSettingListener {
private:
	virtual void NewSensorEventL(const TTupleName& aName, const TDesC& aSubName, const CBBSensorEvent& aEvent);

	CBBLoggerImpl(MApp_context& aContext, i_status_notif* aCallBack);
	void ConstructL();
	~CBBLoggerImpl();
	void StartIfEnabledL();
	void Stop();
	void SettingChanged(TInt Setting);

	void ConnectL();
	RBBClient iBBClient;
	HBufC8*		iBuf;

	independent_worker iContextNetwork;
	struct TNetworkArgs {
		TBuf<50>	iHost;
		TInt		iPort;
		TBuf<50>	iAuthor;
		TInt		iAP;
	};
	void NotifyRunL(TInt aError);
	TInt	iRestarts;
	TNetworkArgs	iNetworkArgs;
	CActiveCallback*	iNwCallback;
	CApp_context*		iNwContext;
	TBool			iStopping;
	i_status_notif*		iCallBack;

	static TInt start_contextnw(TAny* aPtr);

	friend class CBBLogger;
	friend class auto_ptr<CBBLoggerImpl>;
};

CBBLogger* CBBLogger::NewL(MApp_context& aContext, i_status_notif* aCallBack)
{
	auto_ptr<CBBLoggerImpl> ret(new (ELeave) CBBLoggerImpl(aContext, aCallBack));
	ret->ConstructL();
	return ret.release();
}

CBBLogger::~CBBLogger()
{
}

CBBLoggerImpl::CBBLoggerImpl(MApp_context& aContext, i_status_notif* aCallBack) : 
	MContextBase(aContext), iCallBack(aCallBack)
{
}

void CBBLoggerImpl::NewSensorEventL(const TTupleName& aName, const TDesC& aSubName, const CBBSensorEvent& aEvent)
{
	return;

	if (! aEvent.iData() || aEvent.iPriority() < CBBSensorEvent::VALUE) return;

	while(1) {
		iBuf->Des().Zero();
		TPtr8 p=iBuf->Des();
		RDesWriteStream ws(p);
		CleanupClosePushL(ws);
		aEvent.Type().ExternalizeL(ws);
		TRAPD(err, aEvent.ExternalizeL(ws));
		ws.CommitL();
		CleanupStack::PopAndDestroy();
		if (err==KErrNone) break;
		else if (err==KErrOverflow) iBuf=iBuf->ReAllocL( iBuf->Des().MaxLength()*2 );
		else User::Leave(err);
	}

	TInt errorcount=0;

	while (errorcount<3) {
		TRequestStatus s;
		TUint id;
		iBBClient.Put(aName, KNullDesC, KContextLogComponent, 
			*iBuf, EBBPriorityNormal, EFalse, id, s);
		User::WaitForRequest(s);
		if (s.Int()==KErrNone) return;
		ConnectL();
	}
}

class TStopActive : public CActive, public MBBNotifier, public MTimeOut {
public:
	TStopActive() : CActive(EPriorityNormal), iProtocol(0) { }
	~TStopActive() { Cancel(); delete iTimer; }
	void ConstructL() { 
		iTimer=CTimeOut::NewL(*this); 
		CActiveScheduler::Add(this); 
		iStatus=KRequestPending; SetActive(); }
	void SetProtocol(CBBProtocol *aProtocol) { 
		iProtocol=aProtocol; 
		iProtocol->AddObserverL(this);
	}
	TRequestStatus* GetStatus() { return &iStatus; }

	TInt		iLastError, iAcks;
	TBool		iStoppedOnRequest;
private:
	void DoCancel() { iStatus=KErrCancel; TRequestStatus* s=&iStatus; User::RequestComplete(s, KErrCancel); }
	void RunL() {
		iStoppedOnRequest=ETrue;
		if (iProtocol) {
			iTimer->Wait(5);
			iProtocol->Disconnect(ETrue);
		} else {
			CActiveScheduler::Stop();
		}
	}

	CBBProtocol	*iProtocol;
	CTimeOut	*iTimer;

	virtual void Acked(TUint id) { ++iAcks; }
	virtual void Error(TInt aError, TInt aOrigError, const TDesC& aDescr) { 
		iLastError=aError;
		iProtocol->Disconnect(ETrue); 
		iTimer->Wait(5);
	}
	virtual void ReadyToWrite(TBool aReady) { }
	virtual void Disconnected() { iTimer->Reset(); CActiveScheduler::Stop(); }
	virtual void IncomingTuple(const CBBTuple* aTuple) { }
	void expired(CBase*) { CActiveScheduler::Stop(); }

};

class COwnScheduler : public CBaActiveScheduler {
public:
	void Error(TInt aError) const {
		User::Leave(aError);
		//CBaActiveScheduler::Error(aError);
	}
};

void start_contextnwL(const TDesC& aHost, TInt aPort, const TDesC& aAuthor, TInt aAP, worker_info* info)
{
	auto_ptr<CApp_context> c(CApp_context::NewL(true, _L("contextnetwork")));
	//auto_ptr<CActiveScheduler> activeScheduler(new (ELeave) CBaActiveScheduler);
	c->SetDebugLog(_L("Context"), _L("Network"));
	auto_ptr<CActiveScheduler> activeScheduler(new (ELeave) COwnScheduler);
	CActiveScheduler::Install(activeScheduler.get());

	auto_ptr<CBBDataFactory> bbf(CBBDataFactory::NewL());
	c->SetBBDataFactory(bbf.get());

	auto_ptr<TStopActive> stop(new (ELeave) TStopActive); stop->ConstructL();
	info->set_do_stop(stop->GetStatus());

	auto_ptr<CBBProtocol> proto(CBBProtocol::NewL(*c));
	stop->SetProtocol(proto.get());
	auto_ptr<CBBListener> listen(CBBListener::NewL(proto.get(), *c));
	proto->AddObserverL(listen.get());

	proto->ConnectL(aAP, aHost, aPort, aAuthor);

	CActiveScheduler::Start();

	if ( stop->iAcks == 0 && ! stop->iStoppedOnRequest)
		User::Leave(KContextErrTimeoutInBBProtocol);
	if ( ! stop->iStoppedOnRequest ) {
		TInt err=stop->iLastError;
		if (err==KErrNone) err=KErrUnknown;
		User::Leave(err);
	}
}

TInt CBBLoggerImpl::start_contextnw(TAny* aPtr)
{
        CTrapCleanup *cl;
        cl=CTrapCleanup::New();

	User::__DbgMarkStart(RHeap::EUser);

	worker_info *wi=(worker_info*)aPtr;
	TNetworkArgs *args=(TNetworkArgs*)wi->worker_args;

        TInt err=0;
        TRAP(err,
                start_contextnwL(args->iHost, args->iPort, args->iAuthor, args->iAP, wi));

	TTimeIntervalMicroSeconds32 w(5*1000);
	// yield
	User::After(w);
	wi->stopped(err);

	User::After(w);

	User::__DbgMarkEnd(RHeap::EUser,0);

	return err;
}

void CBBLoggerImpl::StartIfEnabledL()
{
	iStopping=EFalse;
	TBool nw_enabled=EFalse;
	if (Settings().GetSettingL(SETTING_CONTEXTNW_ENABLED, nw_enabled) && nw_enabled) {
		if (Settings().GetSettingL(SETTING_CONTEXTNW_HOST, iNetworkArgs.iHost) &&
				Settings().GetSettingL(SETTING_CONTEXTNW_PORT, iNetworkArgs.iPort) &&
				Settings().GetSettingL(SETTING_IP_AP, iNetworkArgs.iAP) &&
				iNetworkArgs.iAP>0
				) {

			Settings().GetSettingL(SETTING_PUBLISH_AUTHOR, iNetworkArgs.iAuthor);
			delete iNwCallback; iNwCallback=0;
			iNwCallback=CActiveCallback::NewL(*this);

			iContextNetwork.info.set_has_stopped(iNwCallback->GetStatus());
			iContextNetwork.start(_L("contextnw"), start_contextnw, (TAny*)&iNetworkArgs, EPriorityAbsoluteBackground);
		}
	}
}

void CBBLoggerImpl::ConstructL()
{
	Mlogger::ConstructL(AppContext());

	Settings().NotifyOnChange(SETTING_IP_AP, this);
	Settings().NotifyOnChange(SETTING_CONTEXTNW_PORT, this);
	Settings().NotifyOnChange(SETTING_CONTEXTNW_HOST, this);
	Settings().NotifyOnChange(SETTING_CONTEXTNW_ENABLED, this);

	iNwContext=CApp_context::NewL(true, _L("contextnetwork"));
	StartIfEnabledL();

	iBuf=HBufC8::NewL(2048);
	ConnectL();
}

void CBBLoggerImpl::Stop()
{
	iStopping=ETrue;
	iContextNetwork.stop();
	delete iNwCallback; iNwCallback=0;
}

CBBLoggerImpl::~CBBLoggerImpl()
{
	Stop();
	Settings().CancelNotifyOnChange(SETTING_IP_AP, this);
	Settings().CancelNotifyOnChange(SETTING_CONTEXTNW_PORT, this);
	Settings().CancelNotifyOnChange(SETTING_CONTEXTNW_HOST, this);
	Settings().CancelNotifyOnChange(SETTING_CONTEXTNW_ENABLED, this);
	iBBClient.Close();
	delete iBuf;
	delete iNwContext;
}

void CBBLoggerImpl::ConnectL()
{
	TInt errorcount=0;
	TInt err=KErrNone;
	while (errorcount<5) {
		iBBClient.Close();
		err=iBBClient.Connect();
		if (err==KErrNone) return;
		errorcount++;
	}
	User::Leave(err);
}

void CBBLoggerImpl::NotifyRunL(TInt aError)
{
	if (iStopping) return;
	TBuf<100> msg=_L("ContextNetwork stopped, error: ");
	msg.AppendNum(aError);
	msg.Append(_L("callstack:"));
	iCallBack->error(msg);
	auto_ptr<HBufC> stack(0);
	
	++iRestarts;

	TRAPD(err, stack.reset(iNwContext->CallStackMgr().GetFormattedCallStack(_L("ContextNetwork"))));
	if (err==KErrNone && stack.get()!=0) {
		iCallBack->status_change(*stack);
	}

	if (iRestarts>5 ||
		(aError==KContextErrTimeoutInBBProtocol && iRestarts>2) ) 
		User::Leave(aError);
	
	iCallBack->status_change(_L("restarting contextnetwork"));
	StartIfEnabledL();
}

void CBBLoggerImpl::SettingChanged(TInt Setting)
{
	Stop();
	StartIfEnabledL();
}
