#include "codeprompt.h"

#include "checkedactive.h"
#include <recognizerview.h>
#include "symbian_auto_ptr.h"
#include "cm_post.h"

const TUid KRecognizerView = {0x27};

class CVisualCodePromptImpl : public CVisualCodePrompt, public CCheckedActive, public MRecognizerCallback {
public:
	virtual ~CVisualCodePromptImpl();
private:
	CVisualCodePromptImpl(CAknViewAppUi *ViewAppUi, TUid LocalDefaultView, TVwsViewId* NextViewId);
	void ConstructL();

	virtual void Prompt(const TDesC& FileName, MUploadCallBack* CallBack);

	virtual void CodeSelected(const CCodeInfo& aCode);
	virtual void Cancelled();

	void Async();

	void CheckedRunL();
	void DoCancel();

	CRecognizerView*	iView;
	MUploadCallBack*	iCallBack;
	CAknViewAppUi		*iViewAppUi;
	TInt64			iCode;
	TBool			iGotCode;
	TUid iDefaultView;
	TVwsViewId* iNextViewId;

	friend class CVisualCodePrompt;
};

CVisualCodePrompt* CVisualCodePrompt::NewL(CAknViewAppUi *ViewAppUi, TUid LocalDefaultView, TVwsViewId* NextViewId)
{
	auto_ptr<CVisualCodePromptImpl> ret(new (ELeave) CVisualCodePromptImpl(ViewAppUi, LocalDefaultView, NextViewId));
	ret->ConstructL();
	return ret.release();
}

CVisualCodePrompt::~CVisualCodePrompt()
{
}

CVisualCodePromptImpl::CVisualCodePromptImpl(CAknViewAppUi *ViewAppUi, 
					     TUid LocalDefaultView, TVwsViewId* NextViewId) : CCheckedActive(EPriorityIdle, _L("CVisualCodePromptImpl")),
					iViewAppUi(ViewAppUi), iDefaultView(LocalDefaultView), iNextViewId(NextViewId)
{
}

CVisualCodePromptImpl::~CVisualCodePromptImpl()
{
}

void CVisualCodePromptImpl::ConstructL()
{
#ifdef USE_VISUALCODES
	iView=CRecognizerView::NewL(this, KRecognizerView, iDefaultView, iNextViewId);
#endif
	iViewAppUi->AddViewL(iView);

	CActiveScheduler::Add(this);
}

void CVisualCodePromptImpl::Prompt(const TDesC& /*FileName*/, MUploadCallBack* CallBack)
{
	iCallBack=CallBack;

	iViewAppUi->ActivateLocalViewL(KRecognizerView);
}

void CVisualCodePromptImpl::CheckedRunL()
{
	if (!iCallBack) return;

	MUploadCallBack* cb=iCallBack;
	iCallBack=0;
	if (!iGotCode) {
		cb->Back(false, false, 0);
	} else {

		auto_ptr<CCMPost> buf(CCMPost::NewL(0));

		buf->iParentId()=iCode;

		cb->Back(true, true, buf.get());
	}
}

void CVisualCodePromptImpl::CodeSelected(const CCodeInfo& aCode)
{
#ifdef USE_VISUALCODES
	iGotCode=ETrue;
	iCode=aCode.code->ToInt64();
#endif
	Async();
}

void CVisualCodePromptImpl::Cancelled()
{
	iGotCode=EFalse;
	Async();
}

void CVisualCodePromptImpl::DoCancel()
{
	return;
}

void CVisualCodePromptImpl::Async()
{
	TRequestStatus *s=&iStatus;
	User::RequestComplete(s, KErrNone);
	SetActive();
}