#include "test_log.h"
#include "list.h"
#include "symbian_auto_ptr.h"

class CTestLogImpl : public CTestLog
{
public:
	CTestLogImpl(MOutput& aOutput);
	virtual ~CTestLogImpl();
	void ConstructL();
	virtual void register_source(const TDesC& name, const TDesC& initial_value, const TTime& time);
	virtual void new_value(log_priority priority, const TDesC& name, const TDesC& value, const TTime& time);
	virtual void unregister_source(const TDesC& name, const TTime& time);
	virtual const TDesC& name() const;

	virtual TExpectItem& Expect(log_priority aPriority, const TDesC& aSource,
		const TDesC& aString, const TTime aTime);
	virtual TExpectItem& Expect(TExpectItem e);
	virtual void DontExpect();
	virtual void GotP();

	CList<TExpectItem> 	*iToExpect;
	MOutput&		iOutput;
};

CTestLog::~CTestLog()
{
}

CTestLog* CTestLog::NewL(MOutput& aOutput)
{
	auto_ptr<CTestLogImpl> ret(new (ELeave) CTestLogImpl(aOutput));
	ret->ConstructL();
	return ret.release();
}

CTestLogImpl::CTestLogImpl(MOutput& aOutput) : iOutput(aOutput)
{
}

CTestLogImpl::~CTestLogImpl()
{
	delete iToExpect;
}
void CTestLogImpl::ConstructL()
{
	iToExpect=CList<TExpectItem>::NewL();
}

void CTestLogImpl::register_source(const TDesC& /*name*/, 
	const TDesC& /*initial_value*/, const TTime& /*time*/)
{
}

void CTestLogImpl::new_value(log_priority priority, const TDesC& name, const TDesC& value, const TTime& time)
{
	TExpectItem got(priority, name, value, time);

	if (iToExpect->iCount==0) {
		iOutput.Print(_L("ERR: "));
		iOutput.Print(_L("Expected:- nothing; "));
	} else {
		TExpectItem e=iToExpect->Pop();
		if (e==got) {
			iOutput.Print(_L("OK: "));
		} else {
			iOutput.Print(_L("ERR: Expected:-"));
			e.Print(iOutput);
			iOutput.Print(_L("; "));
		}
	}
	iOutput.Print(_L("Got:- "));
	got.Print(iOutput);
	iOutput.Print(_L("\n"));
}

void CTestLogImpl::unregister_source(const TDesC& /*name*/, const TTime& /*time*/)
{
}

const TDesC& CTestLogImpl::name() const
{
	_LIT(KName, "CTestLogImpl");
	return KName;
}

CTestLogImpl::TExpectItem& CTestLogImpl::Expect(log_priority aPriority, const TDesC& aSource,
	const TDesC& aString, const TTime aTime)
{
	TExpectItem e(aPriority, aSource, aString, aTime);
	return Expect(e);
}

CTestLogImpl::TExpectItem& CTestLogImpl::Expect(TExpectItem e)
{
	iToExpect->AppendL(e);
	return iToExpect->iCurrent->Item;
}

void CTestLogImpl::DontExpect()
{
	iToExpect->reset();
}

void CTestLogImpl::GotP()
{
	while(iToExpect->iCount>0) {
		TExpectItem e=iToExpect->Pop();
		iOutput.Print(_L("ERR: Expected:-"));
		e.Print(iOutput);
		iOutput.Print(_L("; Got:- nothing\n"));
	}
}
