#!/usr/bin/perl

require LWP;
require LWP::Debug;

my $DO_SEND=1;

use Image::Info qw(image_info);

use URI;
use URI::Heuristic qw(uf_uri);

use HTTP::Status qw(status_message);
use HTTP::Date qw(time2str str2time);

my $URL="http://aware.uiah.fi/upload/put5.pl?";
my $IMSI="353798002870220";

my $SENDER='<sender><jabbernick>mikie@armi.hiit.fi</jabbernick><authorname>Mika</authorname></sender>';

sub xmlenc($) {
 my $i;
 my $output; my $input=shift;
 for ($i=0; $i<length($input); $i++) {
   my $char=substr($input, $i, 1);
   if ($char eq "<") { $char="&lt;"; }
   if ($char eq "&") { $char="&amp;"; }
   $output .= $char;
 }
 return $output;
}
 
 use Image::IPTCInfo;

  # Create new info object
  my $info = new Image::IPTCInfo($ARGV[0]);
  my $exif_info=image_info($ARGV[0]);

  # Check if file had IPTC data
  unless (defined($info)) { die Image::IPTCInfo::Error(); }

  # Get list of keywords, supplemental categories, or contacts
  #my $dt=$info->Attribute('date created') . "T"  . 
	#substr($info->Attribute('time created'), 0, 6);
  my $dt=$exif_info->{DateTime};
  $dt=~s/://g;
  $dt=~s/ /T/;
    
  $|=1;
  my $put="C;$dt%20;0;$IMSI/" . $ARGV[0];
  my $cmd="|POST '" . $URL . $put . "'";
  print $cmd, ": ";
  my $keywordsRef = $info->Keywords();
  my @kw=@$keywordsRef;
  if ( grep(/private/, @kw) ) {
	print "not sending private image $ARGV[0]\n";
	$DO_SEND=0;
  }

  if ($DO_SEND) {
	  open(CMD, $cmd);
	  open(INP, "<$ARGV[0]");
	  binmode(INP);
	  my $buf;
	  while(sysread(INP, $buf, 1024*1024)) { 
	    print ".";
	    print CMD $buf;
	  }
	  close(CMD);
  }
  print "\n";

  my $put="P;$dt%20;0;$IMSI/" . $ARGV[0];

  my $packet="<packet><tag>";
  push(@kw, $loc);

  my @locs=("sub-location", "city", "country/primary location name");
  foreach my $l (@locs) {
	if ($info->Attribute($l)) {
		push(@kw, $info->Attribute($l));
	}
  }

  my $keyw=join(":", @kw);
  $keyw=~s/:+/:/g;
  $keyw=~s/^://;
  $keyw=~s/:$//;
  $packet .= xmlenc($keyw);
  $packet .= "</tag><description>";
  $packet .= xmlenc($info->Attribute('caption/abstract'));
  $packet .= "</description>";
  $packet .= $SENDER;
  $packet .= "</packet>";

  my $cmd="|POST '" . $URL . $put . "'";
  print $cmd, "\n";
  if ($DO_SEND) {
	  open(CMD, $cmd);
	  print CMD $packet;
	  close(CMD);
  } else {
	print $packet;
  }

