#!/usr/bin/perl
format STDOUT =
@<<<<<<<<<<<<<<<<<<<<<<< size @>>>>>>>>>>
$ofile,			      $size
.

open(IN, "<all.pkg") || die "cannot open all.pkg";
while(<IN>) {
	next unless (/^\s*@/);
	unless (/^@\s*"([^"]*)",.*$/) {
		print STDERR "parse error on all.pkg line $_", "\n";
		next;
	}
	$file=$1;
	$file=~s/SIS/pkg/i;
	if ( open(PKG, "<$file") ) {
		while(<PKG>) {
			next unless (/^\s*"/);
			unless (/^\s*"([^"]*)".*$/) {
				print STDERR "parse error on file $file line $_", "\n";
				next;
			} 
			$ofile=$1;
			next unless ( 
				$ofile=~/app$/i ||
				$ofile=~/dll$/i ||
				$ofile=~/exe$/i );
			@s=stat($ofile);
			if ($#s==-1) {
				print STDERR "failed to stat $ofile\n";
			} else {
				$ofile=~s/.*\\([^\\]+)$/\1/;
				$size=$s[7];
				$total+=$size;
				write;
			}
		}
		close(PKG);
	} else {
		print "cannot open pkg file $file", "\n";
	}
}
$ofile="total"; $size=$total; 
write;
close(IN);
