#!/usr/bin/perl

$prev_error=-1;
$run_i=0;
$project=pop(@ARGV);
$build=shift @ARGV;
$platform=join(" ", @ARGV);

while($run_i < 5) {
	$run_i++;
	if ($cmd eq "") {
		$cmd="abld.bat $build $platform $project";
	}
	print "RUNNING $cmd\n";

	open(RES, "$cmd 2>&1 |");
	$error=0;
	$def="";
	while(<RES>) {
		print $_;
		if ($def eq "" && $error==4) {
			$def=$_;
			$def=~s/^ *([^(]+)\(.*/$1/;
			$def=~s/^.*\\SYMBIAN/\\SYMBIAN/i;
		}
		$error=1 if ($error != 4 && $error!=2 && /fatal error/i);
		$error=1 if ($error != 4 && $error!=2 && /^make.*Error/);
		if (! $error ) {
			$error=2 if (/export.*not yet Froze/);
		}
		if (! $error ) {
			$error=3 if (/Not attempting to create/);
		}
		if (/exported at wrong ordinal/) {
			$def=$_;
			$def=~s/^EFREEZE ERROR: //;
			$def=~s/^([^ ]+): .*/$1/;
			$def=~s/^.*\\SYMBIAN/\\SYMBIAN/i;
			$error=4;
		}
		if (/missing from object files/) {
			$def="";
			$error=4;
		}

	}
	close(RES);
	if ($prev_error==$error) {
		print "LOGIC ERROR IN run_abld.pl!\n";
		exit 5;
	}
	$cmd="";
	if ($prev_error==4 || $prev_error==3 || $prev_error==2) {
		# rerun
		$error=5;
	}
		
	$prev_error=$error;

	exit $error if ($error==0 || $error==1);

	if ($error==4) {
		print "DELETING old DEFFILE $def\n";
		system("del $def");
	}
	if ($error==4 || $error==3 || $error==2) {
		$cmd="abld.bat freeze $platform $project";
		$cmd=~s/U(DEB|REL)//i;
	}
}

exit $error;
