#!/usr/bin/perl

use Cwd;

open(BLDINF, "<bld.inf") || die "cannot open bld.inf";
$rootdir=getcwd;

while(<BLDINF>) {
	next if (m!^//!);
	next unless (/mmp$/i);
	
	chop; s/
//;
	$mmp=$_;

	/^(.*)\\([^\\]*).mmp$/i;
	($path, $file)=($1, $2);
	$file .= "_build.pkg";

	chdir($rootdir) || die "cannot chdir to $rootdir";
	chdir($path) || die "cannot chdir to $path";

	$buildsis=$file;
	$buildsis=~s/pkg/SIS/;
	$diffsis=$buildsis;
	$diffsis=~s/SIS/OLD/;
	if (-f $buildsis ) {
		system("copy $buildsis $diffsis");
		$ret=$? >> 8;
		if ($ret!=0) {
			exit $ret;
		}
	}

	$cmd="makesis $file";
	open(RES, "$cmd 2>&1 |");
	while(<RES>) {
		print $_;
		$error=1 if (/error/i);
	}
	close(RES);
	exit $error if ($error);

	system("diff --binary $buildsis $diffsis");
	if ($? == -1) {
		print "cannot run DIFF!\n";
		exit 1;
	}
	$ret=$? >> 8;
	if ($ret!=0) {
		print "\n";
		chdir($rootdir) || die "cannot chdir to $rootdir";
		chdir("..");
		system("perl update_version.pl $rootdir\\$path\\$file version.txt");
		if ($? == -1 || (($? >> 8) != 0) ) {
			print "failed to update version!\n",
			exit 1;
		}
		chdir($rootdir) || die "cannot chdir to $rootdir";
		chdir($path) || die "cannot chdir to $path";
	}

	$cmd="makesis $file";
	open(RES, "$cmd 2>&1 |");
	while(<RES>) {
		print $_;
		$error=1 if (/error/i);
	}
	close(RES);
	exit $error if ($error);

}

close(BLDINF);

exit 0;
