#!/usr/bin/perl -w
# server0.pl
#--------------------

use strict;
use Socket;
use Compress::Zlib;

my $setting="
  <tuple module='0x1020811e' id='7' major_version='1'
  minor_version='0'>
    <id>13</id>

    <tuplename>
      <module_uid>0x10208120</module_uid>

      <module_id>1</module_id>

      <subname>58</subname>
    </tuplename>

    <value module='0x1020811a' id='10' major_version='1'
    minor_version='0'>testproject</value>
  </tuple>
";

my $bt="";
open(BT, "<bt.xml") || die "cannot open bt.xml";
while(<BT>) {
	s/id>35<\/mod/id>37<\/mod/;
	$bt .= $_;
}
close(BT);

# use port 2000 as default
my $port = shift || 2000;
my $proto = getprotobyname('tcp');

# create a socket, make it reusable
socket(SERVER, PF_INET, SOCK_STREAM, $proto) or die "socket: $!";
setsockopt(SERVER, SOL_SOCKET, SO_REUSEADDR, 1) or die "setsock: $!";

# grab a port on this machine
my $paddr = sockaddr_in($port, INADDR_ANY);

# bind to a port, then listen
bind(SERVER, $paddr) or die "bind: $!";
listen(SERVER, SOMAXCONN) or die "listen: $!";
print "SERVER started on port $port\n";

$|=1;
my %ids;
# accepting a connection
my $client_addr;
my $sent_setting=0; my $sent_bt=0;

while ($client_addr = accept(CLIENT, SERVER)) {
	my ($iStr, $istatus) = inflateInit();
	my ($oStr, $ostatus) = deflateInit();

	# find out who connected
	my ($client_port, $client_ip) = sockaddr_in($client_addr);
	my $client_ipnum = inet_ntoa($client_ip);
	my $client_host = gethostbyaddr($client_ip, AF_INET);
	# print who has connected
	print "got a connection from: $client_host", "[$client_ipnum]\n";
	# send them a message, close connection
	select(CLIENT); $| = 1; select(STDOUT);
	my $in_buf;
	my $line;
	my $recv=0; my $uncompr=0;
	while( read(CLIENT, $in_buf, 1) > 0) {
		$recv++;
		my $st; my $buf;
		($buf, $st) = $iStr->inflate($in_buf);
		for (my $i=0; $i<length($buf); $i++) {
			$uncompr++;
			my $c=substr($buf, $i, 1);
			$line.=$c;
			#print "recv $line\n";
			if ($c eq "\n") {
			
				$_=$line;	
				print "RECV:", $line;
				$line="";
				my $resp="";
				if (/\<stream\>/) {
					$resp="<?xml version='1.0'?>\n<stream>\n";
				}
				next if (/\<ack>/);
				if (/\<id\>(\d+)\<\/id\>/) {
					print "id $1 count ", $ids{$1}++, "\n";
					$resp="<ack><id>$1</id></ack>\n";
				}

				if ($sent_setting==0 && /\<id\>(\d+)\<\/id\>/) {
					$resp .= $setting;
					$sent_setting=1;
				}
				elsif ($sent_bt==0 && /\<id\>(\d+)\<\/id\>/) {
					$resp .= $bt;
					$sent_bt=1;
				}

				if (/\<\/stream\>/) {
					$resp="</stream>\n";
				}
				unless ($resp eq "") {
					print "SEND:", $resp;
					my ($r, $status) = $oStr->deflate($resp);
					print CLIENT $r;
					($r, $status) = $oStr->flush(Z_SYNC_FLUSH);
					print CLIENT $r;
				}
			}
		}
	}
			
	close CLIENT;
	print "connection closed, received $recv bytes, uncompressed $uncompr\n";
}
