#!/usr/bin/perl -w

use strict;
use Compress::Zlib;
my ($iStr, $istatus) = inflateInit();

if ($istatus != Z_OK) { die "error in inflateInit"; }

my $raw;
my $line;
binmode STDIN;

while( read(STDIN, $raw, 1) > 0) {
	my $st; my $buf;
	($buf, $st) = $iStr->inflate($raw);
	if ($st != Z_OK && $st!=Z_STREAM_END) { die "error in inflate $st"; }
	for (my $i=0; $i<length($buf); $i++) {
		my $c=substr($buf, $i, 1);
		$line.=$c;
		if ($c eq "\n") {
			print $line;
			$line="";
		}
	}
}
