#!/usr/bin/perl

use Cwd;

$version=shift @ARGV;
$update_all_versions=shift @ARGV;

open(INV, "<$version") || die "cannot open $version";
while(<INV>) {
	chop;
	($t, $v)=split(/\s*=\s*/);
	$versions{lc($t)}=$v;
}
close(INV);
die "no minor version specified" if ($versions{'minor'} eq "");
die "no major version specified" if ($versions{'major'} eq "");

$version=~s/version\.txt/context_uids/;

my $v21=0;

if ($ENV{'EPOCROOT'} =~ /Series60_v21/i) { $v21=1; }

foreach $h ( ".rh", ".h") {
	$file=$version . $h;
	open(INV, "<$file") || die "cannot open version file";
	while(<INV>) {
		if (/^const/) {
			chop;
			/const tuid kuid([^ ]+) = { ([^ ]+) }/i;
			($name, $uid) = ($1, $2);
			unless ($defs{$uid} eq "") {
				$uids{lc($name)}=$defs{$uid};
			} else {
				$uids{lc($name)}=$uid;
			}
			#print lc($name), " ", $uids{lc($name)}, "\n";
		} elsif (/^#\s*define/) {
			/#\s*define\s+([^ \t]+)\s+([x0-9A-F]+)/i;
			$defs{$1}=$2;
		}
	}
	close(INV);
}

open(BLDINF, "<bld.inf") || die "cannot open bld.inf";
#print "DEBUG" .cwd;
#print "\n";
while(<BLDINF>) {
	next if (m!^//!);
	next unless (/mmp$/i);
	next if (/mdaaudioinputstreamplugin/);
	chop; s/
//;
	$name="";
	/.*\\([^\\.]+).mmp/i;
	$name=lc($1);
	s/mmp/pkg/i;
	$file=$_;

	die "no uid for $name" if ($uids{$name} eq "");

	open(IN, "<$file") || die "cannot open input $file";
	$file=~s/.pkg/_build.pkg/i;

	$prev_minor=$prev_major=0;
	if (open(OUT, "<$file")) {
		while(<OUT>) {
			if (/^#/) {
				/(.*, *)([0-9]+), *([0-9]+)( *,[0-9]+\s*)$/;
				($beg,$prev_major,$prev_minor,$rest)=($1,$2,$3,$4);
			}
		}
		close(OUT);
		#print "prev version $prev_major $prev_minor\n";
	} else {
		print "NO old build pkg file\n";
	}

	open(OUT, ">${file}") || die "cannot open output";

	while(<IN>) {
		if ($v21) {
			s/Series60_v20/Series60_v21/ig;
		} else {
			s/Series60_v21/Series60_v20/ig;
		}
		if (/^#/) {
			/(.*, *)([0-9]+), *([0-9]+)( *,[0-9]+\s*)$/;
			($beg,$major,$minor,$rest)=($1,$2,$3,$4);
			$major=$prev_major;
			$minor=$prev_minor;
			if ($update_all_versions || $prev_major==0) {
				$major=$versions{'major'};
			}
			if ($update_all_versions || $prev_minor==0) {
				$minor=$versions{'minor'};
			}
			#print "new version $major $minor\n";

			$beg=~s/(.*}, *\().*/$1/;
			$beg .= $uids{$name} . "),";
			
			print OUT $beg, $major, ",", $minor, $rest;
		} else {
			print OUT $_;
		}
	}

	close(IN);
	close(OUT);

	#system("move ${file}.tmp $file");
}

close(BLDINF);


@pkgs=<*.pkg>;
foreach $file (@pkgs) {
	open(OUT, ">${file}.tmp") || die "cannot open output";
	open(IN, "<$file") || die "cannot open input";

	while(<IN>) {
		if (/mdaaudioinputstreamplugin/) {
			print OUT $_;
			next;
		}
		if (/^#/ || /^@/) {
			$name="";
			/"([^"]*)"/;
			$name=lc($1);
			if ($name=~/\\/) {
				$name=~s/^.*\\([^\\]+)$/$1/;
			}
			$name=~s/_build//i;
			$name=~s/\.sis//i;
			$name=~s/_dbg//i;
			die "no uid for $name" if ($uids{$name} eq "");
			$uid=$uids{$name};
			s/\(0x[0-9A-F]+\)/($uid)/i;
		}
		if ($v21) {
			s/Series60_v20/Series60_v21/ig;
		} else {
			s/Series60_v21/Series60_v20/ig;
		}

		print OUT $_;
	}

	close(IN);
	close(OUT);

	system("move ${file}.tmp $file");
}
