/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


//ClientRequestHandler.h

#ifndef __CCLIENTREQUESTHANDLER_H
#define __CCLIENTREQUESTHANDLER_H

#include <e32base.h>
#include "checkedactive.h"
#include "ContextClientSession.h"
#include "RequestHandlerObserver.h"

class CClientRequestHandler : public CCheckedActive
{

public:
	IMPORT_C static CClientRequestHandler * NewL(MRequestHandlerObserver& aObserver) ;
	IMPORT_C static CClientRequestHandler * NewLC(MRequestHandlerObserver& aObserver) ;
	IMPORT_C ~CClientRequestHandler();

	//connect to ContextServer.exe via RPC
	IMPORT_C TInt ConnectToContextServer();

	IMPORT_C TPtrC GetPresenceInfo() const;

	// Requests to be used by context_log
	IMPORT_C void ConnectToPresenceServer(TDesC & username, TDesC & password, TDesC & server, TUint32 accessPointId);
	IMPORT_C void SuspendConnectionWithPresenceServer();
	IMPORT_C void ResumeConnectionWithPresenceServer();
	IMPORT_C void TerminateContextServer();
	IMPORT_C void UpdateUserPresence(TDesC & info);

	// Requests to be used by ContextBook
	IMPORT_C void RequestPresenceInfoNotification();

	IMPORT_C void CancelRequest();

protected: // from CCheckedActive
	void CheckedRunL();
	void DoCancel();

private:
	void ConstructL();
	CClientRequestHandler(MRequestHandlerObserver& aObserver);

private: // data
    
    	enum TPhase
	{
      		EPhaseIdle,
        	EPhaseWaitingForPresenceInfo,
		EPhaseWaitingForConnectionToPresenceServer,
		EPhaseWaitingForDisconnectionFromPresenceServer,
		EPhaseWaitingForServerToTerminate,
		EPhaseUpdatingUserInfo,
		EPhaseResumingConnection,
		EPhaseSuspendingConnection
	};

	TPhase current_state;		
    	RContextClientSession  		iSession;
	TBuf<500>			contact;
	TBuf<500>			presenceInfo;
  	MRequestHandlerObserver & 	iObserver;
};

#endif