/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#if !defined(APP_CONTEXT_H_INCLUDED)

#define APP_CONTEXT_H_INCLUDED 1

#include <f32file.h>
#include <charconv.h>
#include <e32std.h>
#include <etel.h>
#include <etelbgsm.h>
#include <etelagsm.h>
#include <saclient.h>
#include <aknglobalnote.h> 
#include <w32std.h>
#include "checkedactive.h"
#include "list.h"

#define DESTROY(x) { delete x; x=0; }

IMPORT_C void exceptionhandler(TExcType);

class MSettingListener {
public:
	virtual void SettingChanged(TInt Setting) = 0;
};

class MSettings {
public:
	virtual bool GetSettingL(TInt Setting, TDes& Value)= 0;
	virtual bool GetSettingL(TInt Setting, TInt& Value)= 0;
	virtual bool GetSettingL(TInt Setting, TTime& Value)= 0;
	// virtual bool GetSettingL(TInt Setting, TBool& Value)= 0; TBool is typedeffed to int
	virtual void WriteSettingL(TInt Setting, const TDesC& Value)= 0;
	virtual void WriteSettingL(TInt Setting, const TInt& Value)= 0;
	virtual void WriteSettingL(TInt Setting, const TTime& Value)= 0;
	// virtual void WriteSettingL(TInt Setting, const TBool& Value)= 0; TBool is typedeffed to int
	virtual ~MSettings() { }
	virtual void NotifyOnChange(TInt Setting, MSettingListener* Listener) = 0;
	virtual void CancelNotifyOnChange(TInt Setting, MSettingListener* Listener) = 0;
};

class MPausable {
public:
	virtual void pause() = 0;
	virtual void unpause() = 0;
	virtual bool is_paused() = 0;
};

class MActiveErrorReporter {
public:
	virtual void ReportError(const TDesC& Source,
		const TDesC& Reason, TInt Code) = 0;
};

typedef CList< TBuf<100> > CCallStack;

class MApp_context_access {
public:
	virtual RFs&	Fs() = 0;
	virtual RSystemAgent&	SysAgent() = 0;
	virtual RTelServer&	TelServer() = 0;
	virtual RAdvGsmPhone&	Phone() = 0;
	virtual CCnvCharacterSetConverter* CC() = 0;
	virtual bool NoSpaceLeft() = 0;
	virtual const TDesC& DataDir() = 0;
	virtual const TDesC& AppDir() = 0;
	virtual MSettings& Settings() = 0;
	virtual RWsSession& Ws() = 0;
	virtual void ReportActiveError(const TDesC& Source,
		const TDesC& Reason, TInt Code) = 0;
	virtual CCallStack& CallStack() = 0;
};

class MApp_context: public MApp_context_access {
public:
	IMPORT_C int	AddRef();
	IMPORT_C int	Release();
	virtual ~MApp_context();
	virtual RFs&	Fs() = 0;
	virtual RSystemAgent&	SysAgent() = 0;
	virtual RTelServer&	TelServer() = 0;
	virtual RAdvGsmPhone&	Phone() = 0;
	virtual CCnvCharacterSetConverter* CC() = 0;
	virtual bool NoSpaceLeft() = 0;
	virtual void SetFileLog(MPausable* log) = 0;
	virtual void SetActiveErrorReporter(MActiveErrorReporter* Reporter) = 0;
	virtual void SetDataDir(const TDesC& Dir) = 0;
	virtual const TDesC& DataDir() = 0;
	virtual const TDesC& AppDir() = 0;
	virtual MSettings& Settings() = 0;
	virtual RWsSession& Ws() = 0;
	virtual void ReportActiveError(const TDesC& Source,
		const TDesC& Reason, TInt Code) = 0;
	IMPORT_C static MApp_context* Static();
	virtual CCallStack& CallStack() = 0;
private:
	int		refcount;
};

class CApp_context : public MApp_context, public CCheckedActive {
public:
	IMPORT_C static CApp_context* NewL();
	virtual ~CApp_context();
	virtual RFs&	Fs();
	virtual RSystemAgent&	SysAgent();
	virtual RTelServer&	TelServer();
	virtual RAdvGsmPhone&	Phone();
	virtual CCnvCharacterSetConverter* CC();
	virtual bool NoSpaceLeft();
	virtual void SetFileLog(MPausable* log);
	virtual const TDesC& DataDir();
	virtual const TDesC& AppDir();
	virtual void SetDataDir(const TDesC& Dir);
	virtual void SetAppDir(const TDesC& Dir);
	virtual MSettings& Settings(); 
	virtual void SetActiveErrorReporter(MActiveErrorReporter* Reporter);
	virtual void SetSettings(MSettings* Settings);  // takes ownership
	virtual RWsSession& Ws();
	virtual void ReportActiveError(const TDesC& Source,
		const TDesC& Reason, TInt Code);
	virtual CCallStack& CallStack();
private:
	CApp_context();
	void ConstructL();
	virtual void CheckedRunL();
	virtual void DoCancel();

	RFs	iFs;
	RSystemAgent	iSysAgent;
	RTelServer	iTelServer;
	RAdvGsmPhone	iPhone;
	CCnvCharacterSetConverter* cc;
	TInt64		iDiskSpaceLimit;
	TInt		iDrive;
	bool		iSpaceLeft;
	CAknGlobalNote *globalNote;
	MPausable	*iFileLog;
	MSettings	*iSettings;
	MActiveErrorReporter	*iReporter;
	TFileName	iDataDir;
	TFileName	iAppDir;
	CCallStack	*iCallStack;
};

class MContextBase : public MApp_context_access {
public:
	IMPORT_C MContextBase();
	IMPORT_C MContextBase(MApp_context& Context, bool OwnedByContext=false);
	IMPORT_C virtual ~MContextBase();
	IMPORT_C MApp_context&	AppContext();
	IMPORT_C virtual RFs&	Fs();
	IMPORT_C virtual RSystemAgent&	SysAgent();
	IMPORT_C virtual RTelServer&	TelServer();
	IMPORT_C virtual RAdvGsmPhone&	Phone();
	IMPORT_C virtual CCnvCharacterSetConverter* CC();
	IMPORT_C virtual bool NoSpaceLeft();
	IMPORT_C virtual const TDesC& DataDir();
	IMPORT_C virtual const TDesC& AppDir();
	IMPORT_C virtual MSettings& Settings(); 
	IMPORT_C virtual RWsSession& Ws();
	IMPORT_C void SetOwnedByContext();
	IMPORT_C bool OwnedByContext();
	IMPORT_C virtual void ReportActiveError(const TDesC& Source,
		const TDesC& Reason, TInt Code);
	IMPORT_C virtual CCallStack& CallStack();
private:
	MApp_context&	iContext;
	bool		iOwnedByContext;
};

class TCallStackItem {
public:
	IMPORT_C TCallStackItem(const TDesC& Name);
	IMPORT_C ~TCallStackItem();
private:
	bool	iOnStack;
};

IMPORT_C void NoAppContext();
IMPORT_C void MoveIntoDataDirL(MApp_context_access& Context, const TDesC& FileName);

#define CALLSTACKITEM(X)	TCallStackItem __item((X));

#endif
