/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#if !defined(INDEPENDENT_H_INCLUDED)

#define INDEPENDENT_H_INCLUDED

#include <e32std.h>

struct worker_info {
	TThreadId worker_threadid;
	TThreadId parent_threadid;
	TRequestStatus  *do_stop;
	TRequestStatus  is_stopped;
	TAny*	   worker_args;

	IMPORT_C void please_stop();
	IMPORT_C void stopped();
	IMPORT_C void wait_for_stop();
	IMPORT_C bool stop_requested();
	IMPORT_C void set_do_stop(TRequestStatus* s);

	IMPORT_C worker_info();
	IMPORT_C ~worker_info();
private:
	TRequestStatus  *i_do_stop;
};

class independent_worker {
public:
	IMPORT_C void start(const TDesC& name, TThreadFunction aFunction, TAny* worker_args);
	IMPORT_C void stop();
	IMPORT_C ~independent_worker();
	IMPORT_C independent_worker();
private:
	bool is_started;
	worker_info info;
};

#endif
