/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#ifndef SYMBIAN_TREE_H_INCLUDED
#define SYMBIAN_TREE_H_INCLUDED 1

#include "store.h"
#include <s32btree.h>

class CGenericIntMap : public MGenericIntMap,  public CBase
{
public:
	IMPORT_C virtual void AddDataL(uint32 Key, void* data, bool overwrite=false);
	IMPORT_C virtual void* GetData(uint32 Key);
	IMPORT_C virtual ~CGenericIntMap();
	IMPORT_C virtual int Count() const;
	IMPORT_C virtual void DeleteL(uint32 Key);
	IMPORT_C virtual void SetDeletor( void(*delete_func)(void* data) );
	IMPORT_C static CGenericIntMap* NewL();
	IMPORT_C virtual void Reset();
	IMPORT_C virtual MGenericIntMapIterator* CreateIterator();

	struct Entry {
		uint32	key;
		void*	data;
	};
private:

	class GenKey : public MBtreeKey {
	public:
		virtual void Between(const TAny* aLeft,const TAny* aRight,TBtreePivot& aPivot) const;
		virtual TInt Compare(const TAny* aLeft,const TAny* aRight) const;
		virtual const TAny* Key(const TAny* anEntry) const;
	};

	CGenericIntMap();
	void ConstructL();

	TBtreeFix<Entry, uint32>* iTree;
	GenKey iKey;
	CMemPagePool* iPool;
	void(*iDeletor)(void* data);

	int iCount;
};


#endif // SYMBIAN_TREE_H_INCLUDED
