/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#ifndef CC_XML_H_INCLUDED
#define CC_XML_H_INCLUDED 1

#include "app_context.h"
#include "expat.h"
#include "list.h"

class MXmlHandler {
public:
	virtual void StartElement(const XML_Char *name,
				const XML_Char **atts) = 0;

	virtual void EndElement(const XML_Char *name) = 0;
	virtual void CharacterData(const XML_Char *s,
				    int len) = 0;
	virtual void Error(XML_Error Code, const XML_LChar * String, long ByteIndex) = 0;
};

class CXmlParser : public CBase {
public:
	static CXmlParser* NewL(MXmlHandler& Handler);
	void Parse(const char*, int len, int isFinal);
	~CXmlParser();
private:
	static void StartElement(void *userData,
				   const XML_Char *name,
				   const XML_Char **atts);

	static void EndElement(void *userData,
				 const XML_Char *name);
	static void CharacterData(void *userData,
				    const XML_Char *s,
				    int len);

	CXmlParser(MXmlHandler& Handler);
	void ConstructL();

	MXmlHandler&	iHandler;
	XML_Parser	iParser;
};

#endif
