/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#include "checkedactive.h"
#include "app_context.h"

EXPORT_C CCheckedActive::~CCheckedActive()
{
}

EXPORT_C CCheckedActive::CCheckedActive(TInt aPriority, const TDesC& Name) : CActive(aPriority)
{
	iName=Name.Left(40);
}

EXPORT_C TInt CCheckedActive::RunError(TInt aError)
{

	TInt ret=CheckedRunError(aError);
	
	if (ret!=KErrNone) {
		MApp_context* c=MApp_context::Static();
		if (c) {
			HBufC* stack=0;
			TRAPD(err, stack=HBufC::NewL( (c->CallStack().iCount+1)*101));
			if (err==KErrNone) {
				CleanupStack::PushL(stack);
				stack->Des().Append(iName);
				stack->Des().Append(_L(":"));
				CCallStack::Node* i=c->CallStack().iFirst;
				while (i) {
					stack->Des().Append(i->Item);
					stack->Des().Append(_L("|"));
					i=i->Next;
				}
				c->ReportActiveError(*stack,
					_L("Active Object Run Error"), ret);
				c->CallStack().reset();
				CleanupStack::PopAndDestroy(); // stack
			} else {
				c->ReportActiveError(iName,
					_L("Active Object Run Error"), ret);
			}
		}
	}
	return ret;
}

EXPORT_C void CCheckedActive::SetActive()
{
	if (iStatus!=KRequestPending) {
		TInt x;
		x=1;
	}
	CActive::SetActive();
}

EXPORT_C TInt CCheckedActive::CheckedRunError(TInt aError)
{
	return aError;
}

EXPORT_C void CCheckedActive::RunL()
{
	MApp_context* c=MApp_context::Static();
	if (c) {
		c->CallStack().reset();
	}
	CheckedRunL();
	if (c) {
		c->CallStack().reset();
	}
}