#include "icons.h"

#include <eikenv.h> 
#include <avkon.mbg>
#include <contextcommon.mbg>
#include <bautils.h>

#define MIN(x,y) (x<y?x:y)
#define _INIT_LITC(txt,maxlen) { MIN(sizeof(txt)-1,maxlen), L##txt}
#define _INIT_T_ICON_ID(txt,val1,val2) { _INIT_LITC(txt,KMaxTextLen), val1, val2}

const TInt KNbIcons=24;

_LIT(KMbmAvkon, "Z:\\system\\data\\avkon.mbm");
#ifndef __WINS__
_LIT(KMbmBook,  "Z:\\system\\data\\contextcommon.mbm");
#else
_LIT(KMbmBook,  "C:\\system\\data\\contextcommon.mbm");
#endif

static const TIconID iconId[KNbIcons]=
{
    _INIT_T_ICON_ID("Z:\\system\\data\\avkon.mbm", EMbmAvkonQgn_stat_bt_blank, EMbmAvkonQgn_stat_bt_blank +1),
	_INIT_T_ICON_ID("Z:\\system\\data\\avkon.mbm", EMbmAvkonQgn_prop_nrtyp_address, EMbmAvkonQgn_prop_nrtyp_address_mask ),
    _INIT_T_ICON_ID("Z:\\system\\data\\avkon.mbm", EMbmAvkonQgn_prop_nrtyp_email, EMbmAvkonQgn_prop_nrtyp_email_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\avkon.mbm", EMbmAvkonQgn_prop_nrtyp_fax, EMbmAvkonQgn_prop_nrtyp_fax_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\avkon.mbm", EMbmAvkonQgn_prop_nrtyp_home, EMbmAvkonQgn_prop_nrtyp_home_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\avkon.mbm", EMbmAvkonQgn_prop_nrtyp_mobile, EMbmAvkonQgn_prop_nrtyp_mobile_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\avkon.mbm", EMbmAvkonQgn_prop_nrtyp_note, EMbmAvkonQgn_prop_nrtyp_note_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\avkon.mbm", EMbmAvkonQgn_prop_nrtyp_pager, EMbmAvkonQgn_prop_nrtyp_pager_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\avkon.mbm", EMbmAvkonQgn_prop_nrtyp_phone, EMbmAvkonQgn_prop_nrtyp_phone_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\avkon.mbm", EMbmAvkonQgn_prop_nrtyp_url, EMbmAvkonQgn_prop_nrtyp_url_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\avkon.mbm", EMbmAvkonQgn_prop_nrtyp_work, EMbmAvkonQgn_prop_nrtyp_work_mask ),
	
	#ifndef __WINS__

	_INIT_T_ICON_ID("C:\\system\\data\\contextcommon.mbm", EMbmContextcommonSpeaker_on, EMbmContextcommonSpeaker_on_mask ),
	_INIT_T_ICON_ID("C:\\system\\data\\contextcommon.mbm", EMbmContextcommonSpeaker_on_grey, EMbmContextcommonSpeaker_on_grey_mask ),
	_INIT_T_ICON_ID("C:\\system\\data\\contextcommon.mbm", EMbmContextcommonSpeaker_off, EMbmContextcommonSpeaker_off_mask ),
	_INIT_T_ICON_ID("C:\\system\\data\\contextcommon.mbm", EMbmContextcommonSpeaker_off_grey, EMbmContextcommonSpeaker_off_grey_mask ),
	
	_INIT_T_ICON_ID("C:\\system\\data\\contextcommon.mbm", EMbmContextcommonVibrator_on, EMbmContextcommonVibrator_on_mask ),
	_INIT_T_ICON_ID("C:\\system\\data\\contextcommon.mbm", EMbmContextcommonVibrator_on_grey, EMbmContextcommonVibrator_on_grey_mask ),
	_INIT_T_ICON_ID("C:\\system\\data\\contextcommon.mbm", EMbmContextcommonVibrator_off, EMbmContextcommonVibrator_off_mask ),
	_INIT_T_ICON_ID("C:\\system\\data\\contextcommon.mbm", EMbmContextcommonVibrator_off_grey, EMbmContextcommonVibrator_off_grey_mask ),

	_INIT_T_ICON_ID("C:\\system\\data\\contextcommon.mbm", EMbmContextcommonUser_active, EMbmContextcommonUser_active_mask ),
	_INIT_T_ICON_ID("C:\\system\\data\\contextcommon.mbm", EMbmContextcommonUser_inactive, EMbmContextcommonUser_inactive_mask ),
	_INIT_T_ICON_ID("C:\\system\\data\\contextcommon.mbm", EMbmContextcommonUser_inactive_lvl_1, EMbmContextcommonUser_inactive_mask ),
	_INIT_T_ICON_ID("C:\\system\\data\\contextcommon.mbm", EMbmContextcommonUser_inactive_lvl_2, EMbmContextcommonUser_inactive_mask ),
	_INIT_T_ICON_ID("C:\\system\\data\\contextcommon.mbm", EMbmContextcommonUser_inactive_lvl_3, EMbmContextcommonUser_inactive_mask )

	#else

	_INIT_T_ICON_ID("Z:\\system\\data\\contextcommon.mbm", EMbmContextcommonSpeaker_on, EMbmContextcommonSpeaker_on_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\contextcommon.mbm", EMbmContextcommonSpeaker_on_grey, EMbmContextcommonSpeaker_on_grey_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\contextcommon.mbm", EMbmContextcommonSpeaker_off, EMbmContextcommonSpeaker_off_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\contextcommon.mbm", EMbmContextcommonSpeaker_off_grey, EMbmContextcommonSpeaker_off_grey_mask ),
	
	_INIT_T_ICON_ID("Z:\\system\\data\\contextcommon.mbm", EMbmContextcommonVibrator_on, EMbmContextcommonVibrator_on_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\contextcommon.mbm", EMbmContextcommonVibrator_on_grey, EMbmContextcommonVibrator_on_grey_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\contextcommon.mbm", EMbmContextcommonVibrator_off, EMbmContextcommonVibrator_off_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\contextcommon.mbm", EMbmContextcommonVibrator_off_grey, EMbmContextcommonVibrator_off_grey_mask ),

	_INIT_T_ICON_ID("Z:\\system\\data\\contextcommon.mbm", EMbmContextcommonUser_active, EMbmContextcommonUser_active_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\contextcommon.mbm", EMbmContextcommonUser_inactive, EMbmContextcommonUser_inactive_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\contextcommon.mbm", EMbmContextcommonUser_inactive_lvl_1, EMbmContextcommonUser_inactive_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\contextcommon.mbm", EMbmContextcommonUser_inactive_lvl_2, EMbmContextcommonUser_inactive_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\contextcommon.mbm", EMbmContextcommonUser_inactive_lvl_3, EMbmContextcommonUser_inactive_mask )

	#endif
};

EXPORT_C TInt GetIconBitmap(TInt index)
{
	return iconId[index].iBitmap;
}

EXPORT_C TInt GetIconMask(TInt index)
{
	return iconId[index].iMask;
}


EXPORT_C const TDesC& GetIconMbm(TInt index)
{
	return iconId[index].iMbmFile;
}

EXPORT_C void LoadIcons(CAknIconArray * aIconList)
{
	TFileName real; TFileName prev;
	CEikonEnv* env=CEikonEnv::Static();
	RFs& fs=env->FsSession();
	for (int i = 0; i<KNbIcons;i++)
	{
		if (prev.Compare(iconId[i].iMbmFile)) {
			real=iconId[i].iMbmFile;
			if (! BaflUtils::FileExists(fs, real)) {
				real.Replace(0, 1, _L("e"));
			}
			prev=iconId[i].iMbmFile;
		}
		aIconList->AppendL(env->CreateIconL( real, iconId[i].iBitmap, iconId[i].iMask));
	}
}

EXPORT_C TInt GetIconIndex(TInt identifier)
{
	for (int i = 0; i<KNbIcons;i++)
	{
		if ( iconId[i].iBitmap == identifier )
		{
			return i;
		}
	}	
	return 0; // index of empty icon
}