/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#include "independent.h"

EXPORT_C worker_info::worker_info()
{
	i_do_stop=new TRequestStatus;
	do_stop=i_do_stop;
	*do_stop=KRequestPending;
	is_stopped=KRequestPending;
}

EXPORT_C worker_info::~worker_info()
{
	delete i_do_stop;
}

EXPORT_C bool worker_info::stop_requested()
{
	if (*do_stop!=KRequestPending) return true;
	return false;
}

EXPORT_C void worker_info::set_do_stop(TRequestStatus* s)
{
	// FIXME: race condition
	do_stop=s;
	*do_stop=KRequestPending;
}

EXPORT_C void worker_info::please_stop()
{
	RThread t;
	t.Open(worker_threadid);
	TRequestStatus* s;
	s=do_stop;
	t.RequestComplete(s, 1);
	t.Close();
}

EXPORT_C void worker_info::stopped()
{
	RThread t;
	t.Open(parent_threadid);
	TRequestStatus* s;
	s=&is_stopped;
	t.RequestComplete(s, 1);
	t.Close();
}

EXPORT_C void worker_info::wait_for_stop()
{
	if (is_stopped==KRequestPending) 
		User::WaitForRequest(is_stopped);
}

EXPORT_C void independent_worker::start(const TDesC& name, TThreadFunction aFunction, TAny* worker_args)
{
	RThread t; RThread me;
	info.parent_threadid=me.Id();
	info.worker_args=worker_args;
	t.Create(name, aFunction, 4096, 1024*128, 1024*1024, (TAny*) &info);
	info.worker_threadid=t.Id(),
        //t.SetPriority(EPriorityNormal);
	t.SetPriority(EPriorityAbsoluteForeground);
        t.Resume();
	t.Close();
	is_started=true;
}

EXPORT_C void independent_worker::stop()
{
	if (!is_started) return;
	info.please_stop();

	TTimeIntervalMicroSeconds32 w(50*1000);
	User::After(w);

	info.wait_for_stop();
	is_started=false;
}

EXPORT_C independent_worker::~independent_worker()
{
	stop();
}
	
EXPORT_C independent_worker::independent_worker()
{
	is_started=false;
}
