#include "presencedetailview.h"
#include "contextcommon.rsg"
#include <aknviewappui.h>
#include <bautils.h>
#include <eiklabel.h>
#include <eikimage.h>
#include "icons.h"
#include <contextbook.mbg>
#include <gulalign.h>

class CPresenceDetailContainer : public CCoeControl {
public:
	CPresenceDetailContainer(const TDesC& Name, const MPresenceData* PresenceData);
	~CPresenceDetailContainer();
	void ConstructL(const TRect& aRect);

private:
        void SizeChanged();
        TInt CountComponentControls() const;
        CCoeControl* ComponentControl(TInt aIndex) const;
        void Draw(const TRect& aRect) const;
		void SetSizeOfComponents();

	const TDesC&		iName;
	const MPresenceData*	iPresence;
	CEikLabel * title;
	CEikLabel * prev_loc_title;
	CEikLabel * prev_loc;
	CEikLabel * curr_loc_title;
	CEikLabel * curr_loc;
	CEikLabel * curr_profile_title;
	CEikLabel * curr_profile_name;
	CEikLabel * curr_profile_speaker;
	CEikLabel * curr_profile_speaker_volume;
	CEikLabel * curr_profile_vib;
	CEikLabel * user_active;
	CEikImage * icon_speaker;
	CEikImage * icon_vibra;

};

class CPresenceDetailViewImpl : public CPresenceDetailView {
private:
	CPresenceDetailViewImpl();
	void ConstructL();

	virtual void SetData(const TDesC& Name, const MPresenceData* PresenceData);
	
		TUid Id() const;

	
        void HandleCommandL(TInt aCommand);
        void DoActivateL(const TVwsViewId& aPrevViewId,
		TUid aCustomMessageId,
		const TDesC8& aCustomMessage);
        void DoDeactivate();

	friend class CPresenceDetailView;

	TBuf<100>	iName;
	const MPresenceData*	iPresence;
	CPresenceDetailContainer* iContainer;
	TVwsViewId	iPrevView;
	TInt		iResource;
public:
	virtual ~CPresenceDetailViewImpl();
};

EXPORT_C CPresenceDetailView* CPresenceDetailView::NewL()
{
	auto_ptr<CPresenceDetailViewImpl> ret(new (ELeave) CPresenceDetailViewImpl);
	ret->ConstructL();
	return ret.release();
}

CPresenceDetailContainer::CPresenceDetailContainer(const TDesC& Name, const MPresenceData* PresenceData) : 
	iName(Name), iPresence(PresenceData)
{
}

CPresenceDetailContainer::~CPresenceDetailContainer()
{
	delete title;
	delete prev_loc_title;
	delete prev_loc;
	delete curr_loc_title;
	delete curr_loc;
	delete curr_profile_title;
	delete curr_profile_name;
	delete curr_profile_speaker;
	delete curr_profile_speaker_volume;
	delete curr_profile_vib;
	delete user_active;
	delete icon_speaker;
	delete icon_vibra;
}

void CPresenceDetailContainer::ConstructL(const TRect& aRect)
{
	CreateWindowL(); 

	TRgb light_gray = TRgb(225,225,225);
	TRgb dark_gray = TRgb(210,210,210);

	TBuf<128> t;
	CEikonEnv::Static()->ReadResourceAsDes16(t, R_TITLE);
 	TBuf<128> p_l;
	CEikonEnv::Static()->ReadResourceAsDes16(p_l, R_PREVIOUS_LOCATION);
	TBuf<128> p_l_template;
	CEikonEnv::Static()->ReadResourceAsDes16(p_l_template, R_PREVIOUS_LOCATION_TEMPLATE);
    TBuf<128> c_l;
	CEikonEnv::Static()->ReadResourceAsDes16(c_l, R_CURRENT_LOCATION);
	TBuf<128> c_l_template;
	CEikonEnv::Static()->ReadResourceAsDes16(c_l_template, R_CURRENT_LOCATION_TEMPLATE);
	TBuf<20> c_p;
	CEikonEnv::Static()->ReadResourceAsDes16(c_p, R_CURRENT_PROFILE);
	TBuf<20> sp;
	CEikonEnv::Static()->ReadResourceAsDes16(sp, R_SPEAKER);
	TBuf<20> sp_vol;
	CEikonEnv::Static()->ReadResourceAsDes16(sp_vol, R_SP_VOLUME);
	TBuf<20> vib;
	CEikonEnv::Static()->ReadResourceAsDes16(vib, R_VIBRATOR);
	TBuf<10> on;
	CEikonEnv::Static()->ReadResourceAsDes16(on, R_ON);
	TBuf<10> off;
	CEikonEnv::Static()->ReadResourceAsDes16(off, R_OFF);
	TBuf<128> u_a_template;
	CEikonEnv::Static()->ReadResourceAsDes16(u_a_template, R_USER_ACTIVE_TEMPLATE);
	TBuf<128> u_i_template;
	CEikonEnv::Static()->ReadResourceAsDes16(u_i_template, R_USER_INACTIVE_TEMPLATE);
	TBuf<128> o_o_d;
	CEikonEnv::Static()->ReadResourceAsDes16(o_o_d, R_OUT_OF_DATE);
	TBuf<128> no_info;
	CEikonEnv::Static()->ReadResourceAsDes16(no_info, R_NO_INFO);

	//--------------------------

	TBuf<250> temp;
	
	title=new (ELeave) CEikLabel;
	title->SetContainerWindowL(*this);
	title->SetFont(CEikonEnv::Static()->DenseFont());
	title->SetUnderlining(ETrue);
	temp.Append(t);
	temp.Append(iName);
	title->SetTextL( temp );
	title->SetAlignment(TGulAlignment(EHCenterVTop));
	title->SetAllMarginsTo(2);

	prev_loc_title=new (ELeave) CEikLabel;
	prev_loc_title->SetContainerWindowL(*this);
	prev_loc_title->SetFont(CEikonEnv::Static()->DenseFont());
	prev_loc_title->SetEmphasis(CEikLabel::EFullEmphasis);
    prev_loc_title->OverrideColorL(EColorLabelTextEmphasis, KRgbBlack);
    prev_loc_title->OverrideColorL(EColorLabelHighlightFullEmphasis, dark_gray); 
	prev_loc_title->SetTextL(p_l);
	prev_loc_title->SetAllMarginsTo(2);
	
	prev_loc=new (ELeave) CEikLabel;
	prev_loc->SetContainerWindowL(*this);
	prev_loc->SetEmphasis(CEikLabel::EFullEmphasis);
    prev_loc->OverrideColorL(EColorLabelTextEmphasis, KRgbBlack);
    prev_loc->OverrideColorL(EColorLabelHighlightFullEmphasis, dark_gray); 
	prev_loc->SetFont(CEikonEnv::Static()->DenseFont());
	prev_loc->SetAllMarginsTo(2);

	curr_loc_title=new (ELeave) CEikLabel;
	curr_loc_title->SetContainerWindowL(*this);
	curr_loc_title->SetTextL( c_l );
	curr_loc_title->SetFont(CEikonEnv::Static()->DenseFont());
	curr_loc_title->SetAllMarginsTo(2);
	curr_loc_title->SetEmphasis(CEikLabel::EFullEmphasis);
	curr_loc_title->OverrideColorL(EColorLabelTextEmphasis, KRgbBlack);
    curr_loc_title->OverrideColorL(EColorLabelHighlightFullEmphasis, light_gray); 
	

	curr_loc=new (ELeave) CEikLabel;
	curr_loc->SetContainerWindowL(*this);
	curr_loc->SetFont(CEikonEnv::Static()->DenseFont());
	curr_loc->SetAllMarginsTo(2);
	curr_loc->SetEmphasis(CEikLabel::EFullEmphasis);
	curr_loc->OverrideColorL(EColorLabelTextEmphasis, KRgbBlack);
    curr_loc->OverrideColorL(EColorLabelHighlightFullEmphasis, light_gray); 
	

	curr_profile_title=new (ELeave) CEikLabel;
	curr_profile_title->SetContainerWindowL(*this);
	curr_profile_title->SetFont(CEikonEnv::Static()->DenseFont());
	curr_profile_title->SetEmphasis(CEikLabel::EFullEmphasis);
    curr_profile_title->OverrideColorL(EColorLabelTextEmphasis, KRgbBlack);
    curr_profile_title->OverrideColorL(EColorLabelHighlightFullEmphasis, dark_gray); 
	curr_profile_title->SetTextL( c_p );
	curr_profile_title->SetAllMarginsTo(2);

	curr_profile_name=new (ELeave) CEikLabel;
	curr_profile_name->SetContainerWindowL(*this);
	curr_profile_name->SetFont(CEikonEnv::Static()->DenseFont());
	curr_profile_name->SetEmphasis(CEikLabel::EFullEmphasis);
    curr_profile_name->OverrideColorL(EColorLabelTextEmphasis, KRgbBlack);
    curr_profile_name->OverrideColorL(EColorLabelHighlightFullEmphasis, dark_gray); 
	curr_profile_name->SetAllMarginsTo(2);
	
	curr_profile_speaker=new (ELeave) CEikLabel;
	curr_profile_speaker->SetContainerWindowL(*this);
	curr_profile_speaker->SetFont(CEikonEnv::Static()->DenseFont());
	curr_profile_speaker->SetEmphasis(CEikLabel::EFullEmphasis);
    curr_profile_speaker->OverrideColorL(EColorLabelTextEmphasis, KRgbBlack);
    curr_profile_speaker->OverrideColorL(EColorLabelHighlightFullEmphasis, dark_gray); 
	curr_profile_speaker->SetAllMarginsTo(2);
	
	curr_profile_speaker_volume=new (ELeave) CEikLabel;
	curr_profile_speaker_volume->SetContainerWindowL(*this);
	curr_profile_speaker_volume->SetFont(CEikonEnv::Static()->DenseFont());
	curr_profile_speaker_volume->SetEmphasis(CEikLabel::EFullEmphasis);
    curr_profile_speaker_volume->OverrideColorL(EColorLabelTextEmphasis, KRgbBlack);
    curr_profile_speaker_volume->OverrideColorL(EColorLabelHighlightFullEmphasis, dark_gray); 
	curr_profile_speaker_volume->SetAllMarginsTo(2);
	curr_profile_speaker_volume->SetTextL(_L(" "));
	
	curr_profile_vib=new (ELeave) CEikLabel;
	curr_profile_vib->SetContainerWindowL(*this);
	curr_profile_vib->SetFont(CEikonEnv::Static()->DenseFont());
	curr_profile_vib->SetEmphasis(CEikLabel::EFullEmphasis);
    curr_profile_vib->OverrideColorL(EColorLabelTextEmphasis, KRgbBlack);
    curr_profile_vib->OverrideColorL(EColorLabelHighlightFullEmphasis, dark_gray); 
	curr_profile_vib->SetAllMarginsTo(2);
		
	user_active=new (ELeave) CEikLabel;
	user_active->SetContainerWindowL(*this);
	user_active->SetFont(CEikonEnv::Static()->DenseFont());
	user_active->SetAllMarginsTo(2);
	user_active->SetEmphasis(CEikLabel::EFullEmphasis);
	user_active->OverrideColorL(EColorLabelTextEmphasis, KRgbBlack);
    user_active->OverrideColorL(EColorLabelHighlightFullEmphasis, light_gray);

	icon_speaker = new (ELeave) CEikImage();
	icon_vibra = new (ELeave) CEikImage();
	
	if (iPresence)
	{
		TBool out_of_date = IsOutOfDate(iPresence->SendTimeStamp());
		
		temp.Zero();
		if (iPresence->LocInfo().iFlags & TLocInfo::EPrevious)
		{
			temp.Format(p_l_template, &(*(iPresence->LocInfo().iPrevious)), &(TimeSinceStamp(iPresence->LocInfo().iPUpdated)));
			prev_loc->SetTextL(temp);
		}
		else
		{
			prev_loc->SetTextL(_L("?"));
		}
		
		temp.Zero();
		if (iPresence->LocInfo().iFlags & TLocInfo::ECurrent)
		{
			temp.Format(c_l_template, &(*(iPresence->LocInfo().iCurrent)), &(TimeSinceStamp(iPresence->LocInfo().iCUpdated)) );
			curr_loc->SetTextL(temp);
		}
		else
		{
			curr_loc->SetTextL(_L("?"));
		}
		
		curr_profile_name->SetTextL(iPresence->ProfileInfo().iProfileName);
		
		temp.Zero();
			
		if ( iPresence->ProfileInfo().iRingingType == CPresenceData::ERingingTypeSilent )
		{
			temp.Append(sp);
			temp.Append(_L(" "));
			temp.Append(off);
			curr_profile_speaker->SetTextL(temp);

			CleanupStack::PushL(icon_speaker);
			TInt icon = 0;
			if (out_of_date)
			{
				icon = GetIconIndex(EMbmContextbookSpeaker_off_grey);
			}
			else
			{
				icon = GetIconIndex(EMbmContextbookSpeaker_off);
			}
			icon_speaker->CreatePictureFromFileL(GetIconMbm(icon), GetIconBitmap(icon), GetIconMask(icon));
			CleanupStack::Pop();
		}
		else
		{
			temp.Append(sp);
			temp.Append(_L(" "));
			//temp.Append(on);
			//temp.Append( _L(" ("));
			temp.AppendFormat(sp_vol, iPresence->ProfileInfo().iRingingVolume);
			//temp.Append(_L(")"));
			curr_profile_speaker->SetTextL(temp);
						
			CleanupStack::PushL(icon_speaker);
			TInt icon = 0;
			if (out_of_date)
			{
				icon = GetIconIndex(EMbmContextbookSpeaker_on_grey);
			}
			else
			{
				icon = GetIconIndex(EMbmContextbookSpeaker_on);
			}
			icon_speaker->CreatePictureFromFileL(GetIconMbm(icon), GetIconBitmap(icon), GetIconMask(icon));

            CleanupStack::Pop();
		}
				
		temp.Zero();
		temp.Append(vib);
		temp.Append(_L(" "));
		if ( iPresence->ProfileInfo().iVibra )
		{
			temp.Append(on);
			CleanupStack::PushL(icon_vibra);
			TInt icon = 0;
			if (out_of_date)
			{
				icon = GetIconIndex(EMbmContextbookVibrator_on_grey);
			}
			else
			{
				icon = GetIconIndex(EMbmContextbookVibrator_on);
			}
			icon_vibra->CreatePictureFromFileL(GetIconMbm(icon), GetIconBitmap(icon), GetIconMask(icon));
			CleanupStack::Pop();
		}
		else
		{
			temp.Append(off);
			CleanupStack::PushL(icon_vibra);
			TInt icon = 0;
			if (out_of_date)
			{
				icon = GetIconIndex(EMbmContextbookVibrator_off_grey);
			}
			else
			{
				icon = GetIconIndex(EMbmContextbookVibrator_off);
			}
			icon_vibra->CreatePictureFromFileL(GetIconMbm(icon), GetIconBitmap(icon), GetIconMask(icon));
			CleanupStack::Pop();
		}
		curr_profile_vib->SetTextL(temp);
		
		temp.Zero();
		if (out_of_date)
		{
			temp.Format(o_o_d, &(TimeSinceStamp(iPresence->SendTimeStamp(), 10)));
			user_active->SetTextL( temp );
			user_active->OverrideColorL(EColorLabelTextEmphasis, KRgbRed);
		}
		else
		{
			if (iPresence->ActivityInfo().iMode == TActivityInfo::EActive )
			{
				user_active->SetTextL(u_a_template);
			}
			else
			{
				temp.Format(u_i_template, &(TimeSinceStamp(iPresence->ActivityInfo().iUpdated, 2)));
				user_active->SetTextL(temp);
			}
		}
	}
	else
	{
		//prev_loc_title->SetTextL(_L(" "));
		prev_loc->SetTextL(_L("?"));
		//curr_loc_title->SetTextL(_L(" "));
		curr_loc->SetTextL(_L("?"));
		//curr_profile_title->SetTextL(_L(" "));
		curr_profile_name->SetTextL(_L("?"));
		curr_profile_speaker->SetTextL(_L("?"));
		curr_profile_vib->SetTextL(_L("?"));
		user_active->SetTextL(no_info);
		user_active->OverrideColorL(EColorLabelTextEmphasis, KRgbRed);

		CleanupStack::PushL(icon_vibra);
		icon_vibra->CreatePictureFromFileL(GetIconMbm(0), GetIconBitmap(0), GetIconMask(0));
		icon_vibra->MakeVisible(EFalse);
		CleanupStack::Pop();

		CleanupStack::PushL(icon_speaker);
		icon_speaker->CreatePictureFromFileL(GetIconMbm(0), GetIconBitmap(0), GetIconMask(0));
		icon_speaker->MakeVisible(EFalse);
		CleanupStack::Pop();
	}
	SetSizeOfComponents();

	RDebug::Print(*(prev_loc_title->Text()));
	RDebug::Print(*(prev_loc->Text()));
	RDebug::Print(*(curr_loc_title->Text()));
	RDebug::Print(*(curr_loc->Text()));
	RDebug::Print(*(curr_profile_title->Text()));
	RDebug::Print(*(curr_profile_name->Text()));
	RDebug::Print(*(curr_profile_speaker->Text()));
	RDebug::Print(*(curr_profile_vib->Text()));
	RDebug::Print(*(user_active->Text()));


	SetRect(aRect);
	ActivateL();	
}

void CPresenceDetailContainer::SetSizeOfComponents()
{
	//7650 screen size = W:176 H:208 
	
	title->SetExtent(TPoint(2, 2), TSize(176,15));

	prev_loc_title->SetExtent(TPoint(0, 20), TSize(88,30));
	prev_loc->SetExtent(TPoint(83,20), TSize(93,30));

	curr_loc_title->SetExtent(TPoint(0,50), TSize(88,30));
	curr_loc->SetExtent(TPoint(83, 50), TSize(93,30));

	curr_profile_title->SetExtent(TPoint(0, 80), TSize(88,49));
	curr_profile_name->SetExtent(TPoint(83, 80), TSize(93,15));

	//icon_speaker->SetExtent(TPoint(65, 94), TSize(16,16));
	//curr_profile_speaker->SetExtent(TPoint(88, 95), TSize(88,17));
	//icon_vibra->SetExtent(TPoint(65, 111), TSize(16,16));
	//curr_profile_vib->SetExtent(TPoint(88, 112), TSize(88,17));

	icon_speaker->SetExtent(TPoint(60, 94), TSize(16,16));
	curr_profile_speaker->SetExtent(TPoint(83, 95), TSize(103,17));
	curr_profile_speaker_volume->SetExtent(TPoint(0, 0), TSize(1,1));
	icon_vibra->SetExtent(TPoint(60, 111), TSize(16,16));
	curr_profile_vib->SetExtent(TPoint(83, 112), TSize(103,17));

	user_active->SetExtent(TPoint(2, 129), TSize(176,17));
}

void CPresenceDetailContainer::SizeChanged()
{
	SetSizeOfComponents();
}

TInt CPresenceDetailContainer::CountComponentControls() const
{
	return 13;
}

CCoeControl* CPresenceDetailContainer::ComponentControl(TInt aIndex) const
{

	switch (aIndex)
	{
		case 0:  return title;
		case 1:  return prev_loc_title;
		case 2:  return prev_loc;
		case 3:  return curr_loc_title;
		case 4:  return curr_loc;
		case 5:  return curr_profile_title;
		case 6:  return curr_profile_name;
		case 7:  return curr_profile_speaker;
		case 8:  return curr_profile_speaker_volume;
		case 9:  return curr_profile_vib;
		case 10:  return user_active; 
		case 11: return icon_speaker;
		case 12: return icon_vibra;
		default: return 0;
	}
}

void CPresenceDetailContainer::Draw(const TRect& aRect) const
{
	CWindowGc& gc = SystemGc();
	// TODO: Add your drawing code here
	// example code...
	gc.SetPenStyle(CGraphicsContext::ENullPen);
	gc.SetBrushColor(KRgbWhite);
	gc.SetBrushStyle(CGraphicsContext::ESolidBrush);
	gc.DrawRect(aRect);
}

CPresenceDetailViewImpl::CPresenceDetailViewImpl()
{
}

void CPresenceDetailViewImpl::ConstructL()
{
#ifndef __WINS__
	TFileName resfile=_L("c:\\System\\data\\contextcommon.rsc");
#else
	TFileName resfile=_L("z:\\System\\data\\contextcommon.rsc");
#endif
	BaflUtils::NearestLanguageFile(iEikonEnv->FsSession(), resfile); //for localization
	TRAPD(err, iResource=iEikonEnv->AddResourceFileL(resfile));
	User::LeaveIfError(err);

	BaseConstructL( R_PRESENCEDETAIL_VIEW );
}

TUid CPresenceDetailViewImpl::Id() const
{
	return KPresenceDetailView;
}

void CPresenceDetailViewImpl::HandleCommandL(TInt /*aCommand*/)
{
	ActivateViewL(iPrevView);
}

void CPresenceDetailViewImpl::DoActivateL(const TVwsViewId& aPrevViewId,
	TUid /*aCustomMessageId*/,
	const TDesC8& /*aCustomMessage*/)
{
	iPrevView=aPrevViewId;
	if (!iContainer) {
		iContainer=new (ELeave) CPresenceDetailContainer(iName, iPresence);
		iContainer->SetMopParent(this);
		iContainer->ConstructL(ClientRect());
		AppUi()->AddToStackL( *this, iContainer );
        } 
}

void CPresenceDetailViewImpl::DoDeactivate()
{
	if ( iContainer )
        {
		AppUi()->RemoveFromViewStack( *this, iContainer );
        }
	
	delete iContainer;
	iContainer = 0;
}

CPresenceDetailViewImpl::~CPresenceDetailViewImpl()
{
	if (iResource) iEikonEnv->DeleteResourceFile(iResource);
	delete iContainer;
	
}


void CPresenceDetailViewImpl::SetData(const TDesC& Name, const MPresenceData* PresenceData)
{
	iName=Name;
	iPresence=PresenceData;
}

