/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


//MessageHolder.h
#ifndef __MESSAGEHOLDER_H_INCLUDED__
#define __MESSAGEHOLDER_H_INCLUDED__

#include <e32base.h>
#include <badesca.h>

struct TMessage_ref
{
	HBufC* contact;
	HBufC* subject;
	HBufC* message;
	TMessage_ref(HBufC* i_contact, HBufC* i_subject, HBufC* i_message);
};

struct TMessage
{
	HBufC* contact;
	HBufC* subject;
	HBufC* message;
	TMessage();
	TMessage(const TMessage_ref& f);
	~TMessage();
	TMessage& operator=(const TMessage_ref& rhs);
	TMessage(TMessage& f);
	TMessage& operator=(TMessage& rhs);
	operator TMessage_ref();
};

class CMessageHolder : public CBase
{
public: 	
	static CMessageHolder * NewL();
	virtual ~CMessageHolder() { }

	virtual TMessage GetMessage() = 0; // caller gets ownership
	virtual void AppendMessageL(const TDesC& contact, const TDesC& subject, const TDesC& message) = 0;
	virtual void AppendMessageL(TMessage msg) = 0; // takes ownership
};

#endif
