/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


//PresenceInfo.h
#ifndef __CPRESENCEINFO__
#define __CPRESENCEINFO__

#include <e32base.h>
#include <badesca.h>


enum
{
	KMaxLengthPresenceInfo = 50,
	KMaxContacts = 50
};

typedef struct 
{
	TInt  newInfo;
	TPtrC contact;
	TPtrC info;
	TTime send_timestamp;
}
TPresenceInfo;

class CPresenceInfo : public CBase
{

public: 
	
	static CPresenceInfo * NewL();
	static CPresenceInfo * NewLC();
	~CPresenceInfo();
	void ConstructL();

	TPtrC GetPresenceInfoAsDes();
	void Update(const TDesC & contact, const TDesC& presence, const TTime & timestamp);
	TPresenceInfo GetNewPresenceInfo();
	void SetAllAsNew();
	void SetAsNew(const TDesC & contact);
private:

	RArray<TInt> * iFlags;
	RArray<TTime> * iSend_timestamps;
	CDesCArray * iAllContactsArray;
	CDesCArray * iAllContactsPresenceInfoArray;

};



	



#endif
