/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


/* Copyright (c) 2001, Nokia. All rights reserved */

#ifndef __SOCKETSENGINE_H__
#define __SOCKETSENGINE_H__

#include "ver.h"

#include <in_sock.h>

#include <timeout.h>
#include "EngineNotifier.h"
#include "Sockets.hrh"
#include <xmlbuf.h>

#include <expat.h>
#include <list.h>

#include <connectioninit.h>

_LIT(KDefaultJabberRessource, "Context");
_LIT(KDefaultServerName, "jabber.org");

class CSocketsReader;
class CSocketsWriter;


//class MUINotifier;

/*! 
  @class CSocketsEngine
  
  @discussion This class is the main engine part of the sockets application.
  It establishes a TCP connection using its server name and port number (performing a DNS lookup
  operation first, if appropriate).
  It creates instances of separate active objects to perform reading from, and writing to, the socket.
  */
class CSocketsEngine : public CActive, public MTimeOut, public MEngineNotifier,public MSocketObserver
    {
public: // new methods
/*!
  @function NewL
   
  @discussion Create a CSocketsEngine object
  @param aConsole console to use for ui output
  @result a pointer to the created instance of CSocketsEngine
  */
	static CSocketsEngine* NewL(MContextServerNotifier& aNotifier);

/*!
  @function NewLC
   
  @discussion Create a CSocketsEngine object
  @param aConsole console to use for ui output
  @result a pointer to the created instance of CSocketsEngine
  */
	static CSocketsEngine* NewLC(MContextServerNotifier& aNotifier);

/*!
  @function ~CSocketsEngine
  
  @discussion Destroy the object and release all memory objects
  */
	~CSocketsEngine();

/*!
  @function ConnectL

  @discussion Initiate connection of socket, using iServerName and iPort
  */
    void ConnectL();
    void ConnectL(TDesC16 &u, TDesC16 &p, TDesC16 &s, TUint32 iAccessPoint);

/*!
  @function Disconnect

  @discussion Disconnect socket
  */
    void Disconnect(TBool closeConnection);

    void DisconnectSocket();

    /*!
  @function WriteL

  @discussion Write data to socket
  @param aData data to be written
  */
	void WriteL(const TDesC16& aData);

	void SendXMLStreamHeaderL();

	void SendDisconnectionL();
	void SendIdentificationL();
	void SendPresenceInfoL(TDesC &presenceInfo);

/*!
  @function Read

  @discussion Initiate read of data from socket
  */
	void Read();

/*!
  @function SetServerName

  @discussion Set name of server to connect to
  @param aName new server name
  */
    void SetServerName(const TDesC& aName);

/*!
  @function ServerName

  @discussion Get server name
  @result name of server
  */
    const TDesC& ServerName() const;

/*!
  @function SetPort

  @discussion Set port number to connect to
  @param aPort new port number
  */
    void SetPort(TInt aPort);


/*!
  @function Port

  @discussion Get port number
  @result port number
  */
    TInt Port() const;


/*!
  @function Connected

  @discussion Is socket fully connected?
  @result true if socket is connected
  */
    TBool Connected() const;

 


//-----------------------------------------------------------------------------
//void start(void *data, const XML_Char *el, const XML_Char **attr);

	static void /*__cdecl*/ startElement (void *userData, const XML_Char *el, const XML_Char **atts);
	static void /*__cdecl*/ endElement (void *userData, const XML_Char *name);
	static void /*__cdecl*/ charData (void *userData, const XML_Char *s, int len);

	void /*__cdecl*/ startElement (const XML_Char *el, const XML_Char **atts);
	void /*__cdecl*/ endElement (const XML_Char *name);
	void /*__cdecl*/ charData (const XML_Char *s, int len);

//------------------------------------------------------------------------------

private: // from MTimeOut
/*!
  @function expired

  @discussion The function to be called when a timeout occurs
  */
	void expired() { } // NOT USED
	IMPORT_C void expired(CBase* Source);

public: // from MEngineNotifier
/*!
  @function ReportError

  @discussion Report a communication error
  @param aErrorType error type
  @param aErrorCode associated error code
  */
	void ReportError(MEngineNotifier::TErrorType aErrorType, TInt aErrorCode);

/*!
  @function ResponseReceived

  @discussion Data has been received on the socket and read into a buffer
  @param aBuffer the data buffer
  */
	void ResponseReceived(const TDesC8& aBuffer);


	
	MContextServerNotifier& iContextNotifier;

public: //from MsocketObserver

	void success(CBase* source);

	void error(CBase* source, TInt code, const TDesC& reason);
	void info(CBase* source, const TDesC& msg);


protected: // from CActive
/*!
  @function DoCancel
   
  @discussion cancel any outstanding operation
  */
	void DoCancel();

/*!
  @function RunL
   
  @discussion called when operation complete
  */
    void RunL();
    TInt CheckedRunError(TInt aError);

private: // New methods
/*!
  @function CSocketsEngine
  
  @discussion Perform the first phase of two phase construction 
  @param aConsole the console to use for ui output
  */
	CSocketsEngine(MContextServerNotifier& aNotifier);

/*!
  @function ConstructL
  
  @discussion Perform the second phase construction of a CSocketsEngine 
  */
    void ConstructL();

/*!
  @function ConnectL
   
  @discussion initiate a connect operation on a socket
  @param aAddr the ip address to connect to
  */
	void ConnectL(TUint32 aAddr);

/*!
  @enum TSocketsEngineState

  @discussion Tracks the state of this object through the connection process
  @value ENotConnected The initial (idle) state
  @value EConnecting A connect request is pending with the socket server
  @value EConnected A connection has been established
  @value ELookingUp A DNS lookup request is pending with the socket server
  */
	enum TSocketsEngineState 
	    {
		ENotConnected,
		EConnecting,
		EConnected,
		ELookingUp,
		EDisconnecting,
		EWaitingForRetry
	    };


	enum TParseState
	{
		EStackUndefined,
		EStackIgnoreElement,
		EStackPresenceInfo,
		EStackMessage,
		EStackSubject,
		EStackBody,
		EStackOfflinePresenceInfo,
		EStackSession,
		EStackConnected,
		EStackIdentFailure,
		EStackStatus,
		EStackStreamError,
		EStackError

	};

/*!
  @function ChangeStatus
   
  @discussion handle a change in this object's status
  @param aNewStatus new status
  */
    void ChangeStatus(TSocketsEngineState aNewStatus);
	void DoSendPresenceInfoL();
      

private: // Member variables

    /*! @const The maximum time allowed for a lookup or connect requests to complete */
    static const TInt KTimeOut;

    /*! @const The initial port number displayed to the user */
    static const TInt KDefaultPortNumber;
    static const TInt KMaxIdentificationRetry;
    static const TInt KTimeBeforeRetry;

    /*! @var this object's current status */
	TSocketsEngineState         iEngineStatus;

    /*! @var the actual socket */
	RSocket                     iSocket;

    /*! @var active object to control reads from the socket */
	CSocketsReader*             iSocketsReader;

    /*! @var active object to control writes to the socket */
	CSocketsWriter*             iSocketsWriter;

      /*! @var DNS name resolver */
	RHostResolver               iResolver;

    /*! @var The result from the name resolver */
	TNameEntry                  iNameEntry;

    /*! @var The anme record found by the resolver */
	TNameRecord                 iNameRecord;

    /*! @var timer active object */
	CTimeOut*		iTimer;
	CTimeOut*		iSendTimer;
	CTimeOut*		iIdentTimer;

    /*! @var The address to be used in the connection */
	TInetAddr                   iAddress;

    /*! @var port number to connect to */
    TInt                        iPort;

    /*! @var server name to connect to */
    TBuf16<KMaxServerNameLength>  iServerName;
   
    XML_Parser		iParser;
  
    TBuf16<200> iUsername;  // size defined by Jabber specs
    TBuf16<200> iFullNick; // user@server/Resource
    TBuf16<200> iPassword;  // size defined by Jabber specs
    TBuf16<100>  iRessource; 

    HBufC16*	iUserPresenceInfo;
    
    TBuf16<100> iJabberSessionId;
    
    CList<TInt> * iStack;

    HBufC16 * iFrom;
    HBufC16 * iPresenceInfo;
    HBufC16 * iMessage;
    HBufC16 * iSubject;

    CXmlBuf16*	iXmlBuf;

    TBuf<20> iErrorCode;
    HBufC16 * iErrorValue;
    
    TInt iIdAttempt;
    TInt iConnectionRetry;
    TInt iTimeBeforeRetry;
	TTimeIntervalSeconds iPresenceInterval;
	TInt iFreshnessInterval;
	TTime iLastUpdateSent;

    CConnectionOpener *	iConnectionOpener;
    TUint32		iAccessPoint;
    RSocketServ		iSocketServ;

	TBool iSocketOpen;
	TBool iResolverOpen;
    


#ifdef __S60V2__
    RConnection		iConnection;
#endif

  /*! @var the socket server */
//	RSocketServ&                iSocketServ;
//#ifdef __S60V2__
//	RConnection&		    iConnection;
//#endif

};

#endif // __SOCKETSENGINE_H__

