/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


/* Copyright (c) 2001, Nokia. All rights reserved */

#ifndef __SOCKETSREADER_H__
#define __SOCKETSREADER_H__

#include <in_sock.h>
#include <timeout.h>

class MEngineNotifier;

/*! 
  @class CSocketsReader
  
  @discussion This class handles reading data from the socket.
  In this implementation, any data read is simply displayed as text on the console.
  */
class CSocketsReader : public CActive , public MTimeOut
    {
public:
/*!
  @function NewL
   
  @discussion Create a CSocketsReader object
  @param aEngineNotifier An observer for status reporting
  @param aSocket socket to read from
  @result a pointer to the created instance of CSocketsReader
  */
	static CSocketsReader* NewL(MEngineNotifier& aEngineNotifier, RSocket& aSocket);

/*!
  @function NewLC
   
  @discussion Create a CSocketsReader object
  @param aEngineNotifier An observer for status reporting
  @param aSocket socket to read from
  @result a pointer to the created instance of CSocketsReader
  */
    static CSocketsReader* NewLC(MEngineNotifier& aEngineNotifier, RSocket& aSocket);

/*!
  @function ~CSocketsReader
  
  @discussion Destroy the object and release all memory objects
  */
	~CSocketsReader();

/*!
  @function Start

  @discussion Initiate a read from socket
  */
	void Start();

	void SetIssueRead(TBool issue);

protected: // from CActive
/*!
  @function DoCancel
   
  @discussion cancel any outstanding operation
  */
	void DoCancel();

/*!
  @function RunL
   
  @discussion called when operation complete
  */
	TInt CheckedRunError(TInt aError);
	void RunL();	

private:
/*!
  @function CSocketsReader
  
  @discussion Perform the first phase of two phase construction 
  @param aEngineNotifier An observer for status reporting
  @param aSocket socket to read from
  */
	CSocketsReader(MEngineNotifier& aEngineNotifier, RSocket& aSocket);

/*!
  @function ConstructL
  
  @discussion Perform the second phase construction of a CSocketsReader 
  */
	void ConstructL();

/*!
  @function IssueRead

  @discussion Initiate a read from socket
  */
	void IssueRead();

private: // from MTimeOut
/*!
  @function expired

  @discussion The function to be called when a timeout occurs
  */
	void expired(CBase*);


private: // Member variables

    /*! @const The size of the read buffer in bytes */
    enum {KReadBufferSize = 150};

    /*! @var socket to read data from */
    RSocket&                iSocket;

	CTimeOut * iReadTimer;

    /*! @var An observer for status reporting */
	MEngineNotifier&        iEngineNotifier;

    /*! @var buffer for receiving data */
	TBuf8<KReadBufferSize>  iBuffer;

    /*! @var dummy - length of data read is written here */
    TSockXfrLength          iDummyLength;

	TBool issueRead;
	static const TInt KReadTimeOut;

    };

#endif // __SOCKETSREADER_H__

