/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#include "PresenceInfo.h"
#include "ContextServer.h"

#include "SocketsEngine.h"

#include <flogger.h>

CPresenceInfo * CPresenceInfo::NewL()
{
	CPresenceInfo * presenceInfo = CPresenceInfo::NewLC();
    	CleanupStack::Pop(presenceInfo);
    	return presenceInfo;
}

CPresenceInfo * CPresenceInfo::NewLC()
{
	CPresenceInfo* presenceInfo = new (ELeave) CPresenceInfo();
    	CleanupStack::PushL(presenceInfo);
    	presenceInfo->ConstructL();
    	return presenceInfo;
}

CPresenceInfo::~CPresenceInfo()
{
	delete iAllContactsArray;
	delete iAllContactsPresenceInfoArray;
	if (iFlags) iFlags->Close();
	if (iSend_timestamps) iSend_timestamps->Close();
	delete iSend_timestamps;
	delete iFlags;

}

void CPresenceInfo::ConstructL()
{
	iAllContactsArray             = new (ELeave) CDesCArrayFlat(KMaxContacts);
	iAllContactsPresenceInfoArray = new (ELeave) CDesCArrayFlat(KMaxContacts);
	iFlags = new (ELeave) RArray<TInt>;
	iSend_timestamps = new (ELeave) RArray<TTime>;
}

void CPresenceInfo::Update(const TDesC & contact, const TDesC& presence, const TTime & time)
{
	TInt pos;

	if (iAllContactsArray->Find(contact ,pos) == 0)
	// found
	{
		iAllContactsPresenceInfoArray->Delete(pos);
		iAllContactsArray->Delete(pos);
		iFlags->Remove(pos);
		iSend_timestamps->Remove(pos);

		iAllContactsArray->Compress();
		iAllContactsPresenceInfoArray->Compress();
		iFlags->Compress();
		iSend_timestamps->Compress();
	}
		
	iAllContactsPresenceInfoArray->AppendL(presence);
	iAllContactsArray->AppendL(contact);
	iFlags->Append(1);
	iSend_timestamps->Append(time);
}

TPresenceInfo CPresenceInfo::GetNewPresenceInfo()
{
	TInt pos = iFlags->Find(1);

	TPresenceInfo info;
	info.newInfo = 0;

	if ( pos != KErrNotFound)
	{
		(*iFlags)[pos] = 0;
		info.contact.Set( (*iAllContactsArray)[pos] );
		info.info.Set( (*iAllContactsPresenceInfoArray)[pos] );
		info.send_timestamp = (*iSend_timestamps)[pos];
		info.newInfo = 1;
	}
	return info;
}

void CPresenceInfo::SetAllAsNew()
{
	for (int i=0;i<iFlags->Count();i++)
	{
		(*iFlags)[i] = 1;
	}
}

void CPresenceInfo::SetAsNew(const TDesC & contact)
{
	TInt pos;
	if (iAllContactsArray->Find(contact ,pos) == 0)
	{
		(*iFlags)[pos] = 1;
	}
}


TPtrC CPresenceInfo::GetPresenceInfoAsDes()
{
	TBuf<800> info ;

	for (int i = 0;i<iAllContactsArray->Count();i++)
	{
		info.Append((*iAllContactsArray)[i]);
		info.Append(_L(":"));
		info.Append((*iAllContactsPresenceInfoArray)[i]);
		info.Append(_L(";"));
	}
	return TPtrC(info);
}

	