/*
* ============================================================================
*  Name     : CTaskListAppUi from TaskListAppUi.h
*  Part of  : TaskList
*  Created  : 13.4.2004 by 
*  Description:
*     Declares UI class for application.
*  Version  :
*  Copyright: 
* ============================================================================
*/

#ifndef TASKLISTAPPUI_H
#define TASKLISTAPPUI_H

// INCLUDES
#include <eikapp.h>
#include <eikdoc.h>
#include <e32std.h>
#include <coeccntx.h>
#include <aknappui.h>
#include <eiklbo.h>

// FORWARD DECLARATIONS
class CTaskListContainer;


// CONSTANTS
//const ?type ?constant_var = ?constant;


// CLASS DECLARATION

/**
* Application UI class.
* Provides support for the following features:
* - EIKON control architecture
* 
*/
class CTaskListAppUi : public CAknAppUi, public MEikListBoxObserver
    {
    public: // // Constructors and destructor

        /**
        * EPOC default constructor.
        */      
        void ConstructL();

        /**
        * Destructor.
        */      
        ~CTaskListAppUi();
        
    public: // New functions

    public: // Functions from base classes

    private:
        // From MEikMenuObserver
        void DynInitMenuPaneL(TInt aResourceId,CEikMenuPane* aMenuPane);

	void HandleListBoxEventL(CEikListBox* aListBox,TListBoxEvent aEventType);

    private:
        /**
        * From CEikAppUi, takes care of command handling.
        * @param aCommand command to be handled
        */
        void HandleCommandL(TInt aCommand);

        /**
        * From CEikAppUi, handles key events.
        * @param aKeyEvent Event to handled.
        * @param aType Type of the key event. 
        * @return Response code (EKeyWasConsumed, EKeyWasNotConsumed). 
        */
        virtual TKeyResponse HandleKeyEventL(
            const TKeyEvent& aKeyEvent,TEventCode aType);


	void GetThreads();
	void KillCurrent();
    private: //Data
        CTaskListContainer* iAppContainer; 
	CDesC16ArrayFlat*   iThreadNames;
	CArrayFixFlat<TThreadId>* iThreadIds;
    };

#endif

// End of File
