/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#include <apmrec.h>
#include <apmstd.h>
#include "cl_autostart.h"
#include <flogger.h>

const TUid KUidemAclAutostart={0x09A770B5};

CclAutostart::CclAutostart()
:CApaDataRecognizerType(KUidemAclAutostart, CApaDataRecognizerType::ENormal)
{
	iCountDataTypes = 1;
}

TUint CclAutostart::PreferredBufSize()
{
	// no buffer recognition yet
	return 0;
}

TDataType CclAutostart::SupportedDataTypeL(TInt /*aIndex*/) const
{
	return TDataType();
}

void CclAutostart::DoRecognizeL(const TDesC& /*aName*/, const TDesC8&
			      /*aBuffer*/)
{
	// this function is never called
}

void CclAutostart::StartThread()
{
	TInt res = KErrNone;

	RFileLogger iLog;
	iLog.Connect();
	iLog.CreateLog(_L("Autostart"),_L("Autostart"),EFileLoggingModeAppend);
	iLog.Write(_L("Starting thread."));
	iLog.CloseLog();
	iLog.Close();
	
	//create a new thread for starting our application
	RThread * startAppThread;
	startAppThread = new RThread();
	
	User::LeaveIfError( res = startAppThread->Create(
		_L("Autostart starter"),
		CclAutostart::StartAppThreadFunction,
		KDefaultStackSize,
		KMinHeapSize,
		KMinHeapSize,
		NULL,
		EOwnerThread) );
	
	startAppThread->SetPriority(EPriorityNormal/*EPriorityLess*/);
	
	startAppThread->Resume();
	
	startAppThread->Close();
}


TInt CclAutostart::StartAppThreadFunction(TAny* /*aParam*/)
{
	
	//wait 5 seconds...
	RTimer timer; // The asynchronous timer and ...
	TRequestStatus timerStatus; // ... its associated request status
	timer.CreateLocal(); // Always created for this thread.
	// get current time (microseconds since 0AD nominal Gregorian)
	TTime time;
	time.HomeTime();
	// add ten seconds to the time
	TTimeIntervalSeconds timeIntervalSeconds(45);
	time += timeIntervalSeconds;
	// issue and wait
	timer.At(timerStatus,time);
	User::WaitForRequest(timerStatus);
	
	
	// create a TRAP cleanup
	CTrapCleanup * cleanup = CTrapCleanup::New();
	TInt err;
	if( cleanup == NULL )
	{
		err = KErrNoMemory;
	}
	else
	{
		TRAP( err, StartAppThreadFunctionL() );
	}
	delete cleanup;
	
	
	if (err!=KErrNone) 
		User::Panic(_L("autostart"), err);
	return err;
}

void CclAutostart::StartAppThreadFunctionL()
{
#ifdef __WINS__
	const TUid starter_uid= { 0x05CCC0B0 };
	RApaLsSession ls;
	User::LeaveIfError(ls.Connect());
	CleanupClosePushL(ls);
	_LIT(filen, ""); // dummy
	TThreadId dummy;
	User::LeaveIfError( ls.StartDocument(filen, starter_uid, dummy) );
	CleanupStack::PopAndDestroy();
#else
	TFileName fnAppPath = _L("\\system\\apps\\starter\\starter.exe");
	RProcess server;

	CleanupClosePushL(server);
	User::LeaveIfError(server.Create(fnAppPath, _L("")));
	server.Resume();

	CleanupStack::PopAndDestroy();
#endif

}

EXPORT_C CApaDataRecognizerType* CreateRecognizer()
{
	CApaDataRecognizerType* thing = new CclAutostart();
	
	//start thread for our application
	CclAutostart::StartThread();
	return thing;
}

// DLL entry point
GLDEF_C TInt E32Dll(TDllReason /*aReason*/)
{
	return KErrNone;
}
