/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


/*
* ============================================================================
*  Name     : CContext_logContainer from Context_logContainer.h
*  Part of  : context_log
*  Created  : 13.2.2003 by 
*  Description:
*     Declares container control for application.
*  Version  :
*  Copyright: 
* ============================================================================
*/

#ifndef CONTEXT_LOGCONTAINER_H
#define CONTEXT_LOGCONTAINER_H

// INCLUDES
#include <coecntrl.h>

#include "i_logger.h"
#include "hash.h"
#include "log_base_impl.h"
#include "app_context.h"
#include "locationing.h"
#include "cellmap.h"
#include "symbian_tree.h"
   
// FORWARD DECLARATIONS
class CEikLabel;        // for example labels

// CLASS DECLARATION

/**
*  CContext_logContainer  container control class.
*  
*/
class CContext_logContainer : public CCoeControl, MCoeControlObserver, public Mlogger, public Mlog_base_impl, public MNaming
    {
    public: // Constructors and destructor
        
        /**
        * EPOC default constructor.
        * @param aRect Frame rectangle for container.
        */
	CContext_logContainer(MApp_context& Context, CCellMap& CellMap);
        void ConstructL(const TRect& aRect);

        /**
        * Destructor.
        */
        ~CContext_logContainer();

    public: // New functions
	void add_cellid_name(const TDesC& cellid, const TDesC& name);
	bool is_named(TInt id);
	void now_at_location(const TDesC& cellid, TInt id, bool is_base, bool loc_changed, TTime time);
	void set_status(const TDesC& status);
	void set_error(const TDesC& err);

    public: // Functions from base classes
	virtual void register_source(const TDesC& name, const TDesC& initial_value, const TTime& time);
	virtual void new_value(log_priority priority, const TDesC& name, const TDesC& value, const TTime& time);
	virtual void unregister_source(const TDesC& name, const TTime& time);
	virtual const TDesC& name() const;

    private: // Functions from base classes

       /**
        * From CoeControl,SizeChanged.
        */
        void SizeChanged();

       /**
        * From CoeControl,CountComponentControls.
        */
        TInt CountComponentControls() const;

       /**
        * From CCoeControl,ComponentControl.
        */
        CCoeControl* ComponentControl(TInt aIndex) const;

       /**
        * From CCoeControl,Draw.
        */
        void Draw(const TRect& aRect) const;

       /**
        * From ?base_class ?member_description
        */
        // event handling section
        // e.g Listbox events
        void HandleControlEventL(CCoeControl* aControl,TCoeEvent aEventType);

	const TDesC& get_value();
    private: //data
        
        CEikLabel* iLabel;          // example label
	CEikLabel* status_label;
	CEikLabel* err_label;
	hash log_labels; hash log_values;
	CArrayFixFlat<CEikLabel*>* label_store;
	CArrayFixFlat<CEikLabel*>* value_store;

	CCellMap&	iCellMap;
	CGenericIntMap* cellid_names;

	TBuf<50> current_base;
	TInt	current_cell;
	TBuf<100> current_name;

	TTime		iBaseStamp, iPrevBaseStamp;
	bool		iLastAtBase, iFirstLoc;
	TBuf<100>	iLastBase;
	TBuf<100>	iPrevBase;
    };

#endif

// End of File
