/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


/*
* ============================================================================
*  Name     : CSettingsView from SettingsView.h
*  Part of  : Settings
*  Created  : 13.1.2004 by 
*  Description:
*     Declares view for application.
*  Version  :
*  Copyright: 
* ============================================================================
*/

#ifndef SETTINGSVIEW_H
#define SETTINGSVIEW_H

// INCLUDES
#include <aknview.h>

#ifndef NULL
#define NULL 0
#endif

#include <aknsettingitemlist.h>
#include "app_context.h"

#include "cl_settings.h"

// CONSTANTS
// UID of view
const TUid KSettingsViewId = {2};

/**
*  CSettingsView view class.
* 
*/

#ifndef NULL
#define NULL 0
#endif

class CCLSettingList: public CAknSettingItemList 
    {
    public:
        CAknSettingItem* CreateSettingItemL( TInt identifier );
	void SetListData();
	void UpdateSettings();
	TAny*		iData[SETTINGS_COUNT];
	~CCLSettingList();
    private:
	CAknSettingItem	*iItems[SETTINGS_COUNT];
    };

class CSettingsView : public CAknView, public MContextBase
    {
    public: // Constructors and destructor
	static CSettingsView* NewL(MApp_context& Context);

        /**
        * Destructor.
        */
        ~CSettingsView();

    public: // Functions from base classes
        
        /**
        * From ?base_class ?member_description
        */
        TUid Id() const;

        /**
        * From ?base_class ?member_description
        */
        void HandleCommandL(TInt aCommand);

        /**
        * From ?base_class ?member_description
        */
        void HandleClientRectChange();

    private:
	CSettingsView(MApp_context& Context);
        void ConstructL();

        /**
        * From AknView, ?member_description
        */
        void DoActivateL(const TVwsViewId& aPrevViewId,TUid aCustomMessageId,
            const TDesC8& aCustomMessage);

        /**
        * From AknView, ?member_description
        */
        void DoDeactivate();

    private: // Data
        CCLSettingList* iListBox;
    };

#endif

// End of File
