/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#if !defined(Ccall_listener_H_INCLUDED)

#define Ccall_listener_H_INCLUDED 1

#include <etel.h>
#include <etelagsm.h>
#include <cpbkcontactengine.h> 
#include <badesca.h>

#include "i_logger.h"
#include "status_notif.h"
#include "app_context.h"
#include "ftp.h"

class CSpecialGroups {
public:
	static CSpecialGroups* NewL(MApp_context& Context);
	virtual void read_contact_groups() = 0;
	virtual void store_contact(const TDesC& number) = 0;
	virtual bool is_special_contact() = 0;
	virtual ~CSpecialGroups() { }
	virtual void AddGroupL(const TDesC& GroupName) = 0;
	virtual CContactIdArray* current_contact_ids() = 0;
};

class Ccall_listener: public CCheckedActive, public MContextBase, public MTimeOut {
public:
	enum TDirection { INCOMING, OUTGOING };
protected:
	Ccall_listener(MApp_context& Context);
	virtual void ConstructL(i_status_notif* i_cb, TDirection dir);
	virtual ~Ccall_listener();

	void CheckedRunL();
	void DoCancel();
	TInt CheckedRunError(TInt aError);
	enum state { LISTENING_INCOMING, CALL_IN_PROGRESS };
	state current_state;

	void expired(CBase*);

	virtual void handle_incoming() { }
	virtual void handle_disconnected() { }
	virtual void handle_answered() { }
	virtual void handle_refused() { }

	void listen_for_call();
	void store_contact();
	void open_call(); bool call_is_open;
	void close_call();

	i_status_notif* cb;
	CTimeOut*	iTimer;

	TTime	  call_start_time;

	TDirection iDir;
	TName	  call_name;
	RLine line;
	RAdvGsmCall call;
	TBuf<30>	iState;
	//MAdvGsmCallControl::TGsmStatus current_call_status;
	RCall::TStatus current_call_status;

	bool	got_info_for_this_call;

	CSpecialGroups*	iSpecialGroups;
};

#endif
