/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#ifndef HASH_H_INCLUDED
#define HASH_H_INCLUDED

//#include<string.h>

//#include<values.h>

#include <e32std.h>

class hash {
public:
	struct hash_node {
		HBufC* str;
		unsigned int number;
		void* data;
		hash_node *next;
	};
	typedef hash_node *hash_node_p;
      private:

	hash_node_p * table;
	unsigned int table_size;

	int depth_raja;
	float fill_limit;
	int maxdepth;
	unsigned int filled;
	float avg_depth;
	unsigned int nodecount;

	unsigned int hash_number(const TDesC& str);
	hash_node_p find_node(const TDesC& str);

      public:
	void (*deleter)(void* data);

	hash_node * addL(const TDesC& str, void* data, bool overwrite=false);

	hash( void(*delete_func)(void* data)=0 );
	~hash();

	void ConstructL(unsigned int initialsize=0);
	void Clear();

	void *find(const TDesC& str);

	unsigned int get_filled();
	int get_maxdepth();
	unsigned int get_size();
	float get_avg_depth();
	unsigned int get_nodecount();

};

#endif

/*

int main(void)
{
	hash taul(11981);
	int jarj = 1;
	int *temp_int;
	FILE *f;
	char sana[512];
	f = fopen("/usr/lib/ispell/ispell.words", "r");
	printf("\nListn:      ");
	while (fscanf(f, "%s", sana) != EOF) {
		printf("\010\010\010\010\010%5d", jarj);
		temp_int = new int;
		*temp_int = jarj++;
		taul.add(sana, temp_int);
	}
	rewind(f);
	jarj = 1;
	printf("\nHaetaan:       ");
	while (fscanf(f, "%s", sana) != EOF) {
		printf("\010\010\010\010\010%5d", jarj);
		temp_int = (int *) taul.find(sana);
		if (!temp_int || *temp_int != jarj)
			fprintf(stderr, "Virhe sanassa %d\n", jarj);
		jarj++;
	}
	printf("\n");
	printf("\nAlkioita:                      %d", taul.get_nodecount());
	printf("\nTaulukon size:                 %d", taul.get_size());
	printf("\nMaksimidepth taulukossa:      %d",
	       taul.get_maxdepth());
	printf("\nKeskiarvodepth:               %f",
	       taul.get_avg_depth());
	printf("\nTaulukon indeksien kyttaste: %f",
	       (((float) taul.get_filled()) /
		((float) taul.get_size())));
	printf("\n");
	return 0;
}

*/
