/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#if !defined(LOG_COMM_H_INCLUDED)

#define LOG_COMM_H_INCLUDED 1

#include <logcli.h>
#include <e32base.h>
#include <f32file.h>
#include <logview.h>

#include "file_output_base.h"
#include "status_notif.h"
#include "app_context.h"

class Clog_comm: public CCheckedActive, public Mfile_output_base
{
public:
	~Clog_comm();
	
	TPtr get_value();
	
	static Clog_comm* NewL(MApp_context& Context, i_status_notif* callback);

	bool write_comm_log(); // true when starting to write, false if already writing
	bool write_comm_log(TTime from); // true when starting to write, false if already writing
	bool LogsExist(TTime& From);
private:
	virtual void DoCancel();
	virtual void CheckedRunL();
private:
	Clog_comm(MApp_context& Context);
	void ConstructL(i_status_notif* callback);

	enum comm_state { IDLE, WAITING_ON_FILTER, WAITING_ON_MOVE };
	comm_state current_state;
	CLogClient* logclient;
	CLogFilter* filter;
	CLogViewEvent* view;

	i_status_notif* cb;
	TTime	iFromTime;
	void finished();
	void write_event(const CLogEvent& ev);
};

#endif
