/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#ifndef CL_LOG_IDLE_H_INCLUDED
#define CL_LOG_IDLE_H_INCLUDED 1

#include "i_log_source.h"
#include "log_base_impl.h"
#include "app_context.h"
#include <e32std.h>

class CLog_idle : public CCheckedActive, public Mlog_base_impl{
public:
	~CLog_idle();

	const TDesC& get_value();

	void CheckedRunL();

	static CLog_idle* NewL(MApp_context& Context);
	void DoCancel();
	virtual TInt CheckedRunError(TInt aError);

private:
	CLog_idle(MApp_context& Context);
	void ConstructL();
	void GetState();
	void Start();

	enum EState { EUnknown, EIdle, EActive };
	EState	iCurrentState;

	RTimer	iTimer;
	HBufC* iValue;
	int	iTimeOut;	
};

#endif //CL_LOG_IDLE_H_INCLUDED
