/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#if !defined(LOG_PROFILE_H_INCLUDED)

#define LOG_PROFILE_H_INCLUDED

#include "i_log_source.h"
#include "log_base_impl.h"
#include <profileapi.h>
#include <saclient.h>
#include "app_context.h"
#include "timeout.h"

class Clog_profile : public CCheckedActive, public Mlog_base_impl, public MTimeOut{
public:
	~Clog_profile();

	const TDesC& get_value();

	void CheckedRunL();

	static Clog_profile* NewL(MApp_context& Context);
	void DoCancel();
	virtual TInt CheckedRunError(TInt aError);
	int get_current_profile() { return prev_profile; }

private:
	void expired() { }
	IMPORT_C void expired(CBase* Source);

	Clog_profile(MApp_context& Context);
	void ConstructL();

	HBufC* profile_value;
	HBufC* name;
	int prev_profile, iProfileUid;
	TInt iRingingType, iRingingVolume;
	TBool iVibra;
	CArrayFixFlat<TSysAgentCondition>* aConditions;
	TInt get_profile_via_profilapi();
	TBuf<10> iVibraDescr;
	void listen_for_notification();
	CTimeOut *iWait;
	RSystemAgent	iSysAgent; bool iAgentIsOpen;
	TInt	iErrorCount;
};

#endif
