/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#ifndef CL_LOG_SMS_H_INCLUDED
#define CL_LOG_SMS_H_INCLUDED 1

#include <e32base.h>
#include "log_base_impl.h"
#include "sms.h"
#include "call_listener.h"

class CLog_sms : /*public CActive, */public Mlog_base_impl , public i_handle_received_sms
{
public:
	static CLog_sms* NewL(MApp_context& Context, const TDesC& name);
	~CLog_sms();

public:
	//from i_handle_received_sms
	virtual bool handle_reception(const TMsvId& entry_id, const TMsvId& folder_id, const TDesC& sender, const TDesC& body); // return true if message is to be deleted
	virtual void handle_change(const TMsvId& msg_id, const TDesC& sender);
	virtual void handle_delete(const TMsvId& msg_id, const TMsvId& parent_folder, const TDesC& sender);
	virtual void handle_move(const TMsvId& msg_id, const TMsvId& from_folder, const TMsvId& to_folder, const TDesC& sender);
	virtual void handle_error(const TDesC& descr);
	virtual void handle_sending(const TMsvId& entry_id, const TDesC& sender, const TDesC& body);
	virtual void handle_read (const TMsvId& msg_id, const TDesC& sender);
	
private:
	CLog_sms (MApp_context& Context);
	TBuf<10> MapEntry(const TMsvId& entry_id);
	void ConstructL(const TDesC& name);
	TBool IsFromToBuddy(const TDesC& sender);

private:
	CSpecialGroups*	iSpecialGroups;	
};

#endif
