/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#ifndef CL_PRESENCE_PUBLISHER_H_INCLUDED
#define CL_PRESENCE_PUBLISHER_H_INCLUDED 1

#include "app_context.h"
#include "ContextClientSession.h"
#include "ftp.h"
#include "xmlbuf.h"
#include "presence_data.h"
#include "status_notif.h"

class MPresencePublisherListener
{
public:
	virtual void NotifyNewPresence(const MPresenceData* Data)=0;
};

class CPresencePublisher : public CCheckedActive, public Mlogger, public MContextBase, 
		public MTimeOut, public MSettingListener, public MPresenceData {
public:
	static CPresencePublisher* NewL(MApp_context& Context, i_status_notif* CallBack, MPresencePublisherListener& aListener );
	~CPresencePublisher();

	void SuspendConnection();
	void ResumeConnection();
	bool ConnectionSuspended();
	bool Disabled();
	

private:
	CPresencePublisher(MApp_context& Context, i_status_notif* CallBack, MPresencePublisherListener& aListener );
	void ConstructL();
	void Restart();
	void SendUpdate();
	void MakePresence();

	// Mlogger
	virtual void register_source(const TDesC& name, const TDesC& initial_value, const TTime& time);
	virtual void new_value(log_priority priority, const TDesC& name, const TDesC& value, const TTime& time);
	virtual void unregister_source(const TDesC& name, const TTime& time);
	virtual const TDesC& name() const;

	// CCheckedActive
	void CheckedRunL();
	void DoCancel();
	virtual TInt CheckedRunError(TInt aError);

	// MTimeOut
	void expired(CBase*);

	// MSettingListener
	void SettingChanged(TInt Setting);

	// MPresenceData
	virtual const TCellInfo& CellInfo() const;
	virtual const TLocInfo& LocInfo() const;
	virtual const TActivityInfo& ActivityInfo() const;
	virtual const TProfileInfo& ProfileInfo() const;
	virtual const TTime& SendTimeStamp() const;
	virtual const TBluetoothInfo& BluetoothInfo() const;
	virtual bool IsSent() const;
	virtual void AddRef() { }
	virtual void Release() { }

	// data
	enum EState { EUnknown, EReconnecting, EConnecting, EConnected, 
		ESendingUpdate, ESuspending, ESuspended, EResuming, EDisabling, EDisabled };
	EState			iCurrentState;
	enum ENextOp { ENone, ESuspend, EResume, EDisable, EEnable };
	ENextOp			iNextOp;

	bool			iNewValue;

	RContextClientSession	iSession;
	TBuf<30>		iUser, iPass, iServer;
	CTimeOut*		iWait;
	TInt			iWaitTime;
	TInt			iAP;
	CXmlBuf*		iPresence;
	HBufC*			iSendPresence;
	TTime			iSentTimeStamp;


	TCellInfo		iCell;
	TLocInfo		iLocation;
	TActivityInfo		iActivity;
	TProfileInfo		iProfile;
	TBluetoothInfo		iBluetoothInfo;

	i_status_notif*		iCallBack;

	MPresencePublisherListener& iListener;

};

#endif
