/* 
 Copyright (C) 2004  Mika Raento - Renaud Petit

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
  
 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
   
    
 email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#ifndef USER_VIEW_H_INCLUDED
#define USER_VIEW_H_INCLUDED 1

#include <aknview.h>
#include <eiktxlbx.h>
#include "circular.h"
#include "doublelinebox.h"
#include "presence_publisher.h"

const TUid KUserViewId = {4};

class CUserContextContainer : public CCoeControl, MCoeControlObserver, public MListObserver {
public: // Constructors and destructor
        
	CUserContextContainer(CAknViewAppUi* AppUi);
        void ConstructL(const TRect& aRect, CCircularLog* Log, MEikListBoxObserver* ListBoxObserver);
	
        ~CUserContextContainer();
	void ContentsChanged();
	
private: // Functions from base classes
	
	void SetSizes(const TRect& aRect);
        void SizeChanged();
        TInt CountComponentControls() const;
        CCoeControl* ComponentControl(TInt aIndex) const;
        void Draw(const TRect& aRect) const;
        void HandleControlEventL(CCoeControl* aControl,TCoeEvent aEventType);
	TKeyResponse OfferKeyEventL(const TKeyEvent &aKeyEvent, TEventCode aType);
private: //data
        //CEikTextListBox* iListBox;
	CEikFormattedCellListBox * iListBox;
	CCircularLog*	iLog;
	TInt iPresses;
	CAknViewAppUi*			iAppUi;
	
	CEikLabel	*iTitle, *iDescription;
	HBufC		*iTitleText, *iDescriptionText;
};

class CUserView : public CAknView, public MEikListBoxObserver
{
public: // Constructors and destructor
	static CUserView* NewL(CCircularLog* Log, CPresencePublisher*& PresencePublisher);
        ~CUserView();
	
public: // Functions from base classes
        
        TUid Id() const;
	
        void HandleCommandL(TInt aCommand);
	
        void HandleClientRectChange();
	
private:
	CUserView(CPresencePublisher*& PresencePublisher);
        void ConstructL(CCircularLog* Log);
	
        void DoActivateL(const TVwsViewId& aPrevViewId,
		TUid aCustomMessageId,
		const TDesC8& aCustomMessage);
        void DoDeactivate();
	
	void HandleListBoxEventL(CEikListBox* aListBox,TListBoxEvent aEventType);
        void DynInitMenuPaneL(TInt aResourceId,CEikMenuPane* aMenuPane);

private: // Data
	CUserContextContainer*	iContainer;
	CCircularLog*	iLog;
	CPresencePublisher*& iPresencePublisher;
	
	
};


#endif // USER_VIEW_H_INCLUDED
