/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#pragma warning(disable: 4706)
/*
* ============================================================================
*  Name     : CContext_logAppUi from Context_logAppUi.cpp
*  Part of  : context_log
*  Created  : 13.2.2003 by 
*  Implementation notes:
*     Initial content was generated by Series 60 AppWizard.
*  Version  :
*  Copyright: 
* ============================================================================
*/

#include "ver.h"

// INCLUDE FILES
#include "Context_logAppUi.h"
#include "Context_logContainer.h" 
#include <context_log.rsg>
#include <sendnorm.rsg>
#include "context_log.hrh"
#include "context_logapp.h"

#include <avkon.hrh>
#include <aknquerydialog.h> 
#include <eikenv.h> // ieikonenv
#include <apgtask.h> // Going background 

#include <eikmenup.h>
#include <eiklabel.h>
#include <apgcli.h>

#include <stdlib.h> // for CloseSTDLIB()
#include <bautils.h>

#include <RPbkViewResourceFile.h>
#include <CPbkContactEditorDlg.h>
#include <CPbkContactEngine.h>
#include <CPbkSelectFieldDlg.h>
#include <CPbkContactItem.h>

#include "sms.h"
#include "web.h"

#include "keycapture.h"
#include <apgwgnam.h>

#include "userview.h"
#include "presencedetailview.h"

#include "cl_settings.h"
#include "log_systemevent.h"

#include <sacls.h>
#include <syevdef.h>

#include "hideview.h"

enum JOYSTICK_EVENTS {
	JOY_LEFT = 0xF807,
	JOY_RIGHT = 0xF808,
	JOY_UP = 0xF809,
	JOY_DOWN = 0xF80A,
	JOY_CLICK = 0xF845
};

const TUid KUidcontextbook = { 0x101FBAD0 };
const TUid KUidPhone = { 0x100058b3 };
const TUid KUidMenu = {  0x101f4cd2 };

const TInt KUidCloseLogValue=0x2003;
const TUid KUidCloseLog={KUidCloseLogValue};

_LIT(cellid_file, "cellid_names.txt");
_LIT(install_cellid_file, "cellid_names_inst.txt");
_LIT(transfer_cellid_file, "cellid_names_trans.txt");


_LIT(file_prefix, "log");

// ================= MEMBER FUNCTIONS =======================


void CContext_logAppUi::ReportError(const TDesC& Source,
	const TDesC& Reason, TInt Code)
{
	TBuf<256> msg;
	msg.Format(_L("Unhandled error %d %S"), Code, &(Reason.Left(120)));
	if (app_log) {
		TInt err;
		TRAP(err, app_log->post_new_value(msg));
		TRAP(err, app_log->post_new_value(Source));
	}
}

TErrorHandlerResponse CContext_logAppUi::HandleError(TInt aError,
     const SExtendedError& /*aExtErr*/,
     TDes& aErrorText,
     TDes& aContextText)
{
	// TODO: handle aExtErr
	TBuf<256> msg;
	msg.Format(_L("Unhandled error %d %S %S"), aError, &aContextText, &aErrorText);
	if (app_log) {
		TRAPD(err, app_log->post_new_value(msg));

		CCallStack::Node* n;
		n=AppContext().CallStack().iFirst;
		while (n) {
			TInt err;
			TRAP(err, app_log->post_new_value(n->Item));
			n=n->Next;
		}
		AppContext().CallStack().reset();
	}

	PrepareToExit();
	//CActiveScheduler::Stop();
	RDebug::Print(_L("delete this"));
	delete this;
	RDebug::Print(_L("User::Exit"));
	User::Exit(2003);
	return ENoDisplay;
}

void CContext_logAppUi::LogAppEvent(const TDesC& msg)
{
	CALLSTACKITEM(_L("CContext_logAppUi::LogAppEvent"));

	if (iLastLog) iLastLog->AddL(msg);
	if (app_log) app_log->post_new_value(msg);
}

void CContext_logAppUi::ConstructL()
{
	CALLSTACKITEM(_L("CContext_logAppUi::ConstructL"));

#ifdef __WINS__
    SetTime();
#endif

	state=_L("setting exception handler");

	RThread me;
	me.Open(me.Id());
	me.SetExceptionHandler(exceptionhandler, 
		KExceptionAbort|KExceptionFault|KExceptionFpe|KExceptionInteger|
		KExceptionKill|KExceptionUserInterrupt);
	me.Close();

#ifndef __WINS__
	bool wins=false;
#else
	bool wins=true;
#endif

	state=_L("fl");
	fl=Cfile_logger::NewL(AppContext(), file_prefix);
	AppContext().SetFileLog(fl);

	state=_L("create app event");
	app_log=Clog_base_impl::NewL(AppContext(), _L("app event"), _L(""));
	app_log->add_sinkL(fl);
	AppContext().SetActiveErrorReporter(this);

	state=_L("creating op waiter");

	iWait=CTimeOut::NewL(*this);
	iWaitingOps=CList<TCallBack>::NewL();

	state=_L("creating connection opener");

	iServ.Connect();
#ifndef __S60V2__
	iConnectionOpener=CConnectionOpener::NewL(*this, iServ);
#else
	iConnection.Open(iServ);
	iConnectionOpener=CConnectionOpener::NewL(*this, iServ, iConnection);
#endif
	//iConnectionOpener->MakeConnectionL(1);

	ringing=false;

	state=_L("BaseConstructL");

	BaseConstructL();

	iCaptionMyContext=CEikonEnv::Static()->AllocReadResourceL(R_ME_CAPTION);
	
	state=_L("notify");

	Settings().NotifyOnChange(SETTING_LOGGING_ENABLE, this);

	//__UHEAP_MARK;

	state=_L("smsh");

	smsh=new (ELeave) sms;
	smsh->ConstructL();

	state=_L("iUserContextLog");

	iUserContextLog=CCircularLog::NewL(1,ETrue);
	
	CEikonEnv::Static()->ReadResourceAsDes16(prev, R_PREVIOUS);
	CEikonEnv::Static()->ReadResourceAsDes16(not_avail, R_JABBER_NOT_AVAIL);

	iUserContext=HBufC::NewL(iCaptionMyContext->Length()+256);
	PresenceToListBoxL(0, iUserContext, iCaptionMyContext, 0,
		prev, not_avail);
	iUserContextLog->AddL(*iUserContext);

	iLastLog=CCircularLog::NewL(20, true);

	LogAppEvent(_L("Starting"));

	state=_L("create cell map");
	iCellDb=CDb::NewL(AppContext(), _L("CELLS"), EFileRead|EFileWrite);
	iCellMap=CCellMap::NewL(AppContext(), iCellDb->Db());
	// NOTE: we must construct base_counter directly after
	// cellmap so that the mappings get transfered correctly
	// from the base db to the cell map db after upgrading

	state=_L("create base counter");
	base_counter=new (ELeave) bases(this, AppContext(), *iCellMap);
	base_counter->ConstructL();
	//base_counter->test(); // NOP on ARMI

	//iRouteRecorder = CRouteRecorder::NewL(AppContext(), *iCellMap, *base_counter);

	state=_L("create status view");
	iStatusView = CStatusView::NewL(AppContext(), *iCellMap);
	iAppContainer = iStatusView->Container();
	AddViewL( iStatusView );      // transfer ownership to CAknViewAppUi
	SetDefaultViewL(*iStatusView);

	state=_L("create presence publisher");
	iPresencePublisher=CPresencePublisher::NewL(AppContext(), this, *this);

	state=_L("create upload view");
	iUploadView = CUploadView::NewL(AppContext(), iPresencePublisher, &(iStatusView->iNextViewId));
	AddViewL( iUploadView );      // transfer ownership to CAknViewAppUi

	state=_L("create code prompt");
	TUid statusv={1};
	iCodePrompt=CVisualCodePrompt::NewL(this, statusv, &(iStatusView->iNextViewId));
	MUploadPrompt *pr=iCodePrompt;

	state=_L("create picture publisher");
	iPicturePublisher=CPicturePublisher::NewL(AppContext(), *this, _L("?:\\nokia\\images"),
		_L("*jpg"), SETTING_PICTURE_ENABLE, *pr);
	iAppContainer->add_sinkL(iPicturePublisher);
	iPicturePublisher2=CPicturePublisher::NewL(AppContext(), *this, _L("?:\\images"),
		_L("*jpg"), SETTING_PICTURE_ENABLE, *pr);
	iAppContainer->add_sinkL(iPicturePublisher2);

	iVideoPublisher=CPicturePublisher::NewL(AppContext(), *this, _L("?:\\nokia\\videos"),
		_L("*3gp"), SETTING_PICTURE_ENABLE, *pr);
	iAppContainer->add_sinkL(iVideoPublisher);
	iVideoPublisher2=CPicturePublisher::NewL(AppContext(), *this, _L("?:\\videos"),
		_L("*3gp"), SETTING_PICTURE_ENABLE, *pr);
	iAppContainer->add_sinkL(iVideoPublisher2);

	iSoundPublisher=CPicturePublisher::NewL(AppContext(), *this, _L("?:\\nokia\\Sounds\\digital"),
		_L("*amr"), SETTING_PICTURE_ENABLE, *pr, _L("*aac"));
	iAppContainer->add_sinkL(iSoundPublisher);
	iSoundPublisher2=CPicturePublisher::NewL(AppContext(), *this, _L("?:\\Sounds\\digital"),
		_L("*amr"), SETTING_PICTURE_ENABLE, *pr, _L("*aac"));
	iAppContainer->add_sinkL(iSoundPublisher2);

	// n-gage
	iSoundPublisher3=CPicturePublisher::NewL(AppContext(), *this, _L("?:\\Record"),
		_L("*amr"), SETTING_PICTURE_ENABLE, *pr, _L("*aac"));
	iAppContainer->add_sinkL(iSoundPublisher3);
	
	iSoundPublisher4=CPicturePublisher::NewL(AppContext(), *this, _L("?:\\Sounds\\digital"),
		_L("*amr"), SETTING_PICTURE_ENABLE, *pr, _L("*aac"));
	iAppContainer->add_sinkL(iSoundPublisher4);
	

	iTextPublisher=CPicturePublisher::NewL(AppContext(), *this, _L("?:\\system\\apps\\ContextNote"),
		_L("*txt"), SETTING_PICTURE_ENABLE, *pr);
	iAppContainer->add_sinkL(iTextPublisher);

	state=_L("create settings view");
	auto_ptr<CSettingsView> iSettingsView(CSettingsView::NewL(AppContext()));
	AddViewL(iSettingsView.get());
	iSettingsView.release();

	state=_L("create log view");
	auto_ptr<CAppLogView> logview(CAppLogView::NewL(iLastLog));
	AddViewL(logview.get());
	logview.release();

	state=_L("create user view");
	auto_ptr<CUserView> userview(CUserView::NewL(iUserContextLog, iPresencePublisher));
	AddViewL(userview.get());
	CUserView* v=userview.release();
	//SetDefaultViewL(*v);

	state=_L("create hide view");
	auto_ptr<CHideView> Hideview(CHideView::NewL());
	AddViewL(Hideview.get()); TBool enable_options=false;
	if ( Settings().GetSettingL(SETTING_OPTIONS_ENABLE, enable_options) && enable_options) {
		Hideview.release();
	} else {
		SetDefaultViewL(*(Hideview.release()));
	}

	state=_L("create presence detail");
	auto_ptr<CPresenceDetailView> detailview(CPresenceDetailView::NewL());
	AddViewL(detailview.get());
	iPresenceDetailView=detailview.release();

	state=_L("create cell callback");
	caller=new (ELeave) name_cell_callback(this);
	caller->ConstructL();

	name_times=new (ELeave) CArrayFixFlat<TTime>(2);
	name_names=new (ELeave)CArrayFixFlat<HBufC*>(2);

	state=_L("create note");
	globalNote=CAknGlobalNote::NewL();

	state=_L("create snapshot");
	iSnapShot=CSnapShot::NewL(AppContext());

	state=_L("create mms");
	iMMS=CMMS::NewL();

	state=_L("create keylock");
	User::LeaveIfError(keylock.Connect());

	iEikonEnv->AddForegroundObserverL(*this);
	ringp=CFLDRingingTonePlayer::NewL(ETrue);

	// We'll fool the ringtoneplayer about fg/bg events
	iEikonEnv->RemoveForegroundObserver(*ringp);

	{
		MoveIntoDataDirL(AppContext(), cellid_file);
		// copy the installed cellid_names over the real one, if
		// one has been installed

		TFileName install_cellid_filen, cellid_filen;
		install_cellid_filen.Format(_L("%S%S"), &AppDir(), &install_cellid_file);
		cellid_filen.Format(_L("%S%S"), &DataDir(), &cellid_file);
		if (BaflUtils::FileExists(Fs(), install_cellid_filen)) {
			User::LeaveIfError(BaflUtils::CopyFile(Fs(), install_cellid_filen, cellid_filen));
			User::LeaveIfError(BaflUtils::DeleteFile(Fs(), install_cellid_filen));
		}

		if (cellid_name_file.Open(Fs(), cellid_filen, 
			EFileShareAny | EFileStreamText | EFileRead | EFileWrite)!=KErrNone) {
			User::LeaveIfError(cellid_name_file.Create(Fs(), cellid_filen, 
				EFileShareAny | EFileStreamText | EFileRead | EFileWrite));
		}
	}

	CC()->PrepareToConvertToOrFromL(KCharacterSetIdentifierIso88591, Fs());
	read_cellid_names();
		
	iAppContainer->add_sinkL(iPresencePublisher);
	iAppContainer->add_sinkL(iAppContainer);

	state=_L("create locationing");

	loc=Clocationing::NewL(AppContext(), this, this, smsh, iPresencePublisher);

	state=_L("create cell ann");
	cell_ann=Clog_base_impl::NewL(AppContext(), _L("cell ann"), _L(""));
	cell_ann->add_sinkL(fl);
	// don't show in UI
	//cell_ann->add_sinkL(iAppContainer);
	
	state=_L("create context name");
	context_ann=Clog_base_impl::NewL(AppContext(), _L("context name"), _L(""));
	context_ann->add_sinkL(fl);

	state=_L("create web search");
	web_log=Clog_base_impl::NewL(AppContext(), _L("web search"), _L(""));
	web_log->add_sinkL(fl);

	iLoggers=new (ELeave) CArrayPtrFlat<Mlog_base_impl>(10);

	state=_L("create log cellid");
	lc=Clog_cellid::NewL(AppContext(), *iCellMap);
	iLoggers->AppendL(lc);
	if (lc) lc->add_sinkL(iAppContainer);
	if (lc) lc->add_sinkL(fl);
	if (lc) lc->add_sinkL(base_counter);
	if (lc) lc->add_sinkL(iPresencePublisher);
	//if (lc) lc->add_sinkL(iRouteRecorder);
	
	state=_L("create log sms");
	lsms=CLog_sms::NewL(AppContext(), _L("SMS "));
	iLoggers->AppendL(lsms);
	smsh->AddHandler(lsms);
	lsms->add_sinkL(fl);
	
	state=_L("create log profile");
	lp=Clog_profile::NewL(AppContext());
	iLoggers->AppendL(lp);
	lp->add_sinkL(iAppContainer);
	lp->add_sinkL(fl);
	lp->add_sinkL(iPresencePublisher);

	if (wins && 0) {
		ls=Clog_soundlevel::NewL(AppContext());
		iLoggers->AppendL(ls);
		ls->add_sinkL(iAppContainer);
		ls->add_sinkL(fl);
	}

	state=_L("create log appuse");
	lau=CLog_AppUse::NewL(AppContext());
	iLoggers->AppendL(lau);
	if (wins) 
		lau->add_sinkL(iAppContainer);
	lau->add_sinkL(fl);

	state=_L("create commlog");
	comml=Clog_comm::NewL(AppContext(), this);
	ll=CLog_local::NewL(AppContext(), KLog_activity);
	iLoggers->AppendL(ll);
	iKeycaptureArgs.iKeyStatus=ll->RequestStatus();
	if (wins) 
		ll->add_sinkL(iAppContainer);
	ll->add_sinkL(fl);
	ll->add_sinkL(iPresencePublisher);

	state=_L("create system event loggers");
	Mlog_base_impl* l;
	l=CLog_SystemEvent::NewL(AppContext(), _L("Charger"), KUidChargerStatus); 
	iLoggers->AppendL(l); l->add_sinkL(fl);
	l=CLog_SystemEvent::NewL(AppContext(), _L("Network status"), KUidNetworkStatus); 
	iLoggers->AppendL(l); l->add_sinkL(fl);

	state=_L("create transferer");
	transferer=CSendUITransfer::NewL(AppContext(), this, Econtext_logCmdSendAppUi, DataDir(), AppDir());
	transferer->add_filesL(_L("log*txt"), true);
	transferer->add_filesL(_L("book*txt"), true);
	transferer->add_filesL(_L("comm*txt"), false);
	transferer->add_filesL(_L("rec*amr"), false);
	transferer->add_filesL(_L("cellid_names_trans.txt"), false);

	iPeriodicTransfer=CPeriodicTransfer::NewL(AppContext(), 24, this);

	discoverer=CDiscover::NewL(AppContext());
	discoverer->add_sinkL(iAppContainer);
	discoverer->add_sinkL(fl);
	discoverer->add_sinkL(iPresencePublisher);

	TInt pos=0;
	cellid_name_file.Seek(ESeekEnd, pos);

	/*
	answerer=Canswering::NewL(AppContext(), this);
	lp->add_sinkL(answerer);
	iAppContainer->add_sinkL(answerer);
	*/

	state=_L("create call recorders");
	in_recorder=CCall_record::NewL(AppContext(), this, CCall_record::INCOMING);
	out_recorder=CCall_record::NewL(AppContext(), this, CCall_record::OUTGOING);

	iUserNotifier = CUserNotifier::NewL(AppContext(),ringp,lp);

	iKeycaptureArgs.iAppContext=&AppContext();

	state=_L("start keycapture");
	RWindowGroup wg=iEikonEnv->RootWin();
	iKeycaptureArgs.iParentWg=wg.Identifier();
	keycapture.start(_L("keycapture"), start_keycapture, (TAny*)&iKeycaptureArgs);
	
	iAppContainer->set_status(_L(""));

	iEikonEnv->SetSystem(ETrue);

	if (!wins)
		QueueOp(&CContext_logAppUi::hide);

	LogAppEvent(_L("Started"));

	current_state=IDLE;
	initialising=false;

	state=_L("");
	
}

// ----------------------------------------------------
// CContext_logAppUi::~CContext_logAppUi()
// Destructor
// Frees reserved resources
// ----------------------------------------------------
//
CContext_logAppUi::~CContext_logAppUi()
{
	CALLSTACKITEM(_L("CContext_logAppUi::~CContext_logAppUi"));

	{
	CALLSTACKITEM(state);

	Settings().CancelNotifyOnChange(SETTING_LOGGING_ENABLE, this);

	if (iTestFileOpen) iTestFile.Close();

	CEikonEnv::Static()->RemoveForegroundObserver(*this);
	keycapture.stop();

	delete comml;

	delete iUserNotifier;

	delete iCaptionMyContext;
	
	//delete lt;
	if (t) {
		t->Kill(0);
		delete t;
	}

	if (iLoggers) iLoggers->ResetAndDestroy();
	delete iLoggers;

	//delete iRouteRecorder;

	delete cell_ann;
	delete context_ann;
	delete app_log;
	AppContext().SetActiveErrorReporter(0);
	delete web_log;

	delete transferer;
	delete ftp_transfer;
	delete iPeriodicTransfer;

	delete iConnectionOpener;

	delete discoverer;

	if (iAppContainer) iAppContainer->release_sinks();
	AppContext().SetFileLog(0);
	delete iPresencePublisher;
	delete iUserContextLog;
	delete iUserContext;
	delete iPicturePublisher; delete iPicturePublisher2;
	delete iVideoPublisher; delete iVideoPublisher2;
	delete iSoundPublisher; delete iSoundPublisher2;
	delete iSoundPublisher3; delete iSoundPublisher4;
	delete iTextPublisher;


	TTime t;
	t.HomeTime();

	if (fl) fl->new_value(Mlogger::VALUE, _L("APP"), state, t);
	delete answerer;
	delete in_recorder;
	delete out_recorder;
	delete base_counter;

	cellid_name_file.Close();
	keylock.Close();

	if (fl) fl->new_value(Mlogger::VALUE, _L("APP"), _L("del 1"), t);
	if (name_names) {
		for (int i=0; i< name_names->Count(); i++) {
			delete (*name_names)[i];
		}
	}

	delete name_times; delete name_names;

	delete globalNote;

	delete caller;
	delete loc;
	delete smsh;

	delete iCodePrompt; 

	delete iSnapShot;
	delete iMMS;

	if (fl) fl->new_value(Mlogger::VALUE, _L("APP"), _L("del 2"), t);

	if (ringp)
		iEikonEnv->AddForegroundObserverL(*ringp);
	delete ringp;

	delete iCellMap;
	delete iCellDb;


	delete iLastLog;

#ifdef __S60V2__
	iConnection.Close();
#endif
	iServ.Close();
	delete iWaitingOps;
	delete iWait;

	
	if (fl) fl->new_value(Mlogger::VALUE, _L("APP"), _L("del 3"), t);

	delete fl;
	CloseSTDLIB();

#if defined(__S60V2__) && ! defined(__WINS__)
	// the cell change notification keeps the thread from
	// exiting otherwise
	PrepareToExit();
	AppContext().Release();
	User::Exit(0);
#endif
	}

	//__UHEAP_MARKEND;
}

void CContext_logAppUi::hide()
{
	CALLSTACKITEM(_L("CContext_logAppUi::hide"));

	RWsSession& wsSession=CEikonEnv::Static()->WsSession();
	
	TApaTask task(wsSession);
	task.SetWgId(CEikonEnv::Static()->RootWin().Identifier());
	task.SendToBackground();
}

void CContext_logAppUi::unhide()
{
	CALLSTACKITEM(_L("CContext_logAppUi::unhide"));

	RWsSession& wsSession=CEikonEnv::Static()->WsSession();
	TApaTask task(wsSession);
	task.SetWgId(CEikonEnv::Static()->RootWin().Identifier());
	task.BringToForeground();
}


// ------------------------------------------------------------------------------
// CContext_logAppUi::::DynInitMenuPaneL(TInt aResourceId,CEikMenuPane* aMenuPane)
//  This function is called by the EIKON framework just before it displays
//  a menu pane. Its default implementation is empty, and by overriding it,
//  the application can set the state of menu items dynamically according
//  to the state of application data.
// ------------------------------------------------------------------------------
//
void CContext_logAppUi::DynInitMenuPaneL(
					 TInt aResourceId,CEikMenuPane* aMenuPane)
{
	CALLSTACKITEM(_L("CContext_logAppUi::DynInitMenuPaneL"));

	switch(aResourceId) {
	case R_CONTEXT_LOG_MENU:
		if (fl) {
			if (fl->is_paused()) {
				aMenuPane->SetItemDimmed(Econtext_logCmdAppPauseLog, ETrue);	
				aMenuPane->SetItemDimmed(Econtext_logCmdAppUnPauseLog, EFalse);
			} else {
				aMenuPane->SetItemDimmed(Econtext_logCmdAppPauseLog, EFalse);	
				aMenuPane->SetItemDimmed(Econtext_logCmdAppUnPauseLog, ETrue);
			}
		} else {
			aMenuPane->SetItemDimmed(Econtext_logCmdAppPauseLog, ETrue);	
			aMenuPane->SetItemDimmed(Econtext_logCmdAppUnPauseLog, ETrue);
		}
		if (iPresencePublisher) {
			if (iPresencePublisher->ConnectionSuspended()) {
				aMenuPane->SetItemDimmed(Econtext_logCmdAppSuspendPresence, ETrue);	
				aMenuPane->SetItemDimmed(Econtext_logCmdAppResumePresence, EFalse);
			} else {
				aMenuPane->SetItemDimmed(Econtext_logCmdAppSuspendPresence, EFalse);	
				aMenuPane->SetItemDimmed(Econtext_logCmdAppResumePresence, ETrue);
			}
		} else {
			aMenuPane->SetItemDimmed(Econtext_logCmdAppSuspendPresence, ETrue);	
			aMenuPane->SetItemDimmed(Econtext_logCmdAppResumePresence, ETrue);
		}
		break;
	case R_SENDUI_TOPMENU:
		transferer->DisplaySendMenuL(*aMenuPane, 1);
		break;
	case R_SENDUI_MENU:
		// sendui cascade
		transferer->DisplayMenuL(*aMenuPane);
		break;
	default:
		break;
	}
}

// ----------------------------------------------------
// CContext_logAppUi::HandleKeyEventL(
//     const TKeyEvent& aKeyEvent,TEventCode /*aType*/)
// ?implementation_description
// ----------------------------------------------------
//
TKeyResponse CContext_logAppUi::HandleKeyEventL(
						const TKeyEvent& /*aKeyEvent*/,TEventCode /*aType*/)
{
	CALLSTACKITEM(_L("CContext_logAppUi::HandleKeyEventL"));

	if (ringing) {
		((MFLDFileProcessor*)ringp)->Cancel();
		ringing=false;
	}


	return EKeyWasNotConsumed;
}

void CContext_logAppUi::HandleSystemEventL  (  const TWsEvent &    aEvent  )
{
	CALLSTACKITEM(_L("CContext_logAppUi::HandleSystemEventL"));

	TApaSystemEvent event;
	event = *(TApaSystemEvent*)aEvent.EventData();

	switch ( event ) {
		case EApaSystemEventShutdown:
			LogAppEvent(_L("ext shutdown"));
			Exit();
			return;
			break;
		default:
			break;
	}
	CAknViewAppUi::HandleSystemEventL(aEvent);
	//CEikAppUi::HandleSystemEventL(aEvent);
}

void CContext_logAppUi::ProcessMessageL(TUid aUid,const TDesC8& aParams)
{
	if (aUid==KUidCloseLog) {
		Exit();
	} else {
		CAknViewAppUi::ProcessMessageL(aUid,aParams);
	}
}

void CContext_logAppUi::HandleWsEventL(const TWsEvent& aEvent, CCoeControl* aDestination)
{
	CALLSTACKITEM(_L("CContext_logAppUi::HandleWsEventL"));

	TInt type=aEvent.Type();
	switch (type) {
		case EEventCaseOpened:
			case_closed=false;
			break;
		case EEventCaseClosed:
			case_closed=true;
			break;
	}
	TRAPD(err, CAknAppUi::HandleWsEventL(aEvent, aDestination));
	if (err==KErrCancel)  return;

	User::LeaveIfError(err);
}

void CContext_logAppUi::QueueOp(TCallBack Op, int AfterSeconds)
{
	CALLSTACKITEM(_L("CContext_logAppUi::QueueOp"));

	iWaitingOps->AppendL(Op);
	iWait->Wait(AfterSeconds);
}
void CContext_logAppUi::expired(CBase*)
{
	CALLSTACKITEM(_L("CContext_logAppUi::expired"));

	TCallBack op=iWaitingOps->Pop();
	((*this).*op)();
	while (iWaitingOps->iFirst && iWaitingOps->Top()==op) iWaitingOps->Pop();
	if (iWaitingOps->iFirst) {
		iWait->Wait(1);
	}
}

void CContext_logAppUi::HandleCommandL(TInt aCommand)
{
	switch ( aCommand )
	{
	case EAknSoftkeyBack:
		QueueOp(&CContext_logAppUi::hide);
		break;
	case EEikCmdExit:
		{
			LogAppEvent(_L("user shutdown"));
			Exit();
			break;
		}
	case Econtext_logDetailedView:
		ActivateLocalViewL(KStatusViewId);
		break;

	case Econtext_logPresenceDetails:
		PresenceDetails();
		break;

	case Econtext_logCmdAppNameCell:
		{
		TTime now; now.HomeTime();

		name_cell(CAknQueryDialog::ENoTone, lc->get_value(), now);
		}
		break;
	case Econtext_logCmdAppNameContext:
		name_context();
		break;
	case Econtext_logCmdAppRecordDesc:
		record_description();
		break;
	case Econtext_logCmdAppPauseLog:
		Settings().WriteSettingL(SETTING_LOGGING_ENABLE, EFalse);
		break;
	case Econtext_logCmdAppUnPauseLog:
		Settings().WriteSettingL(SETTING_LOGGING_ENABLE, ETrue);
		break;
	case Econtext_logCmdAppGetCommLog:
		{
		if (comml->write_comm_log()) {
			_LIT(getting, "Getting comm log");
			iAppContainer->set_status(getting);
		} else {
			_LIT(no, "Nothing to do");
			iAppContainer->set_status(no);
		}
		break;
		}
	case Econtext_logCmdCancelSend:
		// do nothing
		break;
	case Econtext_logCmdAppTest:
		{
		//loc->test();
		//recorder->test();
		DialogTest();
		}
		break;
	case Econtext_logCmdAppImsi:
		if (loc) status_change(loc->GetImsi());
		break;
	case Econtext_logCmdAppSettings:
		ActivateLocalViewL(KSettingsViewId);
		break;
	case Econtext_logCmdAppLog:
		ActivateLocalViewL(KLogViewId);
		break;
	case Econtext_logMyContext:
		ActivateLocalViewL(KUserViewId);
		break;
	case Econtext_logCmdSettingsCancel:
	case Econtext_logCmdSettingsSave:
	case Econtext_logCmdlogviewClose:
		ActivateLocalViewL(KStatusViewId);
		break;
	case Econtext_logCmdAppWeb:
		{
		CWebForm* f=CWebForm::NewL(AppContext(), *iConnectionOpener, *web_log);
		f->ExecuteLD();
		}
		break;
	case Econtext_logCmdAppSuspendPresence:
		{
			LogAppEvent(_L("User suspended presence"));
			Settings().WriteSettingL(SETTING_PRESENCE_ENABLE, 0);
		}
		break;
	case Econtext_logCmdAppResumePresence:
		{
			LogAppEvent(_L("User resumed presence"));
			Settings().WriteSettingL(SETTING_PRESENCE_ENABLE, 1);
		}
		break;
	case Econtext_logCmdSnapShot:
		{
			iSnapShot->TakeSnapShot(_L("c:\\nokia\\images\\"), this);
		}
		break;
	default:
		if (aCommand>Econtext_logCmdSendAppUi || aCommand==Econtext_logCmdSendFtp) {
			
			if (aCommand==Econtext_logCmdSendFtp) {
				//ftp_transfer->TransferFiles();
				iPeriodicTransfer->Transfer(false);
			} else {
				status_change(_L("trying transfer"));

				cellid_name_file.Close();
				
				TFileName transfer_cellid_filen, cellid_filen;
				transfer_cellid_filen.Format(_L("%S%S"), &AppDir(), &transfer_cellid_file);
				cellid_filen.Format(_L("%S%S"), &DataDir(), &cellid_file);

				TInt ferr=BaflUtils::CopyFile(Fs(), cellid_filen, transfer_cellid_filen);
				if (ferr!=KErrNone) {
					TBuf<30> errmsg;
					errmsg.Format(_L("copy: %d"), ferr);
					error(errmsg);
					return;
				}
				ferr=cellid_name_file.Open(Fs(), cellid_filen, 
					EFileShareAny | EFileStreamText | EFileRead | EFileWrite);
				if (ferr!=KErrNone) {
					TBuf<30> errmsg;
					errmsg.Format(_L("reopen: %d, RESTART NOW"), ferr);
					error(errmsg);
					return;
				}
				fl->switch_file();

				transferer->transfer_files(aCommand);
			}
			
		}
		break;
	}
}

void CContext_logAppUi::finished()
{
	CALLSTACKITEM(_L("CContext_logAppUi::finished"));

	_LIT(got, "finished op");
	iAppContainer->set_status(got);
}

void CContext_logAppUi::error(const TDesC& descr)
{	
	CALLSTACKITEM(_L("CContext_logAppUi::error"));

	if (descr.Length()>0) {
		TBuf<200> msg;
		msg.Append(_L("ERROR: "));
		msg.Append(descr.Left(190));
		//globalNote->ShowNoteL(EAknGlobalInformationNote, descr	);
		LogAppEvent(msg);
		RDebug::Print(msg);
	}
	if (iAppContainer) iAppContainer->set_error(descr);
}

void CContext_logAppUi::status_change(const TDesC& status)
{
	CALLSTACKITEM(_L("CContext_logAppUi::status_change"));

	//globalNote->ShowNoteL(EAknGlobalInformationNote, status);
	if (status.Length()>0) {
		TBuf<200> msg;
		msg.Append(_L("STATUS: "));
		msg.Append(status.Left(190));
		LogAppEvent(msg);
	}
	if (iAppContainer) iAppContainer->set_status(status);
}

void CContext_logAppUi::write_to_output(const TDesC& str)
{
	CALLSTACKITEM(_L("CContext_logAppUi::write_to_output"));

	CC()->ConvertFromUnicode(buf, str);
	cellid_name_file.Write(buf);
}

void CContext_logAppUi::read_cellid_names()
{
	CALLSTACKITEM(_L("CContext_logAppUi::read_cellid_names"));

	TBuf<512> unibuf;
	TBuf<200> cell_name, cellid;
	TInt pos=0; TChar cur; TInt len;
	bool read_id=false;

	TInt state=CCnvCharacterSetConverter::KStateDefault;
	cellid_name_file.Read(buf);
	while ( (len=buf.Length()) ) {
		CC()->ConvertToUnicode(unibuf, buf, state);
		while (pos<len) {
			while (!read_id && pos<len && (cur=unibuf[pos])!=L'\t') {
				cellid.Append(cur);
				pos++;
			}
			if (pos<len) {
				read_id=true;
				pos++; // skip tab
			}
			while (pos<len && (cur=unibuf[pos])!=L'\n') {
				cell_name.Append(cur);
				pos++;
			}
			if (pos<len) {
				pos++; //skip nl for next
				if (cellid.Length() && cell_name.Length()) 
					iAppContainer->add_cellid_name(cellid, cell_name);
				cellid.Zero();
				cell_name.Zero();
				read_id=false;
			}
		}
		buf.Zero();
		pos=0;
		cellid_name_file.Read(buf);
	}
}

void CContext_logAppUi::now_at_location(const TDesC& cellid, TInt id, bool is_base, bool loc_changed, TTime time)
{
	CALLSTACKITEM(_L("CContext_logAppUi::now_at_location"));

	if (loc) loc->now_at_location(cellid, id, is_base, loc_changed, time);

	//globalNote->ShowNoteL(EAknGlobalInformationNote, cellid);
	//if (initialising) return;
	if (!iAppContainer) return;
	iAppContainer->now_at_location(cellid, id, is_base, loc_changed, time);
	if (id<0) return;

	TInt id_for_cell=iCellMap->GetId(cellid);
	if (is_base && ! iAppContainer->is_named(id) && ! iAppContainer->is_named(id_for_cell) ) {
		if (loc && loc->LocationgAvailable()) {
			loc->GetNameL(cellid);
		} else {
			TBool ask_for_name;
			if ( Settings().GetSettingL(SETTING_PROMPT_FOR_NAMES, ask_for_name) && !ask_for_name) return;
			// don't insert duplicates
			for (int i=0; i < name_names->Count(); i++) {
				if ( ! (*name_names)[i]->Des().Compare(cellid) ) return;
			}

			TTime now;
			now.HomeTime();
			

			name_times->AppendL(now);
			HBufC* cell;
			cell=HBufC::NewL(cellid.Length());
			*cell=cellid;
			name_names->AppendL(cell);
			caller->call();
		}
	}
}

void CContext_logAppUi::name_cells()
{	
	CALLSTACKITEM(_L("CContext_logAppUi::name_cells"));

	unhide();

	((MCoeForegroundObserver*)ringp)->HandleGainingForeground();

	current_state=NAME_CELLS;
	int profile=lp->get_current_profile();

	// cannot play tone if we want to play a ringtone
	//CAknQueryDialog::TTone tone=CAknQueryDialog::EWarningTone;
	CAknQueryDialog::TTone tone=CAknQueryDialog::ENoTone; 
	ringp->SetVibra(ETrue);
	ringp->SetRingingType(2); // ring once
	switch (profile) {
	case 2:
		// meeting
		((MFLDFileProcessor*)ringp)->ProcessFileL(_L("c:\\system\\apps\\context_log\\silent.rng"));
		ringing=true;
		break;
	case 1:
		// silent
		break;
	default:
		// general, outdoor
		ringing=true;
		((MFLDFileProcessor*)ringp)->ProcessFileL(_L("c:\\system\\apps\\context_log\\tone.rng"));
		break;
	}

	{
		for (int i=0; i<name_names->Count(); i++) {
			HBufC* cell=(*name_names)[i];
			name_cell(tone, cell->Des(), (*name_times)[i]);
			name_times->Delete(i);
			name_names->Delete(i);
			delete cell;
		}
		name_times->Compress();
		name_names->Compress();
	}
	((MFLDFileProcessor*)ringp)->Cancel();
	hide();
	current_state=IDLE;

	((MCoeForegroundObserver*)ringp)->HandleLosingForeground();
	ringing=false;
}

void CContext_logAppUi::HandleGainingForeground()
{
	CALLSTACKITEM(_L("CContext_logAppUi::HandleGainingForeground"));

	// this is used to close a connection made for
	// the web browser after the browser is closed
	// and the log comes to the foregroud - of course
	// if the user switches away from the browser
	// in some other way this doesn't work FIXME!
	if (iConnectionOpener->MadeConnection()) {
		iConnectionOpener->CloseConnection();
	}
}

void CContext_logAppUi::HandleLosingForeground() 
{
	CALLSTACKITEM(_L("CContext_logAppUi::HandleLosingForeground"));

}

void CContext_logAppUi::name_cell(const CAknQueryDialog::TTone tone, const TDesC & cell, TTime time)
{
	if (IsDisplayingMenuOrDialog()) return;

	const TInt NAME_LENGTH=100;
	HBufC* textData=HBufC::NewL(NAME_LENGTH);
	
	TBuf<50> cellid;
	cellid=cell;

	CleanupStack::PushL(textData);
	TPtr16 p=textData->Des();

	HBufC* f;
	f=CEikonEnv::Static()->AllocReadResourceLC(R_CL_NAME_CELL_CAPTION);
	HBufC* pr=HBufC::NewLC(f->Des().Length()+4);
	TDateTime dt(time.DateTime());
	pr->Des().Format(f->Des(), dt.Hour(), dt.Minute());

	CAknTextQueryDialog* dlg = new(ELeave) CAknTextQueryDialog(p, tone);
	CleanupStack::PushL(dlg);
	dlg->SetMaxLength(NAME_LENGTH);
	dlg->SetPromptL(*pr);
	CleanupStack::Pop();
	iShowingDialog=true;
	if (dlg->ExecuteLD(R_CONTEXT_LOG_NAME_INPUT) && textData->Length())
	{
		add_cellid_name(cellid, *textData);
	}
	CleanupStack::PopAndDestroy(3); // data, format, caption
}

void CContext_logAppUi::add_cellid_name(const TDesC& cellid, const TDesC& name)
{
	CALLSTACKITEM(_L("CContext_logAppUi::add_cellid_name"));

	cell_ann->post_new_value(name);
	iAppContainer->add_cellid_name(cellid, name);
	write_to_output(cellid);
	_LIT(tab, "\t");
	write_to_output(tab);
	write_to_output(name);
	_LIT(nl, "\n");
	write_to_output(nl);
	//write_nl();
}

void CContext_logAppUi::name_context()
{
	if (IsDisplayingMenuOrDialog()) return;

	CALLSTACKITEM(_L("CContext_logAppUi::name_context"));

	const TInt CONTEXT_LENGTH=100;
	HBufC* textData=HBufC::NewL(CONTEXT_LENGTH);
	CleanupStack::PushL(textData);
	TPtr16 p=textData->Des();
	CAknTextQueryDialog* dlg = new(ELeave) CAknTextQueryDialog(p, CAknQueryDialog::ENoTone);
	CleanupStack::PushL(dlg);
	dlg->SetMaxLength(CONTEXT_LENGTH);
	_LIT(pr, "Context name");
	dlg->SetPromptL(pr);
	CleanupStack::Pop();
	if (dlg->ExecuteLD(R_CONTEXT_LOG_NAME_INPUT))
	{
		context_ann->post_new_value(textData->Des());
	}
	CleanupStack::PopAndDestroy();
}

void CContext_logAppUi::record_description()
{
	CALLSTACKITEM(_L("CContext_logAppUi::record_description"));

}

name_cell_callback::name_cell_callback(CContext_logAppUi* i_ui) : 
	CCheckedActive(EPriorityIdle, _L("name_cell_callback")), ui(i_ui) { }

void name_cell_callback::ConstructL()
{
	CALLSTACKITEM(_L("name_cell_callback::ConstructL"));

	timer.CreateLocal();
	CActiveScheduler::Add(this); // add to scheduler
}

void name_cell_callback::call()
{
	CALLSTACKITEM(_L("name_cell_callback::call"));

	if (is_active) return;
	TTimeIntervalMicroSeconds32 w(1*1000*1000);
	timer.After(iStatus, w);
	is_active=true;
	SetActive();
}

void name_cell_callback::CheckedRunL()
{
	CALLSTACKITEM(_L("name_cell_callback::CheckedRunL"));

	if (ui) {
		ui->name_cells();
	}
	is_active=false;
}

void name_cell_callback::DoCancel()
{
	CALLSTACKITEM(_L("name_cell_callback::DoCancel"));

	timer.Cancel();
}

name_cell_callback::~name_cell_callback()
{
	CALLSTACKITEM(_L("name_cell_callback::~name_cell_callback"));

	Cancel();
	timer.Close();
}

class CLogEventTest : public CActive {
public:
	static CLogEventTest* NewL(RFs& Fs) {
		auto_ptr<CLogEventTest> ret(new (ELeave) CLogEventTest);
		ret->ConstructL(Fs);
		return ret.release();
	}
	CLogEventTest() : CActive(EPriorityNormal) { }
	void ConstructL(RFs& Fs) {
		lc=CLogClient::NewL(Fs);
		le=CLogEvent::NewL();
		le->SetEventType(KLogCallEventTypeUid);
		le->SetContact(1);
		le->SetDirection(_L("Outgoing"));
		le->SetDuration(1);
		le->SetDurationType(KLogDurationValid);
		le->SetNumber(_L("0505536758"));
		TTime now; now.HomeTime();

		le->SetTime(now);
		le->SetRemoteParty(_L("mika"));
		CActiveScheduler::Add(this);
		lc->AddEvent(*le, iStatus);
		SetActive();
	}
	void RunL() {
		delete this;
	}
	void DoCancel() { }
	~CLogEventTest() {
		Cancel();
		delete lc;
		delete le;
	}
private:
	CLogClient*	lc;
	CLogEvent*	le;
};

void CContext_logAppUi::PresenceDetails()
{
	iPresenceDetailView->SetData(*iCaptionMyContext, iPresencePublisher);

	ActivateLocalViewL(KPresenceDetailView);

	return;
}

void CContext_logAppUi::DialogTest()
{
	/*CLogEventTest* t=CLogEventTest::NewL(Fs());
	
	return;
	*/

	TBuf<100> err;
	TInt ret=iMMS->SendMessage(_L("0505536758"), _L("body of msg"), _L(""), err, false);
	if (ret!=KErrNone) Error(ret, err);
	else status_change(_L("message sent"));
	return;

	if (iTestFileOpen) {
		iTestFile.Close();
		iTestFileOpen=false;
	} else {
		TFileName from=_L("C:\\nokia\\images\\img.jpg");
		TFileName filen=_L("C:\\nokia\\images\\img");
		TInt i=2; filen.AppendNum(i); filen.Append(_L(".jpg"));
		while (BaflUtils::FileExists(Fs(), filen)) {
			filen=_L("C:\\nokia\\images\\img");
			++i; filen.AppendNum(i); filen.Append(_L(".jpg"));
		}
		BaflUtils::CopyFile(Fs(), from, filen);
		if (iTestFile.Open(Fs(), filen, EFileWrite)==KErrNone) {
			iTestFileOpen=true;
		}
	}
	return;

	/*
	if (IsDisplayingMenuOrDialog()) return;

	CALLSTACKITEM(_L("CContext_logAppUi::DialogTest"));

	CCoeEnv *env = CEikonEnv::Static();
	RPbkViewResourceFile pbkRes( *env);
	pbkRes.OpenL();
	CleanupClosePushL(pbkRes);

	CPbkContactEngine *ipPabEng=CPbkContactEngine::NewL();
	CleanupStack::PushL(ipPabEng);

	CPbkContactItem* aContactItem = ipPabEng->ReadContactL( 1 );
	CleanupStack::PushL(aContactItem);

	// launch the contacts dialog
	CPbkContactEditorDlg *ipPabDlg =
	CPbkContactEditorDlg::NewL(*ipPabEng, *aContactItem, EFalse);

	ipPabDlg->SetMopParent( this );

	TInt res = KErrNone;
	TRAPD( err, res = ipPabDlg->ExecuteLD());

	
	//CPbkSelectFieldDlg *d=new (ELeave) CPbkSelectFieldDlg;
	//TPbkContactItemField* res=d->ExecuteLD(aContactItem->CardFields(), R_AVKON_SOFTKEYS_OPTIONS_BACK);
	

	CleanupStack::PopAndDestroy(3); //engine, pbkRes, aContactItem
	*/
}

void CContext_logAppUi::start_app(TUid app, TInt view)
{
	CALLSTACKITEM(_L("CContext_logAppUi::start_app"));

	if (view==0) {
		RApaLsSession ls;
		User::LeaveIfError(ls.Connect());
		CleanupClosePushL(ls);

		TThreadId tid;

		User::LeaveIfError( ls.StartDocument(_L(""), app, tid) );

		CleanupStack::PopAndDestroy();
	} else {
		CCoeAppUi::ActivateViewL(TVwsViewId(app, TUid::Uid(view)));
	}
}

void CContext_logAppUi::NotifyNewPresence(const MPresenceData* d)
{
	CALLSTACKITEM(_L("CContext_logAppUi::NotifyNewPresence"));


	TTime now; now.HomeTime();

	PresenceToListBoxL(d, iUserContext,
		iCaptionMyContext, 0, prev, not_avail);

	iUserContextLog->AddL(*iUserContext);
}

void CContext_logAppUi::SettingChanged(TInt Setting)
{
	if (Setting==SETTING_LOGGING_ENABLE) {
		TApaTaskList tl(Ws());
		TApaTask booktask=tl.FindApp(KUidcontextbook);
		if (booktask.Exists()) {
			booktask.SendSystemEvent(EApaSystemEventShutdown);
		}
	}
}

void CContext_logAppUi::Error(TInt aCode, const TDesC& aDescription)
{
	TBuf<100> msg=aDescription;
	msg.Append(_L(": "));
	msg.AppendNum(aCode);
	error(msg);
}

void CContext_logAppUi::Taken(const TDesC& aFileName)
{
	if (0) {
		TBuf<100> err;
		TInt ret=iMMS->SendMessage(_L("0415601669"), _L("SnapShot!"), aFileName, err, false);
		if (ret!=KErrNone) Error(ret, err);
		else status_change(_L("message sent"));
	} else {
		TBuf<200> msg=_L("pic taken ");
		msg.Append(aFileName);
		status_change(msg);
	}
}

void CContext_logAppUi::Info(const TDesC& aMsg)
{
	status_change(aMsg);
}


// End of File  
