/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


/*
* ============================================================================
*  Name     : CContext_logContainer from Context_logContainer.h
*  Part of  : context_log
*  Created  : 13.2.2003 by 
*  Implementation notes:
*     Initial content was generated by Series 60 AppWizard.
*  Version  :
*  Copyright: 
* ============================================================================
*/

// INCLUDE FILES
#include "Context_logContainer.h"

#include <eiklabel.h>  // for example label control
#include <eikenv.h>

#include "cl_settings.h"


// ================= MEMBER FUNCTIONS =======================

void CContext_logContainer::register_source(const TDesC& name, const TDesC& initial_value, const TTime& time)
{
	CALLSTACKITEM(_L("CContext_logContainer::register_source"));

	if (! name.Compare(KLog_cellid) ) {
		register_source(_L("cell name"), _L(""), time);
	}

	CEikLabel* label;
	
	int this_label_index=label_store->Count()+1;

	label = new (ELeave) CEikLabel;
	CleanupStack::PushL(label);
	label->SetContainerWindowL( *this );
	label->SetFont(CEikonEnv::Static()->DenseFont());
	label->SetTextL( name );
	log_labels.addL(name, label);
	label_store->AppendL(label);
	CleanupStack::Pop();
	label->SetExtent( TPoint(10, this_label_index*12), TSize(50, 12));
	
	
	label = new (ELeave) CEikLabel;
	CleanupStack::PushL(label);
	label->SetContainerWindowL( *this );
	label->SetFont(CEikonEnv::Static()->DenseFont());
	label->SetTextL( initial_value );
	log_values.addL(name, label);
	value_store->AppendL(label);
	CleanupStack::Pop();
	label->SetExtent( TPoint(65, this_label_index*12), TSize(100, 12));
	
	if (initial_value.Length()) {
		new_value(Mlogger::VALUE, name, initial_value, time);
	}
	DrawNow();
}

void delete_bufc(void* data)
{
	HBufC* p;
	p=(HBufC*)data;
	delete p;
}

CContext_logContainer::CContext_logContainer(MApp_context& Context, CCellMap& CellMap) : 
	Mlog_base_impl(Context), iCellMap(CellMap)
{
	CALLSTACKITEM(_L("CContext_logContainer::CContext_logContainer"));

}

void CContext_logContainer::new_value(log_priority priority, const TDesC& name, const TDesC& value, const TTime& /*time*/)
{
	CALLSTACKITEM(_L("CContext_logContainer::new_value"));


	CEikLabel* label;
	label=(CEikLabel*)log_values.find(name);
		
	if (! name.Compare(KLog_cellid) && priority==Mlogger::VALUE) {
		TInt id=iCellMap.GetId(value);
		HBufC* user_given_name=0;
		user_given_name=(HBufC*)cellid_names->GetData(id);
		CEikLabel* name_label=(CEikLabel*)log_values.find(_L("cell name"));
		if (user_given_name) {
			current_name=*user_given_name;
			if (name_label) {
				name_label->SetTextL(*user_given_name);
				if (value.Compare(current_base)) 
					name_label->SetUnderlining(EFalse);
				else
					name_label->SetUnderlining(ETrue);
			}
		} else {
			TBuf<200> tmp;
			if (current_name.Length()) {
				tmp.Format(_L("last: %S"), &current_name);
			}
			if (name_label) name_label->SetTextL(tmp);
			name_label->SetUnderlining(EFalse);
		}
	}
	label->SetTextL(value);
	DrawNow();
}

void CContext_logContainer::unregister_source(const TDesC& /*name*/, const TTime& /*time*/)
{
	CALLSTACKITEM(_L("CContext_logContainer::unregister_source"));

	//TODO
}

void CContext_logContainer::add_cellid_name(const TDesC& cellid, const TDesC& name)
{
	CALLSTACKITEM(_L("CContext_logContainer::add_cellid_name"));

	HBufC* n=HBufC::NewL(name.Length());
	CleanupStack::PushL(n);
	*n=name;
	TInt id=iCellMap.GetId(cellid);
	cellid_names->AddDataL(id, (void*)n, true); 
	CleanupStack::Pop(); // n

	CEikLabel* label=(CEikLabel*)log_values.find(_L("cell name"));
	CEikLabel* id_label=(CEikLabel*)log_values.find(KLog_cellid);
	if (label && id_label && (! id_label->Text()->Compare(cellid))) {
		label->SetTextL(name);
		DrawNow();
	}
	label=(CEikLabel*)log_values.find(_L("base"));
	if (label) {
		label->SetTextL(name);
		DrawNow();
	}
	TInt id_for_cell=iCellMap.GetId(cellid);
	TTime now; now.HomeTime();

	if (id_for_cell==current_cell) {
		now_at_location(cellid, id_for_cell, iLastAtBase, false, now);
	}
}

bool CContext_logContainer::is_named(const TInt id)
{
	CALLSTACKITEM(_L("CContext_logContainer::is_named"));

	if (cellid_names->GetData(id)) return true;
	return false;
}

void CContext_logContainer::now_at_location(const TDesC& cellid, TInt id, bool is_base, bool loc_changed, TTime time)
{
	CALLSTACKITEM(_L("CContext_logContainer::now_at_location"));

	current_cell=id;

	if (is_base) {
		current_base=cellid;
	}

	TBuf<120> tmp; TBuf<120> prev;
	if (iFirstLoc) {
		/*
		 * get the stored last base and post
		 */
		if (iPrevBase.Length()>0) {
			tmp=_L("last: ");
			tmp.Append(iPrevBase);
			post_new_value(tmp, iPrevBaseStamp);
			prev=tmp;
		}
	}

	// FIXME: why was this done?
	// post_new_value(tmp, iBaseStamp);

	if (loc_changed || iFirstLoc || iLastBase.Length()==0) {
		if ( is_base ) {
			if (loc_changed) iBaseStamp=time;
			Settings().WriteSettingL(SETTING_LAST_BASE_STAMP, iBaseStamp);
			iLastAtBase=true;
			HBufC* name=(HBufC*)cellid_names->GetData(id);
			if (name) iLastBase=*name;
			else {
				TInt id_for_cell=iCellMap.GetId(cellid);
				name=(HBufC*)cellid_names->GetData(id_for_cell);
				if (name) 
					iLastBase=*name;
				else
					iLastBase=_L("");
			}
			iLastAtBase=true;
			post_new_value(iLastBase, iBaseStamp);
		} else if (iLastAtBase && iLastBase.Length()>0) {
			iPrevBase=iLastBase;
			iPrevBaseStamp=time;
			Settings().WriteSettingL(SETTING_PREV_BASE_STAMP, iPrevBaseStamp);
			Settings().WriteSettingL(SETTING_PREV_BASE, iPrevBase);
			tmp=_L("last: ");
			tmp.Append(iPrevBase);
			post_new_value(tmp, iPrevBaseStamp);
		}
	}

	iFirstLoc=false;
}

// ---------------------------------------------------------
// CContext_logContainer::ConstructL(const TRect& aRect)
// EPOC two phased constructor
// ---------------------------------------------------------
//
void CContext_logContainer::ConstructL(const TRect& aRect)
{
	CALLSTACKITEM(_L("CContext_logContainer::ConstructL"));

	Settings().GetSettingL(SETTING_PREV_BASE, iPrevBase);
	Settings().GetSettingL(SETTING_PREV_BASE_STAMP, iPrevBaseStamp);
	iFirstLoc=true;

	cellid_names=CGenericIntMap::NewL();
	cellid_names->SetDeletor(delete_bufc);

	Settings().GetSettingL(SETTING_LAST_BASE_STAMP, iBaseStamp);
	CreateWindowL();
	
	label_store=new (ELeave) CArrayFixFlat<CEikLabel*>(1);
	value_store=new (ELeave) CArrayFixFlat<CEikLabel*>(1);
	log_labels.ConstructL();
	log_values.ConstructL();
	
	status_label=new (ELeave) CEikLabel;
	status_label->SetContainerWindowL(*this);
	status_label->SetFont(CEikonEnv::Static()->DenseFont());
	status_label->SetTextL( _L("starting") );
	status_label->SetExtent(TPoint(10, 108), status_label->MinimumSize());
	
	err_label=new (ELeave) CEikLabel;
	err_label->SetContainerWindowL(*this);
	err_label->SetFont(CEikonEnv::Static()->DenseFont());
	err_label->SetTextL( _L("    ") );
	err_label->SetExtent(TPoint(10, 120), err_label->MinimumSize());

	Mlog_base_impl::ConstructL(KLog_cellname, _L("%S"));

	SetRect(aRect);
	ActivateL();
}

const TDesC& CContext_logContainer::get_value()
{
	CALLSTACKITEM(_L("CContext_logContainer::get_value"));

	return current_name;
}


// Destructor
CContext_logContainer::~CContext_logContainer()
{
	CALLSTACKITEM(_L("CContext_logContainer::~CContext_logContainer"));

	delete iLabel;
	delete status_label;
	delete err_label;
	if (label_store) {
		TInt count=label_store->Count();
		for (int i=count-1; i>=0; i--)  {
			delete (*label_store)[i];
		}
		delete label_store;
	}
	if (value_store) {
		TInt count=value_store->Count();
		for (int i=count-1; i>=0; i--)  {
			delete (*value_store)[i];
		}
		delete value_store;
	}
	delete cellid_names;
}

void CContext_logContainer::set_status(const TDesC& status)
{
	CALLSTACKITEM(_L("CContext_logContainer::set_status"));

	status_label->SetTextL(status);
	status_label->SetExtent(TPoint(10, 108), status_label->MinimumSize());
	DrawNow();
}

void CContext_logContainer::set_error(const TDesC& err)
{
	CALLSTACKITEM(_L("CContext_logContainer::set_error"));

	err_label->SetTextL(err);
	err_label->SetExtent(TPoint(10, 120), err_label->MinimumSize());
	DrawNow();
}

// ---------------------------------------------------------
// CContext_logContainer::SizeChanged()
// Called by framework when the view size is changed
// ---------------------------------------------------------
//
void CContext_logContainer::SizeChanged()
{
	CALLSTACKITEM(_L("CContext_logContainer::SizeChanged"));

	// TODO: Add here control resize code etc.
	//iLabel->SetExtent( TPoint(10,10), iLabel->MinimumSize() );
	status_label->SetExtent(TPoint(10, 108), status_label->MinimumSize());
	err_label->SetExtent(TPoint(10, 120), status_label->MinimumSize());
	
	if (!label_store) return;
	
	for (int i=0; i<label_store->Count(); i++)  {
		(*label_store)[i]->SetExtent( TPoint(10, (i)*12), TSize(50, 12) );
		(*value_store)[i]->SetExtent( TPoint(65, (i)*12), 
			(*value_store)[i]->MinimumSize() );
	}	
}

// ---------------------------------------------------------
// CContext_logContainer::CountComponentControls() const
// ---------------------------------------------------------
//
TInt CContext_logContainer::CountComponentControls() const
{
	CALLSTACKITEM(_L("CContext_logContainer::CountComponentControls"));

	if (!label_store) return 2;
	
	return label_store->Count()+value_store->Count()+2; // return nbr of controls inside this container
}

// ---------------------------------------------------------
// CContext_logContainer::ComponentControl(TInt aIndex) const
// ---------------------------------------------------------
//
CCoeControl* CContext_logContainer::ComponentControl(TInt aIndex) const
{
	CALLSTACKITEM(_L("CContext_logContainer::ComponentControl"));

	if (aIndex==0) {
		return status_label;
	}
	--aIndex;

	if (aIndex==0) {
		return err_label;
	} else if (label_store && aIndex>0 && aIndex <= label_store->Count()) {
		return (*label_store)[aIndex-1];
	} else if (label_store && aIndex>label_store->Count() && aIndex <= 
		label_store->Count()+value_store->Count()) {
		return (*value_store)[aIndex-label_store->Count()-1];
	} else {
		return NULL;
	}
}


// ---------------------------------------------------------
// CContext_logContainer::Draw(const TRect& aRect) const
// ---------------------------------------------------------
//
void CContext_logContainer::Draw(const TRect& aRect) const
{
	CALLSTACKITEM(_L("CContext_logContainer::Draw"));

	CWindowGc& gc = SystemGc();
	// TODO: Add your drawing code here
	// example code...
	gc.SetPenStyle(CGraphicsContext::ENullPen);
	gc.SetBrushColor(KRgbGray);
	gc.SetBrushStyle(CGraphicsContext::ESolidBrush);
	gc.DrawRect(aRect);
}

// ---------------------------------------------------------
// CContext_logContainer::HandleControlEventL(
//     CCoeControl* aControl,TCoeEvent aEventType)
// ---------------------------------------------------------
//
void CContext_logContainer::HandleControlEventL(
						CCoeControl* /*aControl*/,TCoeEvent /*aEventType*/)
{
	CALLSTACKITEM(_L("CContext_logContainer::HandleControlEventL"));

	// TODO: Add your control event handler code here
}

_LIT(CLASS_NAME, "CContext_logContainer");

const TDesC& CContext_logContainer::name() const
{
	CALLSTACKITEM(_L("CContext_logContainer::name"));

	return CLASS_NAME;
}

// End of File  
