/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#include "circular.h"
#include "symbian_auto_ptr.h"

#include "app_context.h"

CCircularLog* CCircularLog::NewL(int Size, bool Reverse)
{
	CALLSTACKITEM(_L("CCircularLog::NewL"));

	auto_ptr<CCircularLog> ret(new (ELeave) CCircularLog(Reverse));
	ret->ConstructL(Size);
	return ret.release();
}

void CCircularLog::AddL(const TDesC& String)
{
	CALLSTACKITEM(_L("CCircularLog::AddL"));

	if (iCount<iSize) {
		iCount++;
		iArray->AppendL(String);
	} else {
		iArray->Delete(iPos-1);
		iArray->InsertL(iPos-1, String);
		iPos++;
		if (iPos>iSize) iPos=1;
	}
	if (iObserver) iObserver->ContentsChanged();
}

CCircularLog::~CCircularLog()
{
	CALLSTACKITEM(_L("CCircularLog::~CCircularLog"));

	delete iArray;
}

CCircularLog::CCircularLog(bool Reverse)
{
	CALLSTACKITEM(_L("CCircularLog::CCircularLog"));

	iReverse=Reverse;
}

void CCircularLog::ConstructL(int Size)
{
	CALLSTACKITEM(_L("CCircularLog::ConstructL"));

	iArray=new (ELeave) CDesCArrayFlat(Size);
	iSize=Size;
	iPos=1;
}

TInt CCircularLog::MdcaCount() const
{
	CALLSTACKITEM(_L("CCircularLog::MdcaCount"));

	return iCount;
}

TPtrC16 CCircularLog::MdcaPoint(TInt aIndex) const
{
	CALLSTACKITEM(_L("CCircularLog::MdcaPoint"));

	int idx;
	if (!iReverse) {
		idx=aIndex+iPos;
		if (idx>=iCount) idx-=iCount+1;
	} else {
		if (iPos==1) {
			idx=iCount-aIndex-1;
		} else {
			idx=iPos-aIndex-2;
			if (idx<0) idx+=iCount;
		}
	}
	return iArray->MdcaPoint(idx);
}

void CCircularLog::SetObserver(MListObserver* Observer)
{
	CALLSTACKITEM(_L("CCircularLog::SetObserver"));

	iObserver=Observer;
}