#include "cl_settings.h"

#ifdef USE_LOCAL_DEFAULTS
#include "local_defaults.h"
#else

#define DEFAULT_PRESENCE_ENABLE	1
#define DEFAULT_UPLOAD_URLBASE L"http://db.cs.helsinki.fi/~mraento/cgi-bin/"
#define DEFAULT_OPTIONS_ENABLE 0
#define DEFAULT_DELETE_UPLOADED 1
#define DEFAULT_LOGGING_ENABLE 1
#define DEFAULT_LOCATIONSERVICE_ENABLE 1
#define DEFAULT_BT_SCAN_INTERVAL 5*60
#define DEFAULT_RECORD_ALL 0
#define DEFAULT_LOG_UPLOAD_ENABLE 1
#define DEFAULT_PICTURE_ENABLE 0
#define DEFAULT_TAG_ONLY 1
#define DEFAULT_PROMPT_FOR_NAMES 1

#endif

const TSettingItem TClSettings::KClSettings[] = {
	{ 0, EEmpty, 0, -1, EFalse },	// no setting 0
	{ SETTING_WAP_AP, EAP, 0, -1, EFalse },
	{ SETTING_PHONENO, EString, 0, -1, EFalse },	// not in use
	{ SETTING_IP_AP, EAP, 0, -1, EFalse },	 
	{ SETTING_LAST_COMMLOG_UPLOAD, ETime, 0, 0, ETrue },	 
	{ SETTING_CELLMAP_CLOSED, EBool, 0, 1, ETrue },	 
	{ SETTING_BASEDB_VERSION, EInt, 0, 4, ETrue },	 
	{ SETTING_JABBER_NICK, EString, 0, -1, EFalse },	 
	{ SETTING_JABBER_PASS, EString, 0, -1, EFalse },	 
	{ SETTING_PRESENCE_ENABLE, EBool, 0, DEFAULT_PRESENCE_ENABLE, ETrue },
	/*10*/ 
	{ SETTING_LAST_BASE_STAMP, ETime, 0, -1, EFalse },
	{ SETTING_PICTURE_ENABLE, EBool, 0, DEFAULT_PICTURE_ENABLE, ETrue },
	{ SETTING_UPLOAD_URLBASE, EString, DEFAULT_UPLOAD_URLBASE, -1, ETrue },
	{ SETTING_PREV_BASE, EString, 0, -1, EFalse },
	{ SETTING_PREV_BASE_STAMP, ETime, 0, -1, EFalse },
	{ SETTING_UPLOAD_TAG, EString, 0, -1, EFalse },
	{ SETTING_OPTIONS_ENABLE, EBool, 0, DEFAULT_OPTIONS_ENABLE, ETrue },
	{ SETTING_DELETE_UPLOADED, EBool, 0, DEFAULT_DELETE_UPLOADED, ETrue },
	{ SETTING_LOGGING_ENABLE, EBool, 0, DEFAULT_LOGGING_ENABLE, ETrue },
	{ SETTING_LOCATIONSERVICE_ENABLE, EBool, 0, DEFAULT_LOCATIONSERVICE_ENABLE, ETrue },
	/*20*/ 
	{ SETTING_BT_SCAN_INTERVAL, EInt, 0, DEFAULT_BT_SCAN_INTERVAL, ETrue },
	{ SETTING_RECORD_ALL, EBool, 0, DEFAULT_RECORD_ALL, ETrue },
	{ SETTING_LOG_UPLOAD_ENABLE, EBool, 0, DEFAULT_LOG_UPLOAD_ENABLE, ETrue },
	{ SETTING_TAG_ONLY, EBool, 0, DEFAULT_TAG_ONLY, ETrue },
	{ SETTING_PROMPT_FOR_NAMES, EBool, 0, DEFAULT_PROMPT_FOR_NAMES, ETrue },
};

bool TClSettings::GetDefaultL(TInt Setting, TDes& Value) const
{
	const TSettingItem i=KClSettings[Setting];
	if (i.iSettingNo!=Setting) User::Leave(-1025);

	if (i.iStringDefault) {
		Value=TPtrC((TText*)i.iStringDefault);
	} else {
		Value.Zero();
	}
	return i.iDefaultExists;
}

bool TClSettings::GetDefaultL(TInt Setting, TInt& Value) const
{
	const TSettingItem i=KClSettings[Setting];
	if (i.iSettingNo!=Setting) User::Leave(-1025);

	Value=i.iIntDefault;
	return i.iDefaultExists;
}

bool TClSettings::GetDefaultL(TInt Setting, TTime& Value) const
{
	const TSettingItem i=KClSettings[Setting];
	if (i.iSettingNo!=Setting) User::Leave(-1025);

	Value=i.iIntDefault;
	return i.iDefaultExists;
}
