#include "hideview.h"

#include "context_log.rsg"
#include <aknviewappui.h>
#include <eiklabel.h>
#include "symbian_auto_ptr.h"
#include "context_log.hrh"
#include "app_context.h"

class CHideContainer : public CCoeControl {
public:
	CHideContainer(CAknViewAppUi* AppUi);
	~CHideContainer();
	void ConstructL(const TRect& aRect);

private:
        void SizeChanged();
        TInt CountComponentControls() const;
        CCoeControl* ComponentControl(TInt aIndex) const;
        void Draw(const TRect& aRect) const;
	TKeyResponse OfferKeyEventL(const TKeyEvent &aKeyEvent, TEventCode aType);

	CArrayPtrFlat< CCoeControl > *iControls;
	TInt				iPresses;
	CAknViewAppUi*			iAppUi;
};

class CHideViewImpl : public CHideView {
private:
	CHideViewImpl();
	void ConstructL();

        TUid Id() const;
	
        void HandleCommandL(TInt aCommand);
        void DoActivateL(const TVwsViewId& aPrevViewId,
		TUid aCustomMessageId,
		const TDesC8& aCustomMessage);
        void DoDeactivate();

	friend class CHideView;
	CHideContainer* iContainer;
public:
	virtual ~CHideViewImpl();
};

EXPORT_C CHideView* CHideView::NewL()
{
	CALLSTACKITEM(_L("CHideView::NewL"));

	auto_ptr<CHideViewImpl> ret(new (ELeave) CHideViewImpl());
	ret->ConstructL();
	return ret.release();
}

CHideContainer::CHideContainer(CAknViewAppUi* AppUi) : iAppUi(AppUi)
{
}

CHideContainer::~CHideContainer()
{
	CALLSTACKITEM(_L("CHideContainer::~CHideContainer"));

	if (iControls) iControls->ResetAndDestroy();
	delete iControls;

}

TKeyResponse CHideContainer::OfferKeyEventL(const TKeyEvent &aKeyEvent, TEventCode aType)
{
	CALLSTACKITEM(_L("CHideContainer::OfferKeyEventL"));

	if (aType==EEventKey) {
		if (aKeyEvent.iCode=='5') {
			iPresses++;
			if (iPresses==3) {
				iAppUi->HandleCommandL(Econtext_logDetailedView);
			}
		} else {
			iPresses=0;
		}
	}
	return EKeyWasNotConsumed;
}

void CHideContainer::ConstructL(const TRect& aRect)
{
	CALLSTACKITEM(_L("CHideContainer::ConstructL"));

	iControls=new (ELeave) CArrayPtrFlat< CCoeControl >(1);
	CreateWindowL();

	TRect r(aRect);
	r.Move(10, 10); r.Resize(-20, -20);

	CEikLabel *l=new (ELeave) CEikLabel;
	iControls->AppendL(l);
	l->SetContainerWindowL( *this );
	l->SetRect(r);

	TBuf<100> msg;
	iEikonEnv->ReadResourceAsDes16(msg, R_HIDE_MESSAGE);
	l->SetTextL(msg); 

	SetRect(aRect);
	ActivateL();	
}

void CHideContainer::SizeChanged()
{
	CALLSTACKITEM(_L("CHideContainer::SizeChanged"));

}

TInt CHideContainer::CountComponentControls() const
{
	CALLSTACKITEM(_L("CHideContainer::CountComponentControls"));

	return iControls->Count();
}

CCoeControl* CHideContainer::ComponentControl(TInt aIndex) const
{
	CALLSTACKITEM(_L("CHideContainer::ComponentControl"));

	return iControls->At(aIndex);
}

void CHideContainer::Draw(const TRect& aRect) const
{
	CALLSTACKITEM(_L("CHideContainer::Draw"));

	CWindowGc& gc = SystemGc();
	// TODO: Add your drawing code here
	// example code...
	gc.SetPenStyle(CGraphicsContext::ENullPen);
	gc.SetBrushColor(KRgbWhite);
	gc.SetBrushStyle(CGraphicsContext::ESolidBrush);
	gc.DrawRect(aRect);

}

CHideViewImpl::CHideViewImpl()
{

}

void CHideViewImpl::ConstructL()
{
	CALLSTACKITEM(_L("CHideViewImpl::ConstructL"));

	BaseConstructL( R_HIDE_VIEW );
}

TUid CHideViewImpl::Id() const
{
	CALLSTACKITEM(_L("CHideViewImpl::Id"));

	return KHideView;
}

void CHideViewImpl::HandleCommandL(TInt aCommand)
{
	CALLSTACKITEM(_L("CHideViewImpl::HandleCommandL"));
	AppUi()->HandleCommandL(aCommand);

}

void CHideViewImpl::DoActivateL(const TVwsViewId& /*aPrevViewId*/,
	TUid /*aCustomMessageId*/,
	const TDesC8& /*aCustomMessage*/)
{
	CALLSTACKITEM(_L("CHideViewImpl::DoActivateL"));

	if (!iContainer) {
		iContainer=new (ELeave) CHideContainer(AppUi());
		iContainer->SetMopParent(this);
		iContainer->ConstructL(ClientRect());
		AppUi()->AddToStackL( *this, iContainer );
        } 
}

void CHideViewImpl::DoDeactivate()
{
	CALLSTACKITEM(_L("CHideViewImpl::DoDeactivate"));

	if ( iContainer )
        {
		AppUi()->RemoveFromViewStack( *this, iContainer );
        }
	
	delete iContainer;
	iContainer = 0;
}

CHideViewImpl::~CHideViewImpl()
{
	CALLSTACKITEM(_L("CHideViewImpl::~CHideViewImpl"));

	delete iContainer;
}
